@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [FileSystem].
 */
@PulumiTagMarker
public class FileSystemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FileSystemArgs = FileSystemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FileSystemArgsBuilder.() -> Unit) {
        val builder = FileSystemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FileSystem {
        val builtJavaResource = com.pulumi.alicloud.nas.FileSystem(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FileSystem(builtJavaResource)
    }
}

/**
 * Provides a Nas File System resource.
 * After activating NAS, you can create a file system and purchase a storage package for it in the NAS console. The NAS console also enables you to view the file system details and remove unnecessary file systems.
 * For information about NAS file system and how to use it, see [Manage file systems](https://www.alibabacloud.com/help/doc-detail/27530.htm)
 * > **NOTE:** Available in v1.33.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.nas.getZones({
 *     fileSystemType: "standard",
 * });
 * const foo = new alicloud.nas.FileSystem("foo", {
 *     protocolType: "NFS",
 *     storageType: "Performance",
 *     description: "terraform-example",
 *     encryptType: 1,
 *     zoneId: example.then(example => example.zones?.[0]?.zoneId),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.nas.get_zones(file_system_type="standard")
 * foo = alicloud.nas.FileSystem("foo",
 *     protocol_type="NFS",
 *     storage_type="Performance",
 *     description="terraform-example",
 *     encrypt_type=1,
 *     zone_id=example.zones[0].zone_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.Nas.GetZones.Invoke(new()
 *     {
 *         FileSystemType = "standard",
 *     });
 *     var foo = new AliCloud.Nas.FileSystem("foo", new()
 *     {
 *         ProtocolType = "NFS",
 *         StorageType = "Performance",
 *         Description = "terraform-example",
 *         EncryptType = 1,
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[0]?.ZoneId),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := nas.GetZones(ctx, &nas.GetZonesArgs{
 * 			FileSystemType: pulumi.StringRef("standard"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewFileSystem(ctx, "foo", &nas.FileSystemArgs{
 * 			ProtocolType: pulumi.String("NFS"),
 * 			StorageType:  pulumi.String("Performance"),
 * 			Description:  pulumi.String("terraform-example"),
 * 			EncryptType:  pulumi.Int(1),
 * 			ZoneId:       pulumi.String(example.Zones[0].ZoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.NasFunctions;
 * import com.pulumi.alicloud.nas.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = NasFunctions.getZones(GetZonesArgs.builder()
 *             .fileSystemType("standard")
 *             .build());
 *         var foo = new FileSystem("foo", FileSystemArgs.builder()
 *             .protocolType("NFS")
 *             .storageType("Performance")
 *             .description("terraform-example")
 *             .encryptType("1")
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[0].zoneId()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: alicloud:nas:FileSystem
 *     properties:
 *       protocolType: NFS
 *       storageType: Performance
 *       description: terraform-example
 *       encryptType: '1'
 *       zoneId: ${example.zones[0].zoneId}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:nas:getZones
 *       Arguments:
 *         fileSystemType: standard
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.nas.getZones({
 *     fileSystemType: "extreme",
 * });
 * const foo = new alicloud.nas.FileSystem("foo", {
 *     fileSystemType: "extreme",
 *     protocolType: "NFS",
 *     zoneId: example.then(example => example.zones?.[0]?.zoneId),
 *     storageType: "standard",
 *     capacity: 100,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.nas.get_zones(file_system_type="extreme")
 * foo = alicloud.nas.FileSystem("foo",
 *     file_system_type="extreme",
 *     protocol_type="NFS",
 *     zone_id=example.zones[0].zone_id,
 *     storage_type="standard",
 *     capacity=100)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.Nas.GetZones.Invoke(new()
 *     {
 *         FileSystemType = "extreme",
 *     });
 *     var foo = new AliCloud.Nas.FileSystem("foo", new()
 *     {
 *         FileSystemType = "extreme",
 *         ProtocolType = "NFS",
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[0]?.ZoneId),
 *         StorageType = "standard",
 *         Capacity = 100,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := nas.GetZones(ctx, &nas.GetZonesArgs{
 * 			FileSystemType: pulumi.StringRef("extreme"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewFileSystem(ctx, "foo", &nas.FileSystemArgs{
 * 			FileSystemType: pulumi.String("extreme"),
 * 			ProtocolType:   pulumi.String("NFS"),
 * 			ZoneId:         pulumi.String(example.Zones[0].ZoneId),
 * 			StorageType:    pulumi.String("standard"),
 * 			Capacity:       pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.NasFunctions;
 * import com.pulumi.alicloud.nas.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = NasFunctions.getZones(GetZonesArgs.builder()
 *             .fileSystemType("extreme")
 *             .build());
 *         var foo = new FileSystem("foo", FileSystemArgs.builder()
 *             .fileSystemType("extreme")
 *             .protocolType("NFS")
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[0].zoneId()))
 *             .storageType("standard")
 *             .capacity("100")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: alicloud:nas:FileSystem
 *     properties:
 *       fileSystemType: extreme
 *       protocolType: NFS
 *       zoneId: ${example.zones[0].zoneId}
 *       storageType: standard
 *       capacity: '100'
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:nas:getZones
 *       Arguments:
 *         fileSystemType: extreme
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.nas.getZones({
 *     fileSystemType: "cpfs",
 * });
 * const exampleNetwork = new alicloud.vpc.Network("example", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vswitchName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: exampleNetwork.id,
 *     zoneId: example.then(example => example.zones?.[1]?.zoneId),
 * });
 * const exampleFileSystem = new alicloud.nas.FileSystem("example", {
 *     protocolType: "cpfs",
 *     storageType: "advance_200",
 *     fileSystemType: "cpfs",
 *     capacity: 3600,
 *     zoneId: example.then(example => example.zones?.[1]?.zoneId),
 *     vpcId: exampleNetwork.id,
 *     vswitchId: exampleSwitch.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.nas.get_zones(file_system_type="cpfs")
 * example_network = alicloud.vpc.Network("example",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * example_switch = alicloud.vpc.Switch("example",
 *     vswitch_name="terraform-example",
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=example_network.id,
 *     zone_id=example.zones[1].zone_id)
 * example_file_system = alicloud.nas.FileSystem("example",
 *     protocol_type="cpfs",
 *     storage_type="advance_200",
 *     file_system_type="cpfs",
 *     capacity=3600,
 *     zone_id=example.zones[1].zone_id,
 *     vpc_id=example_network.id,
 *     vswitch_id=example_switch.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.Nas.GetZones.Invoke(new()
 *     {
 *         FileSystemType = "cpfs",
 *     });
 *     var exampleNetwork = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VswitchName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = exampleNetwork.Id,
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[1]?.ZoneId),
 *     });
 *     var exampleFileSystem = new AliCloud.Nas.FileSystem("example", new()
 *     {
 *         ProtocolType = "cpfs",
 *         StorageType = "advance_200",
 *         FileSystemType = "cpfs",
 *         Capacity = 3600,
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[1]?.ZoneId),
 *         VpcId = exampleNetwork.Id,
 *         VswitchId = exampleSwitch.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := nas.GetZones(ctx, &nas.GetZonesArgs{
 * 			FileSystemType: pulumi.StringRef("cpfs"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleNetwork, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       exampleNetwork.ID(),
 * 			ZoneId:      pulumi.String(example.Zones[1].ZoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewFileSystem(ctx, "example", &nas.FileSystemArgs{
 * 			ProtocolType:   pulumi.String("cpfs"),
 * 			StorageType:    pulumi.String("advance_200"),
 * 			FileSystemType: pulumi.String("cpfs"),
 * 			Capacity:       pulumi.Int(3600),
 * 			ZoneId:         pulumi.String(example.Zones[1].ZoneId),
 * 			VpcId:          exampleNetwork.ID(),
 * 			VswitchId:      exampleSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.NasFunctions;
 * import com.pulumi.alicloud.nas.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = NasFunctions.getZones(GetZonesArgs.builder()
 *             .fileSystemType("cpfs")
 *             .build());
 *         var exampleNetwork = new Network("exampleNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vswitchName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(exampleNetwork.id())
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[1].zoneId()))
 *             .build());
 *         var exampleFileSystem = new FileSystem("exampleFileSystem", FileSystemArgs.builder()
 *             .protocolType("cpfs")
 *             .storageType("advance_200")
 *             .fileSystemType("cpfs")
 *             .capacity(3600)
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[1].zoneId()))
 *             .vpcId(exampleNetwork.id())
 *             .vswitchId(exampleSwitch.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleNetwork:
 *     type: alicloud:vpc:Network
 *     name: example
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vswitchName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *       vpcId: ${exampleNetwork.id}
 *       zoneId: ${example.zones[1].zoneId}
 *   exampleFileSystem:
 *     type: alicloud:nas:FileSystem
 *     name: example
 *     properties:
 *       protocolType: cpfs
 *       storageType: advance_200
 *       fileSystemType: cpfs
 *       capacity: 3600
 *       zoneId: ${example.zones[1].zoneId}
 *       vpcId: ${exampleNetwork.id}
 *       vswitchId: ${exampleSwitch.id}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:nas:getZones
 *       Arguments:
 *         fileSystemType: cpfs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Nas File System can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/fileSystem:FileSystem foo 1337849c59
 * ```
 */
public class FileSystem internal constructor(
    override val javaResource: com.pulumi.alicloud.nas.FileSystem,
) : KotlinCustomResource(javaResource, FileSystemMapper) {
    /**
     * The capacity of the file system. The `capacity` is required when the `file_system_type` is `extreme`.
     * Unit: gib; **Note**: The minimum value is 100.
     */
    public val capacity: Output<Int>
        get() = javaResource.capacity().applyValue({ args0 -> args0 })

    /**
     * The File System description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the file system is encrypted. Using kms service escrow key to encrypt and store the file system data. When reading and writing encrypted data, there is no need to decrypt.
     * * Valid values:
     */
    public val encryptType: Output<Int>?
        get() = javaResource.encryptType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * the type of the file system.
     * Valid values:
     * `standard` (Default),
     * `extreme`,
     * `cpfs`.
     */
    public val fileSystemType: Output<String>?
        get() = javaResource.fileSystemType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of the KMS key. The `kms_key_id` is required when the `encrypt_type` is `2`.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * The protocol type of the file system.
     * Valid values:
     * `NFS`,
     * `SMB` (Available when the `file_system_type` is `standard`),
     * `cpfs` (Available when the `file_system_type` is `cpfs`).
     */
    public val protocolType: Output<String>
        get() = javaResource.protocolType().applyValue({ args0 -> args0 })

    /**
     * The storage type of the file System.
     * * Valid values:
     * * `Performance` (Available when the `file_system_type` is `standard`)
     * * `Capacity` (Available when the `file_system_type` is `standard`)
     */
    public val storageType: Output<String>
        get() = javaResource.storageType().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The id of the VPC. The `vpc_id` is required when the `file_system_type` is `cpfs`.
     */
    public val vpcId: Output<String>?
        get() = javaResource.vpcId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The id of the vSwitch. The `vswitch_id` is required when the `file_system_type` is `cpfs`.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The available zones information that supports nas.When FileSystemType=standard, this parameter is not required. **Note:** By default, a qualified availability zone is randomly selected according to the `protocol_type` and `storage_type` configuration.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object FileSystemMapper : ResourceMapper<FileSystem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nas.FileSystem::class == javaResource::class

    override fun map(javaResource: Resource): FileSystem = FileSystem(
        javaResource as
            com.pulumi.alicloud.nas.FileSystem,
    )
}

/**
 * @see [FileSystem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FileSystem].
 */
public suspend fun fileSystem(name: String, block: suspend FileSystemResourceBuilder.() -> Unit): FileSystem {
    val builder = FileSystemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FileSystem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fileSystem(name: String): FileSystem {
    val builder = FileSystemResourceBuilder()
    builder.name(name)
    return builder.build()
}
