@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.alicloud.nas.FileSystemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Nas File System resource.
 * After activating NAS, you can create a file system and purchase a storage package for it in the NAS console. The NAS console also enables you to view the file system details and remove unnecessary file systems.
 * For information about NAS file system and how to use it, see [Manage file systems](https://www.alibabacloud.com/help/doc-detail/27530.htm)
 * > **NOTE:** Available in v1.33.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.nas.getZones({
 *     fileSystemType: "standard",
 * });
 * const foo = new alicloud.nas.FileSystem("foo", {
 *     protocolType: "NFS",
 *     storageType: "Performance",
 *     description: "terraform-example",
 *     encryptType: 1,
 *     zoneId: example.then(example => example.zones?.[0]?.zoneId),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.nas.get_zones(file_system_type="standard")
 * foo = alicloud.nas.FileSystem("foo",
 *     protocol_type="NFS",
 *     storage_type="Performance",
 *     description="terraform-example",
 *     encrypt_type=1,
 *     zone_id=example.zones[0].zone_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.Nas.GetZones.Invoke(new()
 *     {
 *         FileSystemType = "standard",
 *     });
 *     var foo = new AliCloud.Nas.FileSystem("foo", new()
 *     {
 *         ProtocolType = "NFS",
 *         StorageType = "Performance",
 *         Description = "terraform-example",
 *         EncryptType = 1,
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[0]?.ZoneId),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := nas.GetZones(ctx, &nas.GetZonesArgs{
 * 			FileSystemType: pulumi.StringRef("standard"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewFileSystem(ctx, "foo", &nas.FileSystemArgs{
 * 			ProtocolType: pulumi.String("NFS"),
 * 			StorageType:  pulumi.String("Performance"),
 * 			Description:  pulumi.String("terraform-example"),
 * 			EncryptType:  pulumi.Int(1),
 * 			ZoneId:       pulumi.String(example.Zones[0].ZoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.NasFunctions;
 * import com.pulumi.alicloud.nas.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = NasFunctions.getZones(GetZonesArgs.builder()
 *             .fileSystemType("standard")
 *             .build());
 *         var foo = new FileSystem("foo", FileSystemArgs.builder()
 *             .protocolType("NFS")
 *             .storageType("Performance")
 *             .description("terraform-example")
 *             .encryptType("1")
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[0].zoneId()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: alicloud:nas:FileSystem
 *     properties:
 *       protocolType: NFS
 *       storageType: Performance
 *       description: terraform-example
 *       encryptType: '1'
 *       zoneId: ${example.zones[0].zoneId}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:nas:getZones
 *       Arguments:
 *         fileSystemType: standard
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.nas.getZones({
 *     fileSystemType: "extreme",
 * });
 * const foo = new alicloud.nas.FileSystem("foo", {
 *     fileSystemType: "extreme",
 *     protocolType: "NFS",
 *     zoneId: example.then(example => example.zones?.[0]?.zoneId),
 *     storageType: "standard",
 *     capacity: 100,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.nas.get_zones(file_system_type="extreme")
 * foo = alicloud.nas.FileSystem("foo",
 *     file_system_type="extreme",
 *     protocol_type="NFS",
 *     zone_id=example.zones[0].zone_id,
 *     storage_type="standard",
 *     capacity=100)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.Nas.GetZones.Invoke(new()
 *     {
 *         FileSystemType = "extreme",
 *     });
 *     var foo = new AliCloud.Nas.FileSystem("foo", new()
 *     {
 *         FileSystemType = "extreme",
 *         ProtocolType = "NFS",
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[0]?.ZoneId),
 *         StorageType = "standard",
 *         Capacity = 100,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := nas.GetZones(ctx, &nas.GetZonesArgs{
 * 			FileSystemType: pulumi.StringRef("extreme"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewFileSystem(ctx, "foo", &nas.FileSystemArgs{
 * 			FileSystemType: pulumi.String("extreme"),
 * 			ProtocolType:   pulumi.String("NFS"),
 * 			ZoneId:         pulumi.String(example.Zones[0].ZoneId),
 * 			StorageType:    pulumi.String("standard"),
 * 			Capacity:       pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.NasFunctions;
 * import com.pulumi.alicloud.nas.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = NasFunctions.getZones(GetZonesArgs.builder()
 *             .fileSystemType("extreme")
 *             .build());
 *         var foo = new FileSystem("foo", FileSystemArgs.builder()
 *             .fileSystemType("extreme")
 *             .protocolType("NFS")
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[0].zoneId()))
 *             .storageType("standard")
 *             .capacity("100")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: alicloud:nas:FileSystem
 *     properties:
 *       fileSystemType: extreme
 *       protocolType: NFS
 *       zoneId: ${example.zones[0].zoneId}
 *       storageType: standard
 *       capacity: '100'
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:nas:getZones
 *       Arguments:
 *         fileSystemType: extreme
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.nas.getZones({
 *     fileSystemType: "cpfs",
 * });
 * const exampleNetwork = new alicloud.vpc.Network("example", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vswitchName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: exampleNetwork.id,
 *     zoneId: example.then(example => example.zones?.[1]?.zoneId),
 * });
 * const exampleFileSystem = new alicloud.nas.FileSystem("example", {
 *     protocolType: "cpfs",
 *     storageType: "advance_200",
 *     fileSystemType: "cpfs",
 *     capacity: 3600,
 *     zoneId: example.then(example => example.zones?.[1]?.zoneId),
 *     vpcId: exampleNetwork.id,
 *     vswitchId: exampleSwitch.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.nas.get_zones(file_system_type="cpfs")
 * example_network = alicloud.vpc.Network("example",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * example_switch = alicloud.vpc.Switch("example",
 *     vswitch_name="terraform-example",
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=example_network.id,
 *     zone_id=example.zones[1].zone_id)
 * example_file_system = alicloud.nas.FileSystem("example",
 *     protocol_type="cpfs",
 *     storage_type="advance_200",
 *     file_system_type="cpfs",
 *     capacity=3600,
 *     zone_id=example.zones[1].zone_id,
 *     vpc_id=example_network.id,
 *     vswitch_id=example_switch.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.Nas.GetZones.Invoke(new()
 *     {
 *         FileSystemType = "cpfs",
 *     });
 *     var exampleNetwork = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VswitchName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = exampleNetwork.Id,
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[1]?.ZoneId),
 *     });
 *     var exampleFileSystem = new AliCloud.Nas.FileSystem("example", new()
 *     {
 *         ProtocolType = "cpfs",
 *         StorageType = "advance_200",
 *         FileSystemType = "cpfs",
 *         Capacity = 3600,
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[1]?.ZoneId),
 *         VpcId = exampleNetwork.Id,
 *         VswitchId = exampleSwitch.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := nas.GetZones(ctx, &nas.GetZonesArgs{
 * 			FileSystemType: pulumi.StringRef("cpfs"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleNetwork, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       exampleNetwork.ID(),
 * 			ZoneId:      pulumi.String(example.Zones[1].ZoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewFileSystem(ctx, "example", &nas.FileSystemArgs{
 * 			ProtocolType:   pulumi.String("cpfs"),
 * 			StorageType:    pulumi.String("advance_200"),
 * 			FileSystemType: pulumi.String("cpfs"),
 * 			Capacity:       pulumi.Int(3600),
 * 			ZoneId:         pulumi.String(example.Zones[1].ZoneId),
 * 			VpcId:          exampleNetwork.ID(),
 * 			VswitchId:      exampleSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.NasFunctions;
 * import com.pulumi.alicloud.nas.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = NasFunctions.getZones(GetZonesArgs.builder()
 *             .fileSystemType("cpfs")
 *             .build());
 *         var exampleNetwork = new Network("exampleNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vswitchName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(exampleNetwork.id())
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[1].zoneId()))
 *             .build());
 *         var exampleFileSystem = new FileSystem("exampleFileSystem", FileSystemArgs.builder()
 *             .protocolType("cpfs")
 *             .storageType("advance_200")
 *             .fileSystemType("cpfs")
 *             .capacity(3600)
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[1].zoneId()))
 *             .vpcId(exampleNetwork.id())
 *             .vswitchId(exampleSwitch.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleNetwork:
 *     type: alicloud:vpc:Network
 *     name: example
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vswitchName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *       vpcId: ${exampleNetwork.id}
 *       zoneId: ${example.zones[1].zoneId}
 *   exampleFileSystem:
 *     type: alicloud:nas:FileSystem
 *     name: example
 *     properties:
 *       protocolType: cpfs
 *       storageType: advance_200
 *       fileSystemType: cpfs
 *       capacity: 3600
 *       zoneId: ${example.zones[1].zoneId}
 *       vpcId: ${exampleNetwork.id}
 *       vswitchId: ${exampleSwitch.id}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:nas:getZones
 *       Arguments:
 *         fileSystemType: cpfs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Nas File System can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/fileSystem:FileSystem foo 1337849c59
 * ```
 * @property capacity The capacity of the file system. The `capacity` is required when the `file_system_type` is `extreme`.
 * Unit: gib; **Note**: The minimum value is 100.
 * @property description The File System description.
 * @property encryptType Whether the file system is encrypted. Using kms service escrow key to encrypt and store the file system data. When reading and writing encrypted data, there is no need to decrypt.
 * * Valid values:
 * @property fileSystemType the type of the file system.
 * Valid values:
 * `standard` (Default),
 * `extreme`,
 * `cpfs`.
 * @property kmsKeyId The id of the KMS key. The `kms_key_id` is required when the `encrypt_type` is `2`.
 * @property protocolType The protocol type of the file system.
 * Valid values:
 * `NFS`,
 * `SMB` (Available when the `file_system_type` is `standard`),
 * `cpfs` (Available when the `file_system_type` is `cpfs`).
 * @property storageType The storage type of the file System.
 * * Valid values:
 * * `Performance` (Available when the `file_system_type` is `standard`)
 * * `Capacity` (Available when the `file_system_type` is `standard`)
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId The id of the VPC. The `vpc_id` is required when the `file_system_type` is `cpfs`.
 * @property vswitchId The id of the vSwitch. The `vswitch_id` is required when the `file_system_type` is `cpfs`.
 * @property zoneId The available zones information that supports nas.When FileSystemType=standard, this parameter is not required. **Note:** By default, a qualified availability zone is randomly selected according to the `protocol_type` and `storage_type` configuration.
 */
public data class FileSystemArgs(
    public val capacity: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val encryptType: Output<Int>? = null,
    public val fileSystemType: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val protocolType: Output<String>? = null,
    public val storageType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.FileSystemArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.FileSystemArgs =
        com.pulumi.alicloud.nas.FileSystemArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptType(encryptType?.applyValue({ args0 -> args0 }))
            .fileSystemType(fileSystemType?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .protocolType(protocolType?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileSystemArgs].
 */
@PulumiTagMarker
public class FileSystemArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var description: Output<String>? = null

    private var encryptType: Output<Int>? = null

    private var fileSystemType: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var protocolType: Output<String>? = null

    private var storageType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The capacity of the file system. The `capacity` is required when the `file_system_type` is `extreme`.
     * Unit: gib; **Note**: The minimum value is 100.
     */
    @JvmName("pvmvtoocltcfmgxj")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The File System description.
     */
    @JvmName("oieocoxtdjbofedl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether the file system is encrypted. Using kms service escrow key to encrypt and store the file system data. When reading and writing encrypted data, there is no need to decrypt.
     * * Valid values:
     */
    @JvmName("kxsxcamcftevsmac")
    public suspend fun encryptType(`value`: Output<Int>) {
        this.encryptType = value
    }

    /**
     * @param value the type of the file system.
     * Valid values:
     * `standard` (Default),
     * `extreme`,
     * `cpfs`.
     */
    @JvmName("cwyjwfyufleceedv")
    public suspend fun fileSystemType(`value`: Output<String>) {
        this.fileSystemType = value
    }

    /**
     * @param value The id of the KMS key. The `kms_key_id` is required when the `encrypt_type` is `2`.
     */
    @JvmName("vrutgxcbgvpdhykw")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The protocol type of the file system.
     * Valid values:
     * `NFS`,
     * `SMB` (Available when the `file_system_type` is `standard`),
     * `cpfs` (Available when the `file_system_type` is `cpfs`).
     */
    @JvmName("ksaltvtgrarufbww")
    public suspend fun protocolType(`value`: Output<String>) {
        this.protocolType = value
    }

    /**
     * @param value The storage type of the file System.
     * * Valid values:
     * * `Performance` (Available when the `file_system_type` is `standard`)
     * * `Capacity` (Available when the `file_system_type` is `standard`)
     */
    @JvmName("mwskmwceufydndor")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("hdfgspncnuihvxhg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The id of the VPC. The `vpc_id` is required when the `file_system_type` is `cpfs`.
     */
    @JvmName("rglbumrtbgphhfux")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The id of the vSwitch. The `vswitch_id` is required when the `file_system_type` is `cpfs`.
     */
    @JvmName("dvjtuygsbhcvtorr")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The available zones information that supports nas.When FileSystemType=standard, this parameter is not required. **Note:** By default, a qualified availability zone is randomly selected according to the `protocol_type` and `storage_type` configuration.
     */
    @JvmName("wxivevvjdexsaduy")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The capacity of the file system. The `capacity` is required when the `file_system_type` is `extreme`.
     * Unit: gib; **Note**: The minimum value is 100.
     */
    @JvmName("ykhbrqhvvmyfbjfk")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The File System description.
     */
    @JvmName("cbsdxwvpckltgfnm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether the file system is encrypted. Using kms service escrow key to encrypt and store the file system data. When reading and writing encrypted data, there is no need to decrypt.
     * * Valid values:
     */
    @JvmName("rpgqhaidbreqjocl")
    public suspend fun encryptType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptType = mapped
    }

    /**
     * @param value the type of the file system.
     * Valid values:
     * `standard` (Default),
     * `extreme`,
     * `cpfs`.
     */
    @JvmName("wqirdxvudhnxgfsp")
    public suspend fun fileSystemType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemType = mapped
    }

    /**
     * @param value The id of the KMS key. The `kms_key_id` is required when the `encrypt_type` is `2`.
     */
    @JvmName("fvxypkwnkdojqnww")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The protocol type of the file system.
     * Valid values:
     * `NFS`,
     * `SMB` (Available when the `file_system_type` is `standard`),
     * `cpfs` (Available when the `file_system_type` is `cpfs`).
     */
    @JvmName("pbncrauwariuyihp")
    public suspend fun protocolType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value The storage type of the file System.
     * * Valid values:
     * * `Performance` (Available when the `file_system_type` is `standard`)
     * * `Capacity` (Available when the `file_system_type` is `standard`)
     */
    @JvmName("dwxnrmnpqaygjsjq")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("uvclpacecvaiaifp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("hubxjgrirvjfhvxy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The id of the VPC. The `vpc_id` is required when the `file_system_type` is `cpfs`.
     */
    @JvmName("evvtgrrvxydvdqgy")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The id of the vSwitch. The `vswitch_id` is required when the `file_system_type` is `cpfs`.
     */
    @JvmName("qanpvnpyqwkvcefm")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The available zones information that supports nas.When FileSystemType=standard, this parameter is not required. **Note:** By default, a qualified availability zone is randomly selected according to the `protocol_type` and `storage_type` configuration.
     */
    @JvmName("mcoqvoousbrpjqjs")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): FileSystemArgs = FileSystemArgs(
        capacity = capacity,
        description = description,
        encryptType = encryptType,
        fileSystemType = fileSystemType,
        kmsKeyId = kmsKeyId,
        protocolType = protocolType,
        storageType = storageType,
        tags = tags,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
