@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Fileset].
 */
@PulumiTagMarker
public class FilesetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FilesetArgs = FilesetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FilesetArgsBuilder.() -> Unit) {
        val builder = FilesetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Fileset {
        val builtJavaResource = com.pulumi.alicloud.nas.Fileset(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Fileset(builtJavaResource)
    }
}

/**
 * Provides a Network Attached Storage (NAS) Fileset resource.
 * For information about Network Attached Storage (NAS) Fileset and how to use it, see [What is Fileset](https://www.alibabacloud.com/help/en/doc-detail/27530.html).
 * > **NOTE:** Available in v1.153.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.nas.getZones({
 *     fileSystemType: "cpfs",
 * });
 * const exampleNetwork = new alicloud.vpc.Network("example", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vswitchName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: exampleNetwork.id,
 *     zoneId: example.then(example => example.zones?.[1]?.zoneId),
 * });
 * const exampleFileSystem = new alicloud.nas.FileSystem("example", {
 *     protocolType: "cpfs",
 *     storageType: "advance_200",
 *     fileSystemType: "cpfs",
 *     capacity: 3600,
 *     zoneId: example.then(example => example.zones?.[1]?.zoneId),
 *     vpcId: exampleNetwork.id,
 *     vswitchId: exampleSwitch.id,
 * });
 * const exampleFileset = new alicloud.nas.Fileset("example", {
 *     fileSystemId: exampleFileSystem.id,
 *     description: "terraform-example",
 *     fileSystemPath: "/example_path/",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.nas.get_zones(file_system_type="cpfs")
 * example_network = alicloud.vpc.Network("example",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * example_switch = alicloud.vpc.Switch("example",
 *     vswitch_name="terraform-example",
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=example_network.id,
 *     zone_id=example.zones[1].zone_id)
 * example_file_system = alicloud.nas.FileSystem("example",
 *     protocol_type="cpfs",
 *     storage_type="advance_200",
 *     file_system_type="cpfs",
 *     capacity=3600,
 *     zone_id=example.zones[1].zone_id,
 *     vpc_id=example_network.id,
 *     vswitch_id=example_switch.id)
 * example_fileset = alicloud.nas.Fileset("example",
 *     file_system_id=example_file_system.id,
 *     description="terraform-example",
 *     file_system_path="/example_path/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.Nas.GetZones.Invoke(new()
 *     {
 *         FileSystemType = "cpfs",
 *     });
 *     var exampleNetwork = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VswitchName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = exampleNetwork.Id,
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[1]?.ZoneId),
 *     });
 *     var exampleFileSystem = new AliCloud.Nas.FileSystem("example", new()
 *     {
 *         ProtocolType = "cpfs",
 *         StorageType = "advance_200",
 *         FileSystemType = "cpfs",
 *         Capacity = 3600,
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[1]?.ZoneId),
 *         VpcId = exampleNetwork.Id,
 *         VswitchId = exampleSwitch.Id,
 *     });
 *     var exampleFileset = new AliCloud.Nas.Fileset("example", new()
 *     {
 *         FileSystemId = exampleFileSystem.Id,
 *         Description = "terraform-example",
 *         FileSystemPath = "/example_path/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := nas.GetZones(ctx, &nas.GetZonesArgs{
 * 			FileSystemType: pulumi.StringRef("cpfs"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleNetwork, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       exampleNetwork.ID(),
 * 			ZoneId:      pulumi.String(example.Zones[1].ZoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleFileSystem, err := nas.NewFileSystem(ctx, "example", &nas.FileSystemArgs{
 * 			ProtocolType:   pulumi.String("cpfs"),
 * 			StorageType:    pulumi.String("advance_200"),
 * 			FileSystemType: pulumi.String("cpfs"),
 * 			Capacity:       pulumi.Int(3600),
 * 			ZoneId:         pulumi.String(example.Zones[1].ZoneId),
 * 			VpcId:          exampleNetwork.ID(),
 * 			VswitchId:      exampleSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewFileset(ctx, "example", &nas.FilesetArgs{
 * 			FileSystemId:   exampleFileSystem.ID(),
 * 			Description:    pulumi.String("terraform-example"),
 * 			FileSystemPath: pulumi.String("/example_path/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.NasFunctions;
 * import com.pulumi.alicloud.nas.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import com.pulumi.alicloud.nas.Fileset;
 * import com.pulumi.alicloud.nas.FilesetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = NasFunctions.getZones(GetZonesArgs.builder()
 *             .fileSystemType("cpfs")
 *             .build());
 *         var exampleNetwork = new Network("exampleNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vswitchName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(exampleNetwork.id())
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[1].zoneId()))
 *             .build());
 *         var exampleFileSystem = new FileSystem("exampleFileSystem", FileSystemArgs.builder()
 *             .protocolType("cpfs")
 *             .storageType("advance_200")
 *             .fileSystemType("cpfs")
 *             .capacity(3600)
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[1].zoneId()))
 *             .vpcId(exampleNetwork.id())
 *             .vswitchId(exampleSwitch.id())
 *             .build());
 *         var exampleFileset = new Fileset("exampleFileset", FilesetArgs.builder()
 *             .fileSystemId(exampleFileSystem.id())
 *             .description("terraform-example")
 *             .fileSystemPath("/example_path/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleNetwork:
 *     type: alicloud:vpc:Network
 *     name: example
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vswitchName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *       vpcId: ${exampleNetwork.id}
 *       zoneId: ${example.zones[1].zoneId}
 *   exampleFileSystem:
 *     type: alicloud:nas:FileSystem
 *     name: example
 *     properties:
 *       protocolType: cpfs
 *       storageType: advance_200
 *       fileSystemType: cpfs
 *       capacity: 3600
 *       zoneId: ${example.zones[1].zoneId}
 *       vpcId: ${exampleNetwork.id}
 *       vswitchId: ${exampleSwitch.id}
 *   exampleFileset:
 *     type: alicloud:nas:Fileset
 *     name: example
 *     properties:
 *       fileSystemId: ${exampleFileSystem.id}
 *       description: terraform-example
 *       fileSystemPath: /example_path/
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:nas:getZones
 *       Arguments:
 *         fileSystemType: cpfs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Network Attached Storage (NAS) Fileset can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/fileset:Fileset example <file_system_id>:<fileset_id>
 * ```
 */
public class Fileset internal constructor(
    override val javaResource: com.pulumi.alicloud.nas.Fileset,
) : KotlinCustomResource(javaResource, FilesetMapper) {
    /**
     * The description of the Fileset. It must be `2` to `128` characters in length and must start with a letter or Chinese, but cannot start with `https://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The dry run.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the file system.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    /**
     * The path of the fileset.
     */
    public val fileSystemPath: Output<String>
        get() = javaResource.fileSystemPath().applyValue({ args0 -> args0 })

    /**
     * The first ID of the resource.
     */
    public val filesetId: Output<String>
        get() = javaResource.filesetId().applyValue({ args0 -> args0 })

    /**
     * The status of the fileset.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object FilesetMapper : ResourceMapper<Fileset> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nas.Fileset::class == javaResource::class

    override fun map(javaResource: Resource): Fileset = Fileset(
        javaResource as
            com.pulumi.alicloud.nas.Fileset,
    )
}

/**
 * @see [Fileset].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Fileset].
 */
public suspend fun fileset(name: String, block: suspend FilesetResourceBuilder.() -> Unit): Fileset {
    val builder = FilesetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Fileset].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fileset(name: String): Fileset {
    val builder = FilesetResourceBuilder()
    builder.name(name)
    return builder.build()
}
