@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [LifecyclePolicy].
 */
@PulumiTagMarker
public class LifecyclePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LifecyclePolicyArgs = LifecyclePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LifecyclePolicyArgsBuilder.() -> Unit) {
        val builder = LifecyclePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LifecyclePolicy {
        val builtJavaResource = com.pulumi.alicloud.nas.LifecyclePolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LifecyclePolicy(builtJavaResource)
    }
}

/**
 * Provides a Network Attached Storage (NAS) Lifecycle Policy resource.
 * For information about Network Attached Storage (NAS) Lifecycle Policy and how to use it, see [What is Lifecycle Policy](https://www.alibabacloud.com/help/en/doc-detail/169362.html).
 * > **NOTE:** Available in v1.153.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.nas.FileSystem("example", {
 *     protocolType: "NFS",
 *     storageType: "Capacity",
 * });
 * const exampleLifecyclePolicy = new alicloud.nas.LifecyclePolicy("example", {
 *     fileSystemId: example.id,
 *     lifecyclePolicyName: "terraform-example",
 *     lifecycleRuleName: "DEFAULT_ATIME_14",
 *     storageType: "InfrequentAccess",
 *     paths: ["/"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.nas.FileSystem("example",
 *     protocol_type="NFS",
 *     storage_type="Capacity")
 * example_lifecycle_policy = alicloud.nas.LifecyclePolicy("example",
 *     file_system_id=example.id,
 *     lifecycle_policy_name="terraform-example",
 *     lifecycle_rule_name="DEFAULT_ATIME_14",
 *     storage_type="InfrequentAccess",
 *     paths=["/"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Nas.FileSystem("example", new()
 *     {
 *         ProtocolType = "NFS",
 *         StorageType = "Capacity",
 *     });
 *     var exampleLifecyclePolicy = new AliCloud.Nas.LifecyclePolicy("example", new()
 *     {
 *         FileSystemId = example.Id,
 *         LifecyclePolicyName = "terraform-example",
 *         LifecycleRuleName = "DEFAULT_ATIME_14",
 *         StorageType = "InfrequentAccess",
 *         Paths = new[]
 *         {
 *             "/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := nas.NewFileSystem(ctx, "example", &nas.FileSystemArgs{
 * 			ProtocolType: pulumi.String("NFS"),
 * 			StorageType:  pulumi.String("Capacity"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewLifecyclePolicy(ctx, "example", &nas.LifecyclePolicyArgs{
 * 			FileSystemId:        example.ID(),
 * 			LifecyclePolicyName: pulumi.String("terraform-example"),
 * 			LifecycleRuleName:   pulumi.String("DEFAULT_ATIME_14"),
 * 			StorageType:         pulumi.String("InfrequentAccess"),
 * 			Paths: pulumi.StringArray{
 * 				pulumi.String("/"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import com.pulumi.alicloud.nas.LifecyclePolicy;
 * import com.pulumi.alicloud.nas.LifecyclePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FileSystem("example", FileSystemArgs.builder()
 *             .protocolType("NFS")
 *             .storageType("Capacity")
 *             .build());
 *         var exampleLifecyclePolicy = new LifecyclePolicy("exampleLifecyclePolicy", LifecyclePolicyArgs.builder()
 *             .fileSystemId(example.id())
 *             .lifecyclePolicyName("terraform-example")
 *             .lifecycleRuleName("DEFAULT_ATIME_14")
 *             .storageType("InfrequentAccess")
 *             .paths("/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:nas:FileSystem
 *     properties:
 *       protocolType: NFS
 *       storageType: Capacity
 *   exampleLifecyclePolicy:
 *     type: alicloud:nas:LifecyclePolicy
 *     name: example
 *     properties:
 *       fileSystemId: ${example.id}
 *       lifecyclePolicyName: terraform-example
 *       lifecycleRuleName: DEFAULT_ATIME_14
 *       storageType: InfrequentAccess
 *       paths:
 *         - /
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Network Attached Storage (NAS) Lifecycle Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/lifecyclePolicy:LifecyclePolicy example <file_system_id>:<lifecycle_policy_name>
 * ```
 */
public class LifecyclePolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.nas.LifecyclePolicy,
) : KotlinCustomResource(javaResource, LifecyclePolicyMapper) {
    /**
     * The ID of the file system.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    /**
     * The name of the lifecycle management policy.
     */
    public val lifecyclePolicyName: Output<String>
        get() = javaResource.lifecyclePolicyName().applyValue({ args0 -> args0 })

    /**
     * The rules in the lifecycle management policy. Valid values: `DEFAULT_ATIME_14`, `DEFAULT_ATIME_30`, `DEFAULT_ATIME_60`, `DEFAULT_ATIME_90`.
     */
    public val lifecycleRuleName: Output<String>
        get() = javaResource.lifecycleRuleName().applyValue({ args0 -> args0 })

    /**
     * The absolute path of the directory for which the lifecycle management policy is configured. Set a maximum of `10` path. The path value must be prefixed by a forward slash (/) and must be an existing path in the mount target.
     */
    public val paths: Output<List<String>>
        get() = javaResource.paths().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The storage type of the data that is dumped to the IA storage medium. Valid values: `InfrequentAccess`.
     */
    public val storageType: Output<String>
        get() = javaResource.storageType().applyValue({ args0 -> args0 })
}

public object LifecyclePolicyMapper : ResourceMapper<LifecyclePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nas.LifecyclePolicy::class == javaResource::class

    override fun map(javaResource: Resource): LifecyclePolicy = LifecyclePolicy(
        javaResource as
            com.pulumi.alicloud.nas.LifecyclePolicy,
    )
}

/**
 * @see [LifecyclePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LifecyclePolicy].
 */
public suspend fun lifecyclePolicy(
    name: String,
    block: suspend LifecyclePolicyResourceBuilder.() -> Unit,
): LifecyclePolicy {
    val builder = LifecyclePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LifecyclePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lifecyclePolicy(name: String): LifecyclePolicy {
    val builder = LifecyclePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
