@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.alicloud.nas.LifecyclePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Network Attached Storage (NAS) Lifecycle Policy resource.
 * For information about Network Attached Storage (NAS) Lifecycle Policy and how to use it, see [What is Lifecycle Policy](https://www.alibabacloud.com/help/en/doc-detail/169362.html).
 * > **NOTE:** Available in v1.153.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.nas.FileSystem("example", {
 *     protocolType: "NFS",
 *     storageType: "Capacity",
 * });
 * const exampleLifecyclePolicy = new alicloud.nas.LifecyclePolicy("example", {
 *     fileSystemId: example.id,
 *     lifecyclePolicyName: "terraform-example",
 *     lifecycleRuleName: "DEFAULT_ATIME_14",
 *     storageType: "InfrequentAccess",
 *     paths: ["/"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.nas.FileSystem("example",
 *     protocol_type="NFS",
 *     storage_type="Capacity")
 * example_lifecycle_policy = alicloud.nas.LifecyclePolicy("example",
 *     file_system_id=example.id,
 *     lifecycle_policy_name="terraform-example",
 *     lifecycle_rule_name="DEFAULT_ATIME_14",
 *     storage_type="InfrequentAccess",
 *     paths=["/"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Nas.FileSystem("example", new()
 *     {
 *         ProtocolType = "NFS",
 *         StorageType = "Capacity",
 *     });
 *     var exampleLifecyclePolicy = new AliCloud.Nas.LifecyclePolicy("example", new()
 *     {
 *         FileSystemId = example.Id,
 *         LifecyclePolicyName = "terraform-example",
 *         LifecycleRuleName = "DEFAULT_ATIME_14",
 *         StorageType = "InfrequentAccess",
 *         Paths = new[]
 *         {
 *             "/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := nas.NewFileSystem(ctx, "example", &nas.FileSystemArgs{
 * 			ProtocolType: pulumi.String("NFS"),
 * 			StorageType:  pulumi.String("Capacity"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewLifecyclePolicy(ctx, "example", &nas.LifecyclePolicyArgs{
 * 			FileSystemId:        example.ID(),
 * 			LifecyclePolicyName: pulumi.String("terraform-example"),
 * 			LifecycleRuleName:   pulumi.String("DEFAULT_ATIME_14"),
 * 			StorageType:         pulumi.String("InfrequentAccess"),
 * 			Paths: pulumi.StringArray{
 * 				pulumi.String("/"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import com.pulumi.alicloud.nas.LifecyclePolicy;
 * import com.pulumi.alicloud.nas.LifecyclePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FileSystem("example", FileSystemArgs.builder()
 *             .protocolType("NFS")
 *             .storageType("Capacity")
 *             .build());
 *         var exampleLifecyclePolicy = new LifecyclePolicy("exampleLifecyclePolicy", LifecyclePolicyArgs.builder()
 *             .fileSystemId(example.id())
 *             .lifecyclePolicyName("terraform-example")
 *             .lifecycleRuleName("DEFAULT_ATIME_14")
 *             .storageType("InfrequentAccess")
 *             .paths("/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:nas:FileSystem
 *     properties:
 *       protocolType: NFS
 *       storageType: Capacity
 *   exampleLifecyclePolicy:
 *     type: alicloud:nas:LifecyclePolicy
 *     name: example
 *     properties:
 *       fileSystemId: ${example.id}
 *       lifecyclePolicyName: terraform-example
 *       lifecycleRuleName: DEFAULT_ATIME_14
 *       storageType: InfrequentAccess
 *       paths:
 *         - /
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Network Attached Storage (NAS) Lifecycle Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/lifecyclePolicy:LifecyclePolicy example <file_system_id>:<lifecycle_policy_name>
 * ```
 * @property fileSystemId The ID of the file system.
 * @property lifecyclePolicyName The name of the lifecycle management policy.
 * @property lifecycleRuleName The rules in the lifecycle management policy. Valid values: `DEFAULT_ATIME_14`, `DEFAULT_ATIME_30`, `DEFAULT_ATIME_60`, `DEFAULT_ATIME_90`.
 * @property paths The absolute path of the directory for which the lifecycle management policy is configured. Set a maximum of `10` path. The path value must be prefixed by a forward slash (/) and must be an existing path in the mount target.
 * @property storageType The storage type of the data that is dumped to the IA storage medium. Valid values: `InfrequentAccess`.
 */
public data class LifecyclePolicyArgs(
    public val fileSystemId: Output<String>? = null,
    public val lifecyclePolicyName: Output<String>? = null,
    public val lifecycleRuleName: Output<String>? = null,
    public val paths: Output<List<String>>? = null,
    public val storageType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.LifecyclePolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.LifecyclePolicyArgs =
        com.pulumi.alicloud.nas.LifecyclePolicyArgs.builder()
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .lifecyclePolicyName(lifecyclePolicyName?.applyValue({ args0 -> args0 }))
            .lifecycleRuleName(lifecycleRuleName?.applyValue({ args0 -> args0 }))
            .paths(paths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .storageType(storageType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LifecyclePolicyArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyArgsBuilder internal constructor() {
    private var fileSystemId: Output<String>? = null

    private var lifecyclePolicyName: Output<String>? = null

    private var lifecycleRuleName: Output<String>? = null

    private var paths: Output<List<String>>? = null

    private var storageType: Output<String>? = null

    /**
     * @param value The ID of the file system.
     */
    @JvmName("vifqxsjlyjenqjwe")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The name of the lifecycle management policy.
     */
    @JvmName("dcbpsupvnfqevcgq")
    public suspend fun lifecyclePolicyName(`value`: Output<String>) {
        this.lifecyclePolicyName = value
    }

    /**
     * @param value The rules in the lifecycle management policy. Valid values: `DEFAULT_ATIME_14`, `DEFAULT_ATIME_30`, `DEFAULT_ATIME_60`, `DEFAULT_ATIME_90`.
     */
    @JvmName("ouvnoihtysvjtuwn")
    public suspend fun lifecycleRuleName(`value`: Output<String>) {
        this.lifecycleRuleName = value
    }

    /**
     * @param value The absolute path of the directory for which the lifecycle management policy is configured. Set a maximum of `10` path. The path value must be prefixed by a forward slash (/) and must be an existing path in the mount target.
     */
    @JvmName("ydmxomhvcnjbluma")
    public suspend fun paths(`value`: Output<List<String>>) {
        this.paths = value
    }

    @JvmName("hseyehjifsgfpmgd")
    public suspend fun paths(vararg values: Output<String>) {
        this.paths = Output.all(values.asList())
    }

    /**
     * @param values The absolute path of the directory for which the lifecycle management policy is configured. Set a maximum of `10` path. The path value must be prefixed by a forward slash (/) and must be an existing path in the mount target.
     */
    @JvmName("lceoknuhujtuvmpk")
    public suspend fun paths(values: List<Output<String>>) {
        this.paths = Output.all(values)
    }

    /**
     * @param value The storage type of the data that is dumped to the IA storage medium. Valid values: `InfrequentAccess`.
     */
    @JvmName("vxqfvkhbjmbigkvp")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value The ID of the file system.
     */
    @JvmName("vlspqanuttvsadxx")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value The name of the lifecycle management policy.
     */
    @JvmName("uwotbbygnhsjhqhk")
    public suspend fun lifecyclePolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecyclePolicyName = mapped
    }

    /**
     * @param value The rules in the lifecycle management policy. Valid values: `DEFAULT_ATIME_14`, `DEFAULT_ATIME_30`, `DEFAULT_ATIME_60`, `DEFAULT_ATIME_90`.
     */
    @JvmName("yulqwitiisliftxs")
    public suspend fun lifecycleRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleRuleName = mapped
    }

    /**
     * @param value The absolute path of the directory for which the lifecycle management policy is configured. Set a maximum of `10` path. The path value must be prefixed by a forward slash (/) and must be an existing path in the mount target.
     */
    @JvmName("eysneiqacckclnik")
    public suspend fun paths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paths = mapped
    }

    /**
     * @param values The absolute path of the directory for which the lifecycle management policy is configured. Set a maximum of `10` path. The path value must be prefixed by a forward slash (/) and must be an existing path in the mount target.
     */
    @JvmName("xrhhdmlhbpykfnkp")
    public suspend fun paths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paths = mapped
    }

    /**
     * @param value The storage type of the data that is dumped to the IA storage medium. Valid values: `InfrequentAccess`.
     */
    @JvmName("hrqcuaqrxinlwhrl")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    internal fun build(): LifecyclePolicyArgs = LifecyclePolicyArgs(
        fileSystemId = fileSystemId,
        lifecyclePolicyName = lifecyclePolicyName,
        lifecycleRuleName = lifecycleRuleName,
        paths = paths,
        storageType = storageType,
    )
}
