@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MountTarget].
 */
@PulumiTagMarker
public class MountTargetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MountTargetArgs = MountTargetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MountTargetArgsBuilder.() -> Unit) {
        val builder = MountTargetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MountTarget {
        val builtJavaResource = com.pulumi.alicloud.nas.MountTarget(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MountTarget(builtJavaResource)
    }
}

/**
 * Provides a NAS Mount Target resource.
 * For information about NAS Mount Target and how to use it, see [Manage NAS Mount Targets](https://www.alibabacloud.com/help/en/doc-detail/27531.htm).
 * > **NOTE:** Available since v1.34.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.nas.getZones({
 *     fileSystemType: "extreme",
 * });
 * const countSize = _default.then(_default => _default.zones).length;
 * const zoneId = Promise.all([_default, countSize])&#46;then(([_default, countSize]) => _default&#46;zones[countSize - 1].zoneId);
 * const example = new alicloud.vpc.Network("example", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vswitchName: example.vpcName,
 *     cidrBlock: example.cidrBlock,
 *     vpcId: example.id,
 *     zoneId: zoneId,
 * });
 * const exampleFileSystem = new alicloud.nas.FileSystem("example", {
 *     protocolType: "NFS",
 *     storageType: "advance",
 *     fileSystemType: "extreme",
 *     capacity: 100,
 *     zoneId: zoneId,
 * });
 * const exampleAccessGroup = new alicloud.nas.AccessGroup("example", {
 *     accessGroupName: "access_group_xxx",
 *     accessGroupType: "Vpc",
 *     description: "test_access_group",
 *     fileSystemType: "extreme",
 * });
 * const exampleMountTarget = new alicloud.nas.MountTarget("example", {
 *     fileSystemId: exampleFileSystem.id,
 *     accessGroupName: exampleAccessGroup.accessGroupName,
 *     vswitchId: exampleSwitch.id,
 *     vpcId: example.id,
 *     networkType: exampleAccessGroup.accessGroupType,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.nas.get_zones(file_system_type="extreme")
 * count_size = len(default.zones)
 * zone_id = default.zones[count_size - 1].zone_id
 * example = alicloud.vpc.Network("example",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * example_switch = alicloud.vpc.Switch("example",
 *     vswitch_name=example.vpc_name,
 *     cidr_block=example.cidr_block,
 *     vpc_id=example.id,
 *     zone_id=zone_id)
 * example_file_system = alicloud.nas.FileSystem("example",
 *     protocol_type="NFS",
 *     storage_type="advance",
 *     file_system_type="extreme",
 *     capacity=100,
 *     zone_id=zone_id)
 * example_access_group = alicloud.nas.AccessGroup("example",
 *     access_group_name="access_group_xxx",
 *     access_group_type="Vpc",
 *     description="test_access_group",
 *     file_system_type="extreme")
 * example_mount_target = alicloud.nas.MountTarget("example",
 *     file_system_id=example_file_system.id,
 *     access_group_name=example_access_group.access_group_name,
 *     vswitch_id=example_switch.id,
 *     vpc_id=example.id,
 *     network_type=example_access_group.access_group_type)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.Nas.GetZones.Invoke(new()
 *     {
 *         FileSystemType = "extreme",
 *     });
 *     var countSize = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)).Length;
 *     var zoneId = Output.Tuple(@default, countSize).Apply(values =>
 *     {
 *         var @default = values.Item1;
 *         var countSize = values.Item2;
 *         return @default.Apply(getZonesResult => getZonesResult.Zones)[countSize - 1].ZoneId;
 *     });
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VswitchName = example.VpcName,
 *         CidrBlock = example.CidrBlock,
 *         VpcId = example.Id,
 *         ZoneId = zoneId,
 *     });
 *     var exampleFileSystem = new AliCloud.Nas.FileSystem("example", new()
 *     {
 *         ProtocolType = "NFS",
 *         StorageType = "advance",
 *         FileSystemType = "extreme",
 *         Capacity = 100,
 *         ZoneId = zoneId,
 *     });
 *     var exampleAccessGroup = new AliCloud.Nas.AccessGroup("example", new()
 *     {
 *         AccessGroupName = "access_group_xxx",
 *         AccessGroupType = "Vpc",
 *         Description = "test_access_group",
 *         FileSystemType = "extreme",
 *     });
 *     var exampleMountTarget = new AliCloud.Nas.MountTarget("example", new()
 *     {
 *         FileSystemId = exampleFileSystem.Id,
 *         AccessGroupName = exampleAccessGroup.AccessGroupName,
 *         VswitchId = exampleSwitch.Id,
 *         VpcId = example.Id,
 *         NetworkType = exampleAccessGroup.AccessGroupType,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := nas.GetZones(ctx, &nas.GetZonesArgs{
 * 			FileSystemType: pulumi.StringRef("extreme"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		countSize := len(_default.Zones)
 * 		zoneId := _default.Zones[countSize-1].ZoneId
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VswitchName: example.VpcName,
 * 			CidrBlock:   example.CidrBlock,
 * 			VpcId:       example.ID(),
 * 			ZoneId:      pulumi.String(zoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleFileSystem, err := nas.NewFileSystem(ctx, "example", &nas.FileSystemArgs{
 * 			ProtocolType:   pulumi.String("NFS"),
 * 			StorageType:    pulumi.String("advance"),
 * 			FileSystemType: pulumi.String("extreme"),
 * 			Capacity:       pulumi.Int(100),
 * 			ZoneId:         pulumi.String(zoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleAccessGroup, err := nas.NewAccessGroup(ctx, "example", &nas.AccessGroupArgs{
 * 			AccessGroupName: pulumi.String("access_group_xxx"),
 * 			AccessGroupType: pulumi.String("Vpc"),
 * 			Description:     pulumi.String("test_access_group"),
 * 			FileSystemType:  pulumi.String("extreme"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewMountTarget(ctx, "example", &nas.MountTargetArgs{
 * 			FileSystemId:    exampleFileSystem.ID(),
 * 			AccessGroupName: exampleAccessGroup.AccessGroupName,
 * 			VswitchId:       exampleSwitch.ID(),
 * 			VpcId:           example.ID(),
 * 			NetworkType:     exampleAccessGroup.AccessGroupType,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.NasFunctions;
 * import com.pulumi.alicloud.nas.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import com.pulumi.alicloud.nas.AccessGroup;
 * import com.pulumi.alicloud.nas.AccessGroupArgs;
 * import com.pulumi.alicloud.nas.MountTarget;
 * import com.pulumi.alicloud.nas.MountTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = NasFunctions.getZones(GetZonesArgs.builder()
 *             .fileSystemType("extreme")
 *             .build());
 *         final var countSize = default_.zones().length();
 *         final var zoneId = default_.zones()[countSize - 1].zoneId();
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vswitchName(example.vpcName())
 *             .cidrBlock(example.cidrBlock())
 *             .vpcId(example.id())
 *             .zoneId(zoneId)
 *             .build());
 *         var exampleFileSystem = new FileSystem("exampleFileSystem", FileSystemArgs.builder()
 *             .protocolType("NFS")
 *             .storageType("advance")
 *             .fileSystemType("extreme")
 *             .capacity("100")
 *             .zoneId(zoneId)
 *             .build());
 *         var exampleAccessGroup = new AccessGroup("exampleAccessGroup", AccessGroupArgs.builder()
 *             .accessGroupName("access_group_xxx")
 *             .accessGroupType("Vpc")
 *             .description("test_access_group")
 *             .fileSystemType("extreme")
 *             .build());
 *         var exampleMountTarget = new MountTarget("exampleMountTarget", MountTargetArgs.builder()
 *             .fileSystemId(exampleFileSystem.id())
 *             .accessGroupName(exampleAccessGroup.accessGroupName())
 *             .vswitchId(exampleSwitch.id())
 *             .vpcId(example.id())
 *             .networkType(exampleAccessGroup.accessGroupType())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NAS MountTarget can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/mountTarget:MountTarget foo 192094b415:192094b415-luw38.cn-beijing.nas.aliyuncs.com
 * ```
 */
public class MountTarget internal constructor(
    override val javaResource: com.pulumi.alicloud.nas.MountTarget,
) : KotlinCustomResource(javaResource, MountTargetMapper) {
    /**
     * The name of the permission group that applies to the mount target.
     */
    public val accessGroupName: Output<String>?
        get() = javaResource.accessGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the file system.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    /**
     * The IPv4 domain name of the mount target. **NOTE:** Available since v1.161.0.
     */
    public val mountTargetDomain: Output<String>
        get() = javaResource.mountTargetDomain().applyValue({ args0 -> args0 })

    /**
     * mount target network type. Valid values: `VPC`. The classic network's mount targets are not supported.
     */
    public val networkType: Output<String>
        get() = javaResource.networkType().applyValue({ args0 -> args0 })

    /**
     * The ID of security group.
     */
    public val securityGroupId: Output<String>?
        get() = javaResource.securityGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the MountTarget is active. The status of the mount target. Valid values: `Active` and `Inactive`, Default value is `Active`. Before you mount a file system, make sure that the mount target is in the Active state.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The ID of the VSwitch in the VPC where the mount target resides.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object MountTargetMapper : ResourceMapper<MountTarget> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nas.MountTarget::class == javaResource::class

    override fun map(javaResource: Resource): MountTarget = MountTarget(
        javaResource as
            com.pulumi.alicloud.nas.MountTarget,
    )
}

/**
 * @see [MountTarget].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MountTarget].
 */
public suspend fun mountTarget(name: String, block: suspend MountTargetResourceBuilder.() -> Unit): MountTarget {
    val builder = MountTargetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MountTarget].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mountTarget(name: String): MountTarget {
    val builder = MountTargetResourceBuilder()
    builder.name(name)
    return builder.build()
}
