@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.alicloud.nas.MountTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a NAS Mount Target resource.
 * For information about NAS Mount Target and how to use it, see [Manage NAS Mount Targets](https://www.alibabacloud.com/help/en/doc-detail/27531.htm).
 * > **NOTE:** Available since v1.34.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.nas.getZones({
 *     fileSystemType: "extreme",
 * });
 * const countSize = _default.then(_default => _default.zones).length;
 * const zoneId = Promise.all([_default, countSize])&#46;then(([_default, countSize]) => _default&#46;zones[countSize - 1].zoneId);
 * const example = new alicloud.vpc.Network("example", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vswitchName: example.vpcName,
 *     cidrBlock: example.cidrBlock,
 *     vpcId: example.id,
 *     zoneId: zoneId,
 * });
 * const exampleFileSystem = new alicloud.nas.FileSystem("example", {
 *     protocolType: "NFS",
 *     storageType: "advance",
 *     fileSystemType: "extreme",
 *     capacity: 100,
 *     zoneId: zoneId,
 * });
 * const exampleAccessGroup = new alicloud.nas.AccessGroup("example", {
 *     accessGroupName: "access_group_xxx",
 *     accessGroupType: "Vpc",
 *     description: "test_access_group",
 *     fileSystemType: "extreme",
 * });
 * const exampleMountTarget = new alicloud.nas.MountTarget("example", {
 *     fileSystemId: exampleFileSystem.id,
 *     accessGroupName: exampleAccessGroup.accessGroupName,
 *     vswitchId: exampleSwitch.id,
 *     vpcId: example.id,
 *     networkType: exampleAccessGroup.accessGroupType,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.nas.get_zones(file_system_type="extreme")
 * count_size = len(default.zones)
 * zone_id = default.zones[count_size - 1].zone_id
 * example = alicloud.vpc.Network("example",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * example_switch = alicloud.vpc.Switch("example",
 *     vswitch_name=example.vpc_name,
 *     cidr_block=example.cidr_block,
 *     vpc_id=example.id,
 *     zone_id=zone_id)
 * example_file_system = alicloud.nas.FileSystem("example",
 *     protocol_type="NFS",
 *     storage_type="advance",
 *     file_system_type="extreme",
 *     capacity=100,
 *     zone_id=zone_id)
 * example_access_group = alicloud.nas.AccessGroup("example",
 *     access_group_name="access_group_xxx",
 *     access_group_type="Vpc",
 *     description="test_access_group",
 *     file_system_type="extreme")
 * example_mount_target = alicloud.nas.MountTarget("example",
 *     file_system_id=example_file_system.id,
 *     access_group_name=example_access_group.access_group_name,
 *     vswitch_id=example_switch.id,
 *     vpc_id=example.id,
 *     network_type=example_access_group.access_group_type)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.Nas.GetZones.Invoke(new()
 *     {
 *         FileSystemType = "extreme",
 *     });
 *     var countSize = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)).Length;
 *     var zoneId = Output.Tuple(@default, countSize).Apply(values =>
 *     {
 *         var @default = values.Item1;
 *         var countSize = values.Item2;
 *         return @default.Apply(getZonesResult => getZonesResult.Zones)[countSize - 1].ZoneId;
 *     });
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VswitchName = example.VpcName,
 *         CidrBlock = example.CidrBlock,
 *         VpcId = example.Id,
 *         ZoneId = zoneId,
 *     });
 *     var exampleFileSystem = new AliCloud.Nas.FileSystem("example", new()
 *     {
 *         ProtocolType = "NFS",
 *         StorageType = "advance",
 *         FileSystemType = "extreme",
 *         Capacity = 100,
 *         ZoneId = zoneId,
 *     });
 *     var exampleAccessGroup = new AliCloud.Nas.AccessGroup("example", new()
 *     {
 *         AccessGroupName = "access_group_xxx",
 *         AccessGroupType = "Vpc",
 *         Description = "test_access_group",
 *         FileSystemType = "extreme",
 *     });
 *     var exampleMountTarget = new AliCloud.Nas.MountTarget("example", new()
 *     {
 *         FileSystemId = exampleFileSystem.Id,
 *         AccessGroupName = exampleAccessGroup.AccessGroupName,
 *         VswitchId = exampleSwitch.Id,
 *         VpcId = example.Id,
 *         NetworkType = exampleAccessGroup.AccessGroupType,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := nas.GetZones(ctx, &nas.GetZonesArgs{
 * 			FileSystemType: pulumi.StringRef("extreme"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		countSize := len(_default.Zones)
 * 		zoneId := _default.Zones[countSize-1].ZoneId
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VswitchName: example.VpcName,
 * 			CidrBlock:   example.CidrBlock,
 * 			VpcId:       example.ID(),
 * 			ZoneId:      pulumi.String(zoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleFileSystem, err := nas.NewFileSystem(ctx, "example", &nas.FileSystemArgs{
 * 			ProtocolType:   pulumi.String("NFS"),
 * 			StorageType:    pulumi.String("advance"),
 * 			FileSystemType: pulumi.String("extreme"),
 * 			Capacity:       pulumi.Int(100),
 * 			ZoneId:         pulumi.String(zoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleAccessGroup, err := nas.NewAccessGroup(ctx, "example", &nas.AccessGroupArgs{
 * 			AccessGroupName: pulumi.String("access_group_xxx"),
 * 			AccessGroupType: pulumi.String("Vpc"),
 * 			Description:     pulumi.String("test_access_group"),
 * 			FileSystemType:  pulumi.String("extreme"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewMountTarget(ctx, "example", &nas.MountTargetArgs{
 * 			FileSystemId:    exampleFileSystem.ID(),
 * 			AccessGroupName: exampleAccessGroup.AccessGroupName,
 * 			VswitchId:       exampleSwitch.ID(),
 * 			VpcId:           example.ID(),
 * 			NetworkType:     exampleAccessGroup.AccessGroupType,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.NasFunctions;
 * import com.pulumi.alicloud.nas.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import com.pulumi.alicloud.nas.AccessGroup;
 * import com.pulumi.alicloud.nas.AccessGroupArgs;
 * import com.pulumi.alicloud.nas.MountTarget;
 * import com.pulumi.alicloud.nas.MountTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = NasFunctions.getZones(GetZonesArgs.builder()
 *             .fileSystemType("extreme")
 *             .build());
 *         final var countSize = default_.zones().length();
 *         final var zoneId = default_.zones()[countSize - 1].zoneId();
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vswitchName(example.vpcName())
 *             .cidrBlock(example.cidrBlock())
 *             .vpcId(example.id())
 *             .zoneId(zoneId)
 *             .build());
 *         var exampleFileSystem = new FileSystem("exampleFileSystem", FileSystemArgs.builder()
 *             .protocolType("NFS")
 *             .storageType("advance")
 *             .fileSystemType("extreme")
 *             .capacity("100")
 *             .zoneId(zoneId)
 *             .build());
 *         var exampleAccessGroup = new AccessGroup("exampleAccessGroup", AccessGroupArgs.builder()
 *             .accessGroupName("access_group_xxx")
 *             .accessGroupType("Vpc")
 *             .description("test_access_group")
 *             .fileSystemType("extreme")
 *             .build());
 *         var exampleMountTarget = new MountTarget("exampleMountTarget", MountTargetArgs.builder()
 *             .fileSystemId(exampleFileSystem.id())
 *             .accessGroupName(exampleAccessGroup.accessGroupName())
 *             .vswitchId(exampleSwitch.id())
 *             .vpcId(example.id())
 *             .networkType(exampleAccessGroup.accessGroupType())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NAS MountTarget can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/mountTarget:MountTarget foo 192094b415:192094b415-luw38.cn-beijing.nas.aliyuncs.com
 * ```
 * @property accessGroupName The name of the permission group that applies to the mount target.
 * @property fileSystemId The ID of the file system.
 * @property networkType mount target network type. Valid values: `VPC`. The classic network's mount targets are not supported.
 * @property securityGroupId The ID of security group.
 * @property status Whether the MountTarget is active. The status of the mount target. Valid values: `Active` and `Inactive`, Default value is `Active`. Before you mount a file system, make sure that the mount target is in the Active state.
 * @property vpcId The ID of VPC.
 * @property vswitchId The ID of the VSwitch in the VPC where the mount target resides.
 */
public data class MountTargetArgs(
    public val accessGroupName: Output<String>? = null,
    public val fileSystemId: Output<String>? = null,
    public val networkType: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val status: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.MountTargetArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.MountTargetArgs =
        com.pulumi.alicloud.nas.MountTargetArgs.builder()
            .accessGroupName(accessGroupName?.applyValue({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .networkType(networkType?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MountTargetArgs].
 */
@PulumiTagMarker
public class MountTargetArgsBuilder internal constructor() {
    private var accessGroupName: Output<String>? = null

    private var fileSystemId: Output<String>? = null

    private var networkType: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var status: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The name of the permission group that applies to the mount target.
     */
    @JvmName("wvhwxnmijlxtmobs")
    public suspend fun accessGroupName(`value`: Output<String>) {
        this.accessGroupName = value
    }

    /**
     * @param value The ID of the file system.
     */
    @JvmName("dlwnlqkdawmrpurb")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value mount target network type. Valid values: `VPC`. The classic network's mount targets are not supported.
     */
    @JvmName("nqfmktxpuwlojwvm")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value The ID of security group.
     */
    @JvmName("bucqdvwgdqhmvjmw")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value Whether the MountTarget is active. The status of the mount target. Valid values: `Active` and `Inactive`, Default value is `Active`. Before you mount a file system, make sure that the mount target is in the Active state.
     */
    @JvmName("bmejfjolgyvkxxbw")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The ID of VPC.
     */
    @JvmName("tdnwvylpghxrvgej")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the VSwitch in the VPC where the mount target resides.
     */
    @JvmName("foksdhjqapkbbiiu")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The name of the permission group that applies to the mount target.
     */
    @JvmName("ewwxggjyytufdxhr")
    public suspend fun accessGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessGroupName = mapped
    }

    /**
     * @param value The ID of the file system.
     */
    @JvmName("ucxyogsyoomyuhyp")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value mount target network type. Valid values: `VPC`. The classic network's mount targets are not supported.
     */
    @JvmName("luxcurxabwwlnpgq")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value The ID of security group.
     */
    @JvmName("xjlpapkrfhickhqx")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value Whether the MountTarget is active. The status of the mount target. Valid values: `Active` and `Inactive`, Default value is `Active`. Before you mount a file system, make sure that the mount target is in the Active state.
     */
    @JvmName("weagbnevtbhoqlnn")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The ID of VPC.
     */
    @JvmName("frjukiccivlluwhi")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the VSwitch in the VPC where the mount target resides.
     */
    @JvmName("ywdtscbktesrpirq")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): MountTargetArgs = MountTargetArgs(
        accessGroupName = accessGroupName,
        fileSystemId = fileSystemId,
        networkType = networkType,
        securityGroupId = securityGroupId,
        status = status,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
