@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.alicloud.nas.NasFunctions.getAccessGroupsPlain
import com.pulumi.alicloud.nas.NasFunctions.getAccessRulesPlain
import com.pulumi.alicloud.nas.NasFunctions.getAutoSnapshotPoliciesPlain
import com.pulumi.alicloud.nas.NasFunctions.getDataFlowsPlain
import com.pulumi.alicloud.nas.NasFunctions.getFileSystemsPlain
import com.pulumi.alicloud.nas.NasFunctions.getFilesetsPlain
import com.pulumi.alicloud.nas.NasFunctions.getLifecyclePoliciesPlain
import com.pulumi.alicloud.nas.NasFunctions.getMountTargetsPlain
import com.pulumi.alicloud.nas.NasFunctions.getProtocolsPlain
import com.pulumi.alicloud.nas.NasFunctions.getServicePlain
import com.pulumi.alicloud.nas.NasFunctions.getSnapshotsPlain
import com.pulumi.alicloud.nas.NasFunctions.getZonesPlain
import com.pulumi.alicloud.nas.kotlin.inputs.GetAccessGroupsPlainArgs
import com.pulumi.alicloud.nas.kotlin.inputs.GetAccessGroupsPlainArgsBuilder
import com.pulumi.alicloud.nas.kotlin.inputs.GetAccessRulesPlainArgs
import com.pulumi.alicloud.nas.kotlin.inputs.GetAccessRulesPlainArgsBuilder
import com.pulumi.alicloud.nas.kotlin.inputs.GetAutoSnapshotPoliciesPlainArgs
import com.pulumi.alicloud.nas.kotlin.inputs.GetAutoSnapshotPoliciesPlainArgsBuilder
import com.pulumi.alicloud.nas.kotlin.inputs.GetDataFlowsPlainArgs
import com.pulumi.alicloud.nas.kotlin.inputs.GetDataFlowsPlainArgsBuilder
import com.pulumi.alicloud.nas.kotlin.inputs.GetFileSystemsPlainArgs
import com.pulumi.alicloud.nas.kotlin.inputs.GetFileSystemsPlainArgsBuilder
import com.pulumi.alicloud.nas.kotlin.inputs.GetFilesetsPlainArgs
import com.pulumi.alicloud.nas.kotlin.inputs.GetFilesetsPlainArgsBuilder
import com.pulumi.alicloud.nas.kotlin.inputs.GetLifecyclePoliciesPlainArgs
import com.pulumi.alicloud.nas.kotlin.inputs.GetLifecyclePoliciesPlainArgsBuilder
import com.pulumi.alicloud.nas.kotlin.inputs.GetMountTargetsPlainArgs
import com.pulumi.alicloud.nas.kotlin.inputs.GetMountTargetsPlainArgsBuilder
import com.pulumi.alicloud.nas.kotlin.inputs.GetProtocolsPlainArgs
import com.pulumi.alicloud.nas.kotlin.inputs.GetProtocolsPlainArgsBuilder
import com.pulumi.alicloud.nas.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.nas.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.nas.kotlin.inputs.GetSnapshotsPlainArgs
import com.pulumi.alicloud.nas.kotlin.inputs.GetSnapshotsPlainArgsBuilder
import com.pulumi.alicloud.nas.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.nas.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.nas.kotlin.outputs.GetAccessGroupsResult
import com.pulumi.alicloud.nas.kotlin.outputs.GetAccessRulesResult
import com.pulumi.alicloud.nas.kotlin.outputs.GetAutoSnapshotPoliciesResult
import com.pulumi.alicloud.nas.kotlin.outputs.GetDataFlowsResult
import com.pulumi.alicloud.nas.kotlin.outputs.GetFileSystemsResult
import com.pulumi.alicloud.nas.kotlin.outputs.GetFilesetsResult
import com.pulumi.alicloud.nas.kotlin.outputs.GetLifecyclePoliciesResult
import com.pulumi.alicloud.nas.kotlin.outputs.GetMountTargetsResult
import com.pulumi.alicloud.nas.kotlin.outputs.GetProtocolsResult
import com.pulumi.alicloud.nas.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.nas.kotlin.outputs.GetSnapshotsResult
import com.pulumi.alicloud.nas.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.nas.kotlin.outputs.GetAccessGroupsResult.Companion.toKotlin as getAccessGroupsResultToKotlin
import com.pulumi.alicloud.nas.kotlin.outputs.GetAccessRulesResult.Companion.toKotlin as getAccessRulesResultToKotlin
import com.pulumi.alicloud.nas.kotlin.outputs.GetAutoSnapshotPoliciesResult.Companion.toKotlin as getAutoSnapshotPoliciesResultToKotlin
import com.pulumi.alicloud.nas.kotlin.outputs.GetDataFlowsResult.Companion.toKotlin as getDataFlowsResultToKotlin
import com.pulumi.alicloud.nas.kotlin.outputs.GetFileSystemsResult.Companion.toKotlin as getFileSystemsResultToKotlin
import com.pulumi.alicloud.nas.kotlin.outputs.GetFilesetsResult.Companion.toKotlin as getFilesetsResultToKotlin
import com.pulumi.alicloud.nas.kotlin.outputs.GetLifecyclePoliciesResult.Companion.toKotlin as getLifecyclePoliciesResultToKotlin
import com.pulumi.alicloud.nas.kotlin.outputs.GetMountTargetsResult.Companion.toKotlin as getMountTargetsResultToKotlin
import com.pulumi.alicloud.nas.kotlin.outputs.GetProtocolsResult.Companion.toKotlin as getProtocolsResultToKotlin
import com.pulumi.alicloud.nas.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.nas.kotlin.outputs.GetSnapshotsResult.Companion.toKotlin as getSnapshotsResultToKotlin
import com.pulumi.alicloud.nas.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object NasFunctions {
    /**
     * This data source provides user-available access groups. Use when you can create mount points
     * > NOTE: Available in 1.35.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.nas.getAccessGroups({
     *     nameRegex: "^foo",
     *     accessGroupType: "Classic",
     *     description: "tf-testAccAccessGroupsdatasource",
     * });
     * export const alicloudNasAccessGroupsId = example.then(example => example.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.nas.get_access_groups(name_regex="^foo",
     *     access_group_type="Classic",
     *     description="tf-testAccAccessGroupsdatasource")
     * pulumi.export("alicloudNasAccessGroupsId", example.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Nas.GetAccessGroups.Invoke(new()
     *     {
     *         NameRegex = "^foo",
     *         AccessGroupType = "Classic",
     *         Description = "tf-testAccAccessGroupsdatasource",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudNasAccessGroupsId"] = example&#46;Apply(getAccessGroupsResult => getAccessGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := nas.GetAccessGroups(ctx, &nas.GetAccessGroupsArgs{
     * 			NameRegex:       pulumi.StringRef("^foo"),
     * 			AccessGroupType: pulumi.StringRef("Classic"),
     * 			Description:     pulumi.StringRef("tf-testAccAccessGroupsdatasource"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudNasAccessGroupsId", example.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nas.NasFunctions;
     * import com.pulumi.alicloud.nas.inputs.GetAccessGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NasFunctions.getAccessGroups(GetAccessGroupsArgs.builder()
     *             .nameRegex("^foo")
     *             .accessGroupType("Classic")
     *             .description("tf-testAccAccessGroupsdatasource")
     *             .build());
     *         ctx.export("alicloudNasAccessGroupsId", example.applyValue(getAccessGroupsResult -> getAccessGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:nas:getAccessGroups
     *       Arguments:
     *         nameRegex: ^foo
     *         accessGroupType: Classic
     *         description: tf-testAccAccessGroupsdatasource
     * outputs:
     *   alicloudNasAccessGroupsId: ${example.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccessGroups.
     * @return A collection of values returned by getAccessGroups.
     */
    public suspend fun getAccessGroups(argument: GetAccessGroupsPlainArgs): GetAccessGroupsResult =
        getAccessGroupsResultToKotlin(getAccessGroupsPlain(argument.toJava()).await())

    /**
     * @see [getAccessGroups].
     * @param accessGroupName The name of access group.
     * @param accessGroupType Filter results by a specific AccessGroupType.
     * @param description Filter results by a specific Description.
     * @param fileSystemType The type of file system. Valid values: `standard` and `extreme`. Default to `standard`.
     * @param nameRegex A regex string to filter AccessGroups by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param type Field `type` has been deprecated from version 1.95.0. Use `access_group_type` instead.
     * @param useutcDateTime Specifies whether the time to return is in UTC. Valid values: true and false.
     * @return A collection of values returned by getAccessGroups.
     */
    public suspend fun getAccessGroups(
        accessGroupName: String? = null,
        accessGroupType: String? = null,
        description: String? = null,
        fileSystemType: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        type: String? = null,
        useutcDateTime: Boolean? = null,
    ): GetAccessGroupsResult {
        val argument = GetAccessGroupsPlainArgs(
            accessGroupName = accessGroupName,
            accessGroupType = accessGroupType,
            description = description,
            fileSystemType = fileSystemType,
            nameRegex = nameRegex,
            outputFile = outputFile,
            type = type,
            useutcDateTime = useutcDateTime,
        )
        return getAccessGroupsResultToKotlin(getAccessGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nas&#46;kotlin&#46;inputs&#46;GetAccessGroupsPlainArgs].
     * @return A collection of values returned by getAccessGroups.
     */
    public suspend fun getAccessGroups(argument: suspend GetAccessGroupsPlainArgsBuilder.() -> Unit): GetAccessGroupsResult {
        val builder = GetAccessGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessGroupsResultToKotlin(getAccessGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides AccessRule available to the user.
     * > **NOTE**: Available in 1.35.0+
     * @param argument A collection of arguments for invoking getAccessRules.
     * @return A collection of values returned by getAccessRules.
     */
    public suspend fun getAccessRules(argument: GetAccessRulesPlainArgs): GetAccessRulesResult =
        getAccessRulesResultToKotlin(getAccessRulesPlain(argument.toJava()).await())

    /**
     * @see [getAccessRules].
     * @param accessGroupName Filter results by a specific AccessGroupName.
     * @param ids A list of rule IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param rwAccess Filter results by a specific RWAccess.
     * @param sourceCidrIp Filter results by a specific SourceCidrIp.
     * @param userAccess Filter results by a specific UserAccess.
     * @return A collection of values returned by getAccessRules.
     */
    public suspend fun getAccessRules(
        accessGroupName: String,
        ids: List<String>? = null,
        outputFile: String? = null,
        rwAccess: String? = null,
        sourceCidrIp: String? = null,
        userAccess: String? = null,
    ): GetAccessRulesResult {
        val argument = GetAccessRulesPlainArgs(
            accessGroupName = accessGroupName,
            ids = ids,
            outputFile = outputFile,
            rwAccess = rwAccess,
            sourceCidrIp = sourceCidrIp,
            userAccess = userAccess,
        )
        return getAccessRulesResultToKotlin(getAccessRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nas&#46;kotlin&#46;inputs&#46;GetAccessRulesPlainArgs].
     * @return A collection of values returned by getAccessRules.
     */
    public suspend fun getAccessRules(argument: suspend GetAccessRulesPlainArgsBuilder.() -> Unit): GetAccessRulesResult {
        val builder = GetAccessRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessRulesResultToKotlin(getAccessRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Auto Snapshot Policies available to the user.
     * > **NOTE**: Available in v1.153.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.nas.getAutoSnapshotPolicies({
     *     ids: ["example_value"],
     * });
     * export const nasAutoSnapshotPoliciesId1 = ids.then(ids => ids.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.nas.get_auto_snapshot_policies(ids=["example_value"])
     * pulumi.export("nasAutoSnapshotPoliciesId1", ids.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Nas.GetAutoSnapshotPolicies.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["nasAutoSnapshotPoliciesId1"] = ids&#46;Apply(getAutoSnapshotPoliciesResult => getAutoSnapshotPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := nas.GetAutoSnapshotPolicies(ctx, &nas.GetAutoSnapshotPoliciesArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nasAutoSnapshotPoliciesId1", ids.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nas.NasFunctions;
     * import com.pulumi.alicloud.nas.inputs.GetAutoSnapshotPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = NasFunctions.getAutoSnapshotPolicies(GetAutoSnapshotPoliciesArgs.builder()
     *             .ids("example_value")
     *             .build());
     *         ctx.export("nasAutoSnapshotPoliciesId1", ids.applyValue(getAutoSnapshotPoliciesResult -> getAutoSnapshotPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:nas:getAutoSnapshotPolicies
     *       Arguments:
     *         ids:
     *           - example_value
     * outputs:
     *   nasAutoSnapshotPoliciesId1: ${ids.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAutoSnapshotPolicies.
     * @return A collection of values returned by getAutoSnapshotPolicies.
     */
    public suspend fun getAutoSnapshotPolicies(argument: GetAutoSnapshotPoliciesPlainArgs): GetAutoSnapshotPoliciesResult =
        getAutoSnapshotPoliciesResultToKotlin(getAutoSnapshotPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getAutoSnapshotPolicies].
     * @param ids A list of Auto Snapshot Policies IDs.
     * @param nameRegex A regex string to filter results by Auto Snapshot Policy name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the automatic snapshot policy. Valid values: `Creating`, `Available`.
     * @return A collection of values returned by getAutoSnapshotPolicies.
     */
    public suspend fun getAutoSnapshotPolicies(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAutoSnapshotPoliciesResult {
        val argument = GetAutoSnapshotPoliciesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getAutoSnapshotPoliciesResultToKotlin(getAutoSnapshotPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAutoSnapshotPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nas&#46;kotlin&#46;inputs&#46;GetAutoSnapshotPoliciesPlainArgs].
     * @return A collection of values returned by getAutoSnapshotPolicies.
     */
    public suspend fun getAutoSnapshotPolicies(argument: suspend GetAutoSnapshotPoliciesPlainArgsBuilder.() -> Unit): GetAutoSnapshotPoliciesResult {
        val builder = GetAutoSnapshotPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAutoSnapshotPoliciesResultToKotlin(getAutoSnapshotPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Nas Data Flows of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.153.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.nas.getDataFlows({
     *     fileSystemId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const nasDataFlowId1 = ids.then(ids => ids.flows?.[0]?.id);
     * const status = alicloud.nas.getDataFlows({
     *     fileSystemId: "example_value",
     *     status: "Running",
     * });
     * export const nasDataFlowId2 = status.then(status => status.flows?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.nas.get_data_flows(file_system_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("nasDataFlowId1", ids.flows[0].id)
     * status = alicloud.nas.get_data_flows(file_system_id="example_value",
     *     status="Running")
     * pulumi.export("nasDataFlowId2", status.flows[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Nas.GetDataFlows.Invoke(new()
     *     {
     *         FileSystemId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var status = AliCloud.Nas.GetDataFlows.Invoke(new()
     *     {
     *         FileSystemId = "example_value",
     *         Status = "Running",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["nasDataFlowId1"] = ids&#46;Apply(getDataFlowsResult => getDataFlowsResult&#46;Flows[0]?.Id),
     *         ["nasDataFlowId2"] = status&#46;Apply(getDataFlowsResult => getDataFlowsResult&#46;Flows[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := nas.GetDataFlows(ctx, &nas.GetDataFlowsArgs{
     * 			FileSystemId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nasDataFlowId1", ids.Flows[0].Id)
     * 		status, err := nas.GetDataFlows(ctx, &nas.GetDataFlowsArgs{
     * 			FileSystemId: "example_value",
     * 			Status:       pulumi.StringRef("Running"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nasDataFlowId2", status.Flows[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nas.NasFunctions;
     * import com.pulumi.alicloud.nas.inputs.GetDataFlowsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = NasFunctions.getDataFlows(GetDataFlowsArgs.builder()
     *             .fileSystemId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("nasDataFlowId1", ids.applyValue(getDataFlowsResult -> getDataFlowsResult.flows()[0].id()));
     *         final var status = NasFunctions.getDataFlows(GetDataFlowsArgs.builder()
     *             .fileSystemId("example_value")
     *             .status("Running")
     *             .build());
     *         ctx.export("nasDataFlowId2", status.applyValue(getDataFlowsResult -> getDataFlowsResult.flows()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:nas:getDataFlows
     *       Arguments:
     *         fileSystemId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   status:
     *     fn::invoke:
     *       Function: alicloud:nas:getDataFlows
     *       Arguments:
     *         fileSystemId: example_value
     *         status: Running
     * outputs:
     *   nasDataFlowId1: ${ids.flows[0].id}
     *   nasDataFlowId2: ${status.flows[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDataFlows.
     * @return A collection of values returned by getDataFlows.
     */
    public suspend fun getDataFlows(argument: GetDataFlowsPlainArgs): GetDataFlowsResult =
        getDataFlowsResultToKotlin(getDataFlowsPlain(argument.toJava()).await())

    /**
     * @see [getDataFlows].
     * @param fileSystemId The ID of the file system.
     * @param ids A list of Data Flow IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the Data flow. Including: `Starting`, `Running`, `Updating`, `Deleting`, `Stopping`, `Stopped`, `Misconfigured`.
     * @return A collection of values returned by getDataFlows.
     */
    public suspend fun getDataFlows(
        fileSystemId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetDataFlowsResult {
        val argument = GetDataFlowsPlainArgs(
            fileSystemId = fileSystemId,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getDataFlowsResultToKotlin(getDataFlowsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataFlows].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nas&#46;kotlin&#46;inputs&#46;GetDataFlowsPlainArgs].
     * @return A collection of values returned by getDataFlows.
     */
    public suspend fun getDataFlows(argument: suspend GetDataFlowsPlainArgsBuilder.() -> Unit): GetDataFlowsResult {
        val builder = GetDataFlowsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataFlowsResultToKotlin(getDataFlowsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides FileSystems available to the user.
     * > **NOTE**: Available in 1.35.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const fs = alicloud.nas.getFileSystems({
     *     protocolType: "NFS",
     *     descriptionRegex: foo.description,
     * });
     * export const alicloudNasFileSystemsId = fs.then(fs => fs.systems?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * fs = alicloud.nas.get_file_systems(protocol_type="NFS",
     *     description_regex=foo["description"])
     * pulumi.export("alicloudNasFileSystemsId", fs.systems[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var fs = AliCloud.Nas.GetFileSystems.Invoke(new()
     *     {
     *         ProtocolType = "NFS",
     *         DescriptionRegex = foo.Description,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudNasFileSystemsId"] = fs&#46;Apply(getFileSystemsResult => getFileSystemsResult&#46;Systems[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		fs, err := nas.GetFileSystems(ctx, &nas.GetFileSystemsArgs{
     * 			ProtocolType:     pulumi.StringRef("NFS"),
     * 			DescriptionRegex: pulumi.StringRef(foo.Description),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudNasFileSystemsId", fs.Systems[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nas.NasFunctions;
     * import com.pulumi.alicloud.nas.inputs.GetFileSystemsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var fs = NasFunctions.getFileSystems(GetFileSystemsArgs.builder()
     *             .protocolType("NFS")
     *             .descriptionRegex(foo.description())
     *             .build());
     *         ctx.export("alicloudNasFileSystemsId", fs.applyValue(getFileSystemsResult -> getFileSystemsResult.systems()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   fs:
     *     fn::invoke:
     *       Function: alicloud:nas:getFileSystems
     *       Arguments:
     *         protocolType: NFS
     *         descriptionRegex: ${foo.description}
     * outputs:
     *   alicloudNasFileSystemsId: ${fs.systems[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFileSystems.
     * @return A collection of values returned by getFileSystems.
     */
    public suspend fun getFileSystems(argument: GetFileSystemsPlainArgs): GetFileSystemsResult =
        getFileSystemsResultToKotlin(getFileSystemsPlain(argument.toJava()).await())

    /**
     * @see [getFileSystems].
     * @param descriptionRegex A regex string to filter the results by the ：FileSystem description.
     * @param ids A list of FileSystemId.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param protocolType The protocol type of the file system.
     * Valid values:
     * `NFS`,
     * `SMB` (Available when the `file_system_type` is `standard`).
     * @param storageType The storage type of the file system.
     * * Valid values:
     * * `Performance` (Available when the `file_system_type` is `standard`)
     * * `Capacity` (Available when the `file_system_type` is `standard`)
     * @return A collection of values returned by getFileSystems.
     */
    public suspend fun getFileSystems(
        descriptionRegex: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        protocolType: String? = null,
        storageType: String? = null,
    ): GetFileSystemsResult {
        val argument = GetFileSystemsPlainArgs(
            descriptionRegex = descriptionRegex,
            ids = ids,
            outputFile = outputFile,
            protocolType = protocolType,
            storageType = storageType,
        )
        return getFileSystemsResultToKotlin(getFileSystemsPlain(argument.toJava()).await())
    }

    /**
     * @see [getFileSystems].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nas&#46;kotlin&#46;inputs&#46;GetFileSystemsPlainArgs].
     * @return A collection of values returned by getFileSystems.
     */
    public suspend fun getFileSystems(argument: suspend GetFileSystemsPlainArgsBuilder.() -> Unit): GetFileSystemsResult {
        val builder = GetFileSystemsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFileSystemsResultToKotlin(getFileSystemsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Nas Filesets of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.153.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.nas.getFilesets({
     *     fileSystemId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const nasFilesetId1 = ids.then(ids => ids.filesets?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.nas.get_filesets(file_system_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("nasFilesetId1", ids.filesets[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Nas.GetFilesets.Invoke(new()
     *     {
     *         FileSystemId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["nasFilesetId1"] = ids&#46;Apply(getFilesetsResult => getFilesetsResult&#46;Filesets[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := nas.GetFilesets(ctx, &nas.GetFilesetsArgs{
     * 			FileSystemId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nasFilesetId1", ids.Filesets[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nas.NasFunctions;
     * import com.pulumi.alicloud.nas.inputs.GetFilesetsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = NasFunctions.getFilesets(GetFilesetsArgs.builder()
     *             .fileSystemId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("nasFilesetId1", ids.applyValue(getFilesetsResult -> getFilesetsResult.filesets()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:nas:getFilesets
     *       Arguments:
     *         fileSystemId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   nasFilesetId1: ${ids.filesets[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFilesets.
     * @return A collection of values returned by getFilesets.
     */
    public suspend fun getFilesets(argument: GetFilesetsPlainArgs): GetFilesetsResult =
        getFilesetsResultToKotlin(getFilesetsPlain(argument.toJava()).await())

    /**
     * @see [getFilesets].
     * @param fileSystemId The ID of the file system.
     * @param ids A list of Fileset IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the fileset. Valid values: `CREATED`, `CREATING`, `RELEASED`, `RELEASING`.
     * @return A collection of values returned by getFilesets.
     */
    public suspend fun getFilesets(
        fileSystemId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetFilesetsResult {
        val argument = GetFilesetsPlainArgs(
            fileSystemId = fileSystemId,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getFilesetsResultToKotlin(getFilesetsPlain(argument.toJava()).await())
    }

    /**
     * @see [getFilesets].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nas&#46;kotlin&#46;inputs&#46;GetFilesetsPlainArgs].
     * @return A collection of values returned by getFilesets.
     */
    public suspend fun getFilesets(argument: suspend GetFilesetsPlainArgsBuilder.() -> Unit): GetFilesetsResult {
        val builder = GetFilesetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFilesetsResultToKotlin(getFilesetsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Nas Lifecycle Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.153.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.nas.getLifecyclePolicies({
     *     fileSystemId: "example_value",
     *     ids: [
     *         "my-LifecyclePolicy-1",
     *         "my-LifecyclePolicy-2",
     *     ],
     * });
     * export const nasLifecyclePolicyId1 = ids.then(ids => ids.policies?.[0]?.id);
     * const nameRegex = alicloud.nas.getLifecyclePolicies({
     *     fileSystemId: "example_value",
     *     nameRegex: "^my-LifecyclePolicy",
     * });
     * export const nasLifecyclePolicyId2 = nameRegex.then(nameRegex => nameRegex.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.nas.get_lifecycle_policies(file_system_id="example_value",
     *     ids=[
     *         "my-LifecyclePolicy-1",
     *         "my-LifecyclePolicy-2",
     *     ])
     * pulumi.export("nasLifecyclePolicyId1", ids.policies[0].id)
     * name_regex = alicloud.nas.get_lifecycle_policies(file_system_id="example_value",
     *     name_regex="^my-LifecyclePolicy")
     * pulumi.export("nasLifecyclePolicyId2", name_regex.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Nas.GetLifecyclePolicies.Invoke(new()
     *     {
     *         FileSystemId = "example_value",
     *         Ids = new[]
     *         {
     *             "my-LifecyclePolicy-1",
     *             "my-LifecyclePolicy-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Nas.GetLifecyclePolicies.Invoke(new()
     *     {
     *         FileSystemId = "example_value",
     *         NameRegex = "^my-LifecyclePolicy",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["nasLifecyclePolicyId1"] = ids&#46;Apply(getLifecyclePoliciesResult => getLifecyclePoliciesResult&#46;Policies[0]?.Id),
     *         ["nasLifecyclePolicyId2"] = nameRegex&#46;Apply(getLifecyclePoliciesResult => getLifecyclePoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := nas.GetLifecyclePolicies(ctx, &nas.GetLifecyclePoliciesArgs{
     * 			FileSystemId: "example_value",
     * 			Ids: []string{
     * 				"my-LifecyclePolicy-1",
     * 				"my-LifecyclePolicy-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nasLifecyclePolicyId1", ids.Policies[0].Id)
     * 		nameRegex, err := nas.GetLifecyclePolicies(ctx, &nas.GetLifecyclePoliciesArgs{
     * 			FileSystemId: "example_value",
     * 			NameRegex:    pulumi.StringRef("^my-LifecyclePolicy"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nasLifecyclePolicyId2", nameRegex.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nas.NasFunctions;
     * import com.pulumi.alicloud.nas.inputs.GetLifecyclePoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = NasFunctions.getLifecyclePolicies(GetLifecyclePoliciesArgs.builder()
     *             .fileSystemId("example_value")
     *             .ids(
     *                 "my-LifecyclePolicy-1",
     *                 "my-LifecyclePolicy-2")
     *             .build());
     *         ctx.export("nasLifecyclePolicyId1", ids.applyValue(getLifecyclePoliciesResult -> getLifecyclePoliciesResult.policies()[0].id()));
     *         final var nameRegex = NasFunctions.getLifecyclePolicies(GetLifecyclePoliciesArgs.builder()
     *             .fileSystemId("example_value")
     *             .nameRegex("^my-LifecyclePolicy")
     *             .build());
     *         ctx.export("nasLifecyclePolicyId2", nameRegex.applyValue(getLifecyclePoliciesResult -> getLifecyclePoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:nas:getLifecyclePolicies
     *       Arguments:
     *         fileSystemId: example_value
     *         ids:
     *           - my-LifecyclePolicy-1
     *           - my-LifecyclePolicy-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:nas:getLifecyclePolicies
     *       Arguments:
     *         fileSystemId: example_value
     *         nameRegex: ^my-LifecyclePolicy
     * outputs:
     *   nasLifecyclePolicyId1: ${ids.policies[0].id}
     *   nasLifecyclePolicyId2: ${nameRegex.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLifecyclePolicies.
     * @return A collection of values returned by getLifecyclePolicies.
     */
    public suspend fun getLifecyclePolicies(argument: GetLifecyclePoliciesPlainArgs): GetLifecyclePoliciesResult =
        getLifecyclePoliciesResultToKotlin(getLifecyclePoliciesPlain(argument.toJava()).await())

    /**
     * @see [getLifecyclePolicies].
     * @param fileSystemId The ID of the file system.
     * @param ids A list of Lifecycle Policy IDs.
     * @param nameRegex A regex string to filter results by Lifecycle Policy name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getLifecyclePolicies.
     */
    public suspend fun getLifecyclePolicies(
        fileSystemId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetLifecyclePoliciesResult {
        val argument = GetLifecyclePoliciesPlainArgs(
            fileSystemId = fileSystemId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getLifecyclePoliciesResultToKotlin(getLifecyclePoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getLifecyclePolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nas&#46;kotlin&#46;inputs&#46;GetLifecyclePoliciesPlainArgs].
     * @return A collection of values returned by getLifecyclePolicies.
     */
    public suspend fun getLifecyclePolicies(argument: suspend GetLifecyclePoliciesPlainArgsBuilder.() -> Unit): GetLifecyclePoliciesResult {
        val builder = GetLifecyclePoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLifecyclePoliciesResultToKotlin(getLifecyclePoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides MountTargets available to the user.
     * > **NOTE**: Available in 1.35.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.nas.getMountTargets({
     *     fileSystemId: "1a2sc4d",
     *     accessGroupName: "tf-testAccNasConfig",
     * });
     * export const theFirstMountTargetDomain = example.then(example => example.targets?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.nas.get_mount_targets(file_system_id="1a2sc4d",
     *     access_group_name="tf-testAccNasConfig")
     * pulumi.export("theFirstMountTargetDomain", example.targets[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Nas.GetMountTargets.Invoke(new()
     *     {
     *         FileSystemId = "1a2sc4d",
     *         AccessGroupName = "tf-testAccNasConfig",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["theFirstMountTargetDomain"] = example&#46;Apply(getMountTargetsResult => getMountTargetsResult&#46;Targets[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := nas.GetMountTargets(ctx, &nas.GetMountTargetsArgs{
     * 			FileSystemId:    "1a2sc4d",
     * 			AccessGroupName: pulumi.StringRef("tf-testAccNasConfig"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("theFirstMountTargetDomain", example.Targets[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nas.NasFunctions;
     * import com.pulumi.alicloud.nas.inputs.GetMountTargetsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NasFunctions.getMountTargets(GetMountTargetsArgs.builder()
     *             .fileSystemId("1a2sc4d")
     *             .accessGroupName("tf-testAccNasConfig")
     *             .build());
     *         ctx.export("theFirstMountTargetDomain", example.applyValue(getMountTargetsResult -> getMountTargetsResult.targets()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:nas:getMountTargets
     *       Arguments:
     *         fileSystemId: 1a2sc4d
     *         accessGroupName: tf-testAccNasConfig
     * outputs:
     *   theFirstMountTargetDomain: ${example.targets[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMountTargets.
     * @return A collection of values returned by getMountTargets.
     */
    public suspend fun getMountTargets(argument: GetMountTargetsPlainArgs): GetMountTargetsResult =
        getMountTargetsResultToKotlin(getMountTargetsPlain(argument.toJava()).await())

    /**
     * @see [getMountTargets].
     * @param accessGroupName Filter results by a specific AccessGroupName.
     * @param fileSystemId The ID of the FileSystem that owns the MountTarget.
     * @param ids A list of MountTargetDomain.
     * @param mountTargetDomain Field `mount_target_domain` has been deprecated from provider version 1.53.0. New field `ids` replaces it.
     * @param networkType Filter results by a specific NetworkType.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status Filter results by the status of mount target. Valid values: `Active`, `Inactive` and `Pending`.
     * @param type Field `type` has been deprecated from provider version 1.95.0. New field `network_type` replaces it.
     * @param vpcId Filter results by a specific VpcId.
     * @param vswitchId Filter results by a specific VSwitchId.
     * @return A collection of values returned by getMountTargets.
     */
    public suspend fun getMountTargets(
        accessGroupName: String? = null,
        fileSystemId: String,
        ids: List<String>? = null,
        mountTargetDomain: String? = null,
        networkType: String? = null,
        outputFile: String? = null,
        status: String? = null,
        type: String? = null,
        vpcId: String? = null,
        vswitchId: String? = null,
    ): GetMountTargetsResult {
        val argument = GetMountTargetsPlainArgs(
            accessGroupName = accessGroupName,
            fileSystemId = fileSystemId,
            ids = ids,
            mountTargetDomain = mountTargetDomain,
            networkType = networkType,
            outputFile = outputFile,
            status = status,
            type = type,
            vpcId = vpcId,
            vswitchId = vswitchId,
        )
        return getMountTargetsResultToKotlin(getMountTargetsPlain(argument.toJava()).await())
    }

    /**
     * @see [getMountTargets].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nas&#46;kotlin&#46;inputs&#46;GetMountTargetsPlainArgs].
     * @return A collection of values returned by getMountTargets.
     */
    public suspend fun getMountTargets(argument: suspend GetMountTargetsPlainArgsBuilder.() -> Unit): GetMountTargetsResult {
        val builder = GetMountTargetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMountTargetsResultToKotlin(getMountTargetsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provide  a data source to retrieve the type of protocol used to create NAS file system.
     * > **NOTE:** Available in 1.42.0
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.nas.getProtocols({
     *     type: "Performance",
     *     zoneId: "cn-beijing-e",
     *     outputFile: "protocols.txt",
     * });
     * export const nasProtocolsProtocol = _default.then(_default => _default.protocols?.[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.nas.get_protocols(type="Performance",
     *     zone_id="cn-beijing-e",
     *     output_file="protocols.txt")
     * pulumi.export("nasProtocolsProtocol", default.protocols[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Nas.GetProtocols.Invoke(new()
     *     {
     *         Type = "Performance",
     *         ZoneId = "cn-beijing-e",
     *         OutputFile = "protocols.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["nasProtocolsProtocol"] = @default&#46;Apply(@default => @default&#46;Apply(getProtocolsResult => getProtocolsResult&#46;Protocols[0])),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := nas.GetProtocols(ctx, &nas.GetProtocolsArgs{
     * 			Type:       "Performance",
     * 			ZoneId:     pulumi.StringRef("cn-beijing-e"),
     * 			OutputFile: pulumi.StringRef("protocols.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nasProtocolsProtocol", _default.Protocols[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nas.NasFunctions;
     * import com.pulumi.alicloud.nas.inputs.GetProtocolsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = NasFunctions.getProtocols(GetProtocolsArgs.builder()
     *             .type("Performance")
     *             .zoneId("cn-beijing-e")
     *             .outputFile("protocols.txt")
     *             .build());
     *         ctx.export("nasProtocolsProtocol", default_.protocols()[0]);
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:nas:getProtocols
     *       Arguments:
     *         type: Performance
     *         zoneId: cn-beijing-e
     *         outputFile: protocols.txt
     * outputs:
     *   nasProtocolsProtocol: ${default.protocols[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProtocols.
     * @return A collection of values returned by getProtocols.
     */
    public suspend fun getProtocols(argument: GetProtocolsPlainArgs): GetProtocolsResult =
        getProtocolsResultToKotlin(getProtocolsPlain(argument.toJava()).await())

    /**
     * @see [getProtocols].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param type The file system type. Valid Values: `Performance` and `Capacity`.
     * @param zoneId String to filter results by zone id.
     * @return A collection of values returned by getProtocols.
     */
    public suspend fun getProtocols(
        outputFile: String? = null,
        type: String,
        zoneId: String? = null,
    ): GetProtocolsResult {
        val argument = GetProtocolsPlainArgs(
            outputFile = outputFile,
            type = type,
            zoneId = zoneId,
        )
        return getProtocolsResultToKotlin(getProtocolsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProtocols].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nas&#46;kotlin&#46;inputs&#46;GetProtocolsPlainArgs].
     * @return A collection of values returned by getProtocols.
     */
    public suspend fun getProtocols(argument: suspend GetProtocolsPlainArgsBuilder.() -> Unit): GetProtocolsResult {
        val builder = GetProtocolsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProtocolsResultToKotlin(getProtocolsPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can enable NAS service automatically. If the service has been enabled, it will return `Opened`.
     * For information about NAS and how to use it, see [What is NAS](https://www.alibabacloud.com/help/product/27516.htm).
     * > **NOTE:** Available in v1.97.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.nas.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.nas.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Nas.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := nas.GetService(ctx, &nas.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nas.NasFunctions;
     * import com.pulumi.alicloud.nas.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = NasFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:nas:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * > **NOTE:** Setting `enable = "On"` to open the NAS service that means you have read and agreed the [NAS Terms of Service](https://www.alibabacloud.com/help/en/scu/latest/overview-of-scu). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nas&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Nas Snapshots of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.152.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.nas.getSnapshots({});
     * export const nasSnapshotId1 = ids.then(ids => ids.snapshots?.[0]?.id);
     * const nameRegex = alicloud.nas.getSnapshots({
     *     nameRegex: "^my-Snapshot",
     * });
     * export const nasSnapshotId2 = nameRegex.then(nameRegex => nameRegex.snapshots?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.nas.get_snapshots()
     * pulumi.export("nasSnapshotId1", ids.snapshots[0].id)
     * name_regex = alicloud.nas.get_snapshots(name_regex="^my-Snapshot")
     * pulumi.export("nasSnapshotId2", name_regex.snapshots[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Nas.GetSnapshots.Invoke();
     *     var nameRegex = AliCloud.Nas.GetSnapshots.Invoke(new()
     *     {
     *         NameRegex = "^my-Snapshot",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["nasSnapshotId1"] = ids&#46;Apply(getSnapshotsResult => getSnapshotsResult&#46;Snapshots[0]?.Id),
     *         ["nasSnapshotId2"] = nameRegex&#46;Apply(getSnapshotsResult => getSnapshotsResult&#46;Snapshots[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := nas.GetSnapshots(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nasSnapshotId1", ids.Snapshots[0].Id)
     * 		nameRegex, err := nas.GetSnapshots(ctx, &nas.GetSnapshotsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Snapshot"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nasSnapshotId2", nameRegex.Snapshots[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nas.NasFunctions;
     * import com.pulumi.alicloud.nas.inputs.GetSnapshotsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = NasFunctions.getSnapshots();
     *         ctx.export("nasSnapshotId1", ids.applyValue(getSnapshotsResult -> getSnapshotsResult.snapshots()[0].id()));
     *         final var nameRegex = NasFunctions.getSnapshots(GetSnapshotsArgs.builder()
     *             .nameRegex("^my-Snapshot")
     *             .build());
     *         ctx.export("nasSnapshotId2", nameRegex.applyValue(getSnapshotsResult -> getSnapshotsResult.snapshots()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:nas:getSnapshots
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:nas:getSnapshots
     *       Arguments:
     *         nameRegex: ^my-Snapshot
     * outputs:
     *   nasSnapshotId1: ${ids.snapshots[0].id}
     *   nasSnapshotId2: ${nameRegex.snapshots[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSnapshots.
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(argument: GetSnapshotsPlainArgs): GetSnapshotsResult =
        getSnapshotsResultToKotlin(getSnapshotsPlain(argument.toJava()).await())

    /**
     * @see [getSnapshots].
     * @param fileSystemId The ID of the file system.
     * @param ids A list of Snapshot IDs.
     * @param nameRegex A regex string to filter results by Snapshot name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param snapshotName The name of the snapshot.
     * @param status Status. Valid values: `accomplished`, `failed`, `progressing`.
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(
        fileSystemId: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        snapshotName: String? = null,
        status: String? = null,
    ): GetSnapshotsResult {
        val argument = GetSnapshotsPlainArgs(
            fileSystemId = fileSystemId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            snapshotName = snapshotName,
            status = status,
        )
        return getSnapshotsResultToKotlin(getSnapshotsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshots].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nas&#46;kotlin&#46;inputs&#46;GetSnapshotsPlainArgs].
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(argument: suspend GetSnapshotsPlainArgsBuilder.() -> Unit): GetSnapshotsResult {
        val builder = GetSnapshotsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotsResultToKotlin(getSnapshotsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provide  a data source to retrieve the type of zone used to create NAS file system.
     * > **NOTE:** Available in v1.140.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.nas.getZones({});
     * export const alicloudNasZonesId = _default.then(_default => _default.zones?.[0]?.zoneId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.nas.get_zones()
     * pulumi.export("alicloudNasZonesId", default.zones[0].zone_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Nas.GetZones.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudNasZonesId"] = @default&#46;Apply(@default => @default&#46;Apply(getZonesResult => getZonesResult&#46;Zones[0]?.ZoneId)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := nas.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudNasZonesId", _default.Zones[0].ZoneId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nas.NasFunctions;
     * import com.pulumi.alicloud.nas.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = NasFunctions.getZones();
     *         ctx.export("alicloudNasZonesId", default_.zones()[0].zoneId());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:nas:getZones
     *       Arguments: {}
     * outputs:
     *   alicloudNasZonesId: ${default.zones[0].zoneId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param fileSystemType The type of the file system.  Valid values: `standard`, `extreme`, `cpfs`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(fileSystemType: String? = null, outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            fileSystemType = fileSystemType,
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nas&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
