@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.alicloud.nas.SmbAclAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Nas Smb Acl resource.
 * Alibaba Cloud SMB protocol file storage service supports user authentication based on AD domain system and permission access control at the file system level. Connecting and accessing the SMB file system as a domain user can implement the requirements for access control at the file and directory level in the SMB protocol file system. The current Alibaba Cloud SMB protocol file storage service does not support multi-user file and directory-level permission access control, and only provides file system-level authentication and access based on the whitelist mechanism that supports cloud accounts and source IP permission groups control.
 * > **NOTE:** Available in 1.186.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.nas.getZones({
 *     fileSystemType: "standard",
 * });
 * const exampleFileSystem = new alicloud.nas.FileSystem("example", {
 *     protocolType: "SMB",
 *     storageType: "Capacity",
 *     description: "terraform-example",
 *     encryptType: 0,
 *     fileSystemType: "standard",
 *     zoneId: example.then(example => example.zones?.[0]?.zoneId),
 * });
 * const exampleSmbAclAttachment = new alicloud.nas.SmbAclAttachment("example", {
 *     fileSystemId: exampleFileSystem.id,
 *     keytab: "BQIAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAQAIqIx6v7p11oUAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAwAIqIx6v7p11oUAAABPAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAFwAQnQZWB3RAPHU7PMIJyBWePAAAAF8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQASACAGJ7F0s+bcBjf6jD5HlvlRLmPSOW+qDZe0Qk0lQcf8WwAAAE8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQARABDdFmanrSIatnDDhoOXYadj",
 *     keytabMd5: "E3CCF7E2416DF04FA958AA4513EA29E8",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.nas.get_zones(file_system_type="standard")
 * example_file_system = alicloud.nas.FileSystem("example",
 *     protocol_type="SMB",
 *     storage_type="Capacity",
 *     description="terraform-example",
 *     encrypt_type=0,
 *     file_system_type="standard",
 *     zone_id=example.zones[0].zone_id)
 * example_smb_acl_attachment = alicloud.nas.SmbAclAttachment("example",
 *     file_system_id=example_file_system.id,
 *     keytab="BQIAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAQAIqIx6v7p11oUAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAwAIqIx6v7p11oUAAABPAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAFwAQnQZWB3RAPHU7PMIJyBWePAAAAF8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQASACAGJ7F0s+bcBjf6jD5HlvlRLmPSOW+qDZe0Qk0lQcf8WwAAAE8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQARABDdFmanrSIatnDDhoOXYadj",
 *     keytab_md5="E3CCF7E2416DF04FA958AA4513EA29E8")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.Nas.GetZones.Invoke(new()
 *     {
 *         FileSystemType = "standard",
 *     });
 *     var exampleFileSystem = new AliCloud.Nas.FileSystem("example", new()
 *     {
 *         ProtocolType = "SMB",
 *         StorageType = "Capacity",
 *         Description = "terraform-example",
 *         EncryptType = 0,
 *         FileSystemType = "standard",
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[0]?.ZoneId),
 *     });
 *     var exampleSmbAclAttachment = new AliCloud.Nas.SmbAclAttachment("example", new()
 *     {
 *         FileSystemId = exampleFileSystem.Id,
 *         Keytab = "BQIAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAQAIqIx6v7p11oUAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAwAIqIx6v7p11oUAAABPAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAFwAQnQZWB3RAPHU7PMIJyBWePAAAAF8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQASACAGJ7F0s+bcBjf6jD5HlvlRLmPSOW+qDZe0Qk0lQcf8WwAAAE8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQARABDdFmanrSIatnDDhoOXYadj",
 *         KeytabMd5 = "E3CCF7E2416DF04FA958AA4513EA29E8",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := nas.GetZones(ctx, &nas.GetZonesArgs{
 * 			FileSystemType: pulumi.StringRef("standard"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleFileSystem, err := nas.NewFileSystem(ctx, "example", &nas.FileSystemArgs{
 * 			ProtocolType:   pulumi.String("SMB"),
 * 			StorageType:    pulumi.String("Capacity"),
 * 			Description:    pulumi.String("terraform-example"),
 * 			EncryptType:    pulumi.Int(0),
 * 			FileSystemType: pulumi.String("standard"),
 * 			ZoneId:         pulumi.String(example.Zones[0].ZoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewSmbAclAttachment(ctx, "example", &nas.SmbAclAttachmentArgs{
 * 			FileSystemId: exampleFileSystem.ID(),
 * 			Keytab:       pulumi.String("BQIAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAQAIqIx6v7p11oUAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAwAIqIx6v7p11oUAAABPAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAFwAQnQZWB3RAPHU7PMIJyBWePAAAAF8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQASACAGJ7F0s+bcBjf6jD5HlvlRLmPSOW+qDZe0Qk0lQcf8WwAAAE8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQARABDdFmanrSIatnDDhoOXYadj"),
 * 			KeytabMd5:    pulumi.String("E3CCF7E2416DF04FA958AA4513EA29E8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.NasFunctions;
 * import com.pulumi.alicloud.nas.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import com.pulumi.alicloud.nas.SmbAclAttachment;
 * import com.pulumi.alicloud.nas.SmbAclAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = NasFunctions.getZones(GetZonesArgs.builder()
 *             .fileSystemType("standard")
 *             .build());
 *         var exampleFileSystem = new FileSystem("exampleFileSystem", FileSystemArgs.builder()
 *             .protocolType("SMB")
 *             .storageType("Capacity")
 *             .description("terraform-example")
 *             .encryptType("0")
 *             .fileSystemType("standard")
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[0].zoneId()))
 *             .build());
 *         var exampleSmbAclAttachment = new SmbAclAttachment("exampleSmbAclAttachment", SmbAclAttachmentArgs.builder()
 *             .fileSystemId(exampleFileSystem.id())
 *             .keytab("BQIAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAQAIqIx6v7p11oUAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAwAIqIx6v7p11oUAAABPAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAFwAQnQZWB3RAPHU7PMIJyBWePAAAAF8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQASACAGJ7F0s+bcBjf6jD5HlvlRLmPSOW+qDZe0Qk0lQcf8WwAAAE8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQARABDdFmanrSIatnDDhoOXYadj")
 *             .keytabMd5("E3CCF7E2416DF04FA958AA4513EA29E8")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleFileSystem:
 *     type: alicloud:nas:FileSystem
 *     name: example
 *     properties:
 *       protocolType: SMB
 *       storageType: Capacity
 *       description: terraform-example
 *       encryptType: '0'
 *       fileSystemType: standard
 *       zoneId: ${example.zones[0].zoneId}
 *   exampleSmbAclAttachment:
 *     type: alicloud:nas:SmbAclAttachment
 *     name: example
 *     properties:
 *       fileSystemId: ${exampleFileSystem.id}
 *       keytab: BQIAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAQAIqIx6v7p11oUAAABHAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAAwAIqIx6v7p11oUAAABPAAIADUFMSUFEVEVTVC5DT00ABGNpZnMAGXNtYnNlcnZlcjI0LmFsaWFkdGVzdC5jb20AAAABAAAAAAEAFwAQnQZWB3RAPHU7PMIJyBWePAAAAF8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQASACAGJ7F0s+bcBjf6jD5HlvlRLmPSOW+qDZe0Qk0lQcf8WwAAAE8AAgANQUxJQURURVNULkNPTQAEY2lmcwAZc21ic2VydmVyMjQuYWxpYWR0ZXN0LmNvbQAAAAEAAAAAAQARABDdFmanrSIatnDDhoOXYadj
 *       keytabMd5: E3CCF7E2416DF04FA958AA4513EA29E8
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:nas:getZones
 *       Arguments:
 *         fileSystemType: standard
 * ```
 * <!--End PulumiCodeChooser -->
 * @property enableAnonymousAccess Specifies whether to allow anonymous access. Valid values:
 * true: The file system allows anonymous access.
 * false: The file system denies anonymous access. Default value: false.
 * @property encryptData Specifies whether to enable encryption in transit. Valid values:
 * true: enables encryption in transit.
 * false: disables encryption in transit. Default value: false.
 * @property fileSystemId The ID of the file system.
 * @property homeDirPath The home directory of each user. Each user-specific home directory must meet the following requirements:
 * Each segment starts with a forward slash (/) or a backslash (\).
 * Each segment does not contain the following special characters: <>":?*.
 * Each segment is 0 to 255 characters in length.
 * The total length is 0 to 32,767 characters.
 * For example, if you create a user named A and the home directory is /home, the file system automatically creates a directory named /home/A when User A logs on to the file system. If the /home/A directory already exists, the file system does not create the directory.
 * @property keytab The string that is generated after the system encodes the keytab file by using Base64.
 * @property keytabMd5 RThe string that is generated after the system encodes the keytab file by using MD5.
 * @property rejectUnencryptedAccess Specifies whether to deny access from non-encrypted clients. Valid values:
 * true: The file system denies access from non-encrypted clients.
 * false: The file system allows access from non-encrypted clients. Default value: false.
 * @property superAdminSid The ID of a super admin. The ID must meet the following requirements:
 * The ID starts with S and does not contain letters except S.
 * The ID contains at least three hyphens (-) as delimiters.
 * Example: S-1-5-22 and S-1-5-22-23.
 */
public data class SmbAclAttachmentArgs(
    public val enableAnonymousAccess: Output<Boolean>? = null,
    public val encryptData: Output<Boolean>? = null,
    public val fileSystemId: Output<String>? = null,
    public val homeDirPath: Output<String>? = null,
    public val keytab: Output<String>? = null,
    public val keytabMd5: Output<String>? = null,
    public val rejectUnencryptedAccess: Output<Boolean>? = null,
    public val superAdminSid: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.SmbAclAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.SmbAclAttachmentArgs =
        com.pulumi.alicloud.nas.SmbAclAttachmentArgs.builder()
            .enableAnonymousAccess(enableAnonymousAccess?.applyValue({ args0 -> args0 }))
            .encryptData(encryptData?.applyValue({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .homeDirPath(homeDirPath?.applyValue({ args0 -> args0 }))
            .keytab(keytab?.applyValue({ args0 -> args0 }))
            .keytabMd5(keytabMd5?.applyValue({ args0 -> args0 }))
            .rejectUnencryptedAccess(rejectUnencryptedAccess?.applyValue({ args0 -> args0 }))
            .superAdminSid(superAdminSid?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SmbAclAttachmentArgs].
 */
@PulumiTagMarker
public class SmbAclAttachmentArgsBuilder internal constructor() {
    private var enableAnonymousAccess: Output<Boolean>? = null

    private var encryptData: Output<Boolean>? = null

    private var fileSystemId: Output<String>? = null

    private var homeDirPath: Output<String>? = null

    private var keytab: Output<String>? = null

    private var keytabMd5: Output<String>? = null

    private var rejectUnencryptedAccess: Output<Boolean>? = null

    private var superAdminSid: Output<String>? = null

    /**
     * @param value Specifies whether to allow anonymous access. Valid values:
     * true: The file system allows anonymous access.
     * false: The file system denies anonymous access. Default value: false.
     */
    @JvmName("cncxaqxkxobnrlyu")
    public suspend fun enableAnonymousAccess(`value`: Output<Boolean>) {
        this.enableAnonymousAccess = value
    }

    /**
     * @param value Specifies whether to enable encryption in transit. Valid values:
     * true: enables encryption in transit.
     * false: disables encryption in transit. Default value: false.
     */
    @JvmName("dhjhlpngfrfmupbb")
    public suspend fun encryptData(`value`: Output<Boolean>) {
        this.encryptData = value
    }

    /**
     * @param value The ID of the file system.
     */
    @JvmName("wlyafnkeuesdtoge")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The home directory of each user. Each user-specific home directory must meet the following requirements:
     * Each segment starts with a forward slash (/) or a backslash (\).
     * Each segment does not contain the following special characters: <>":?*.
     * Each segment is 0 to 255 characters in length.
     * The total length is 0 to 32,767 characters.
     * For example, if you create a user named A and the home directory is /home, the file system automatically creates a directory named /home/A when User A logs on to the file system. If the /home/A directory already exists, the file system does not create the directory.
     */
    @JvmName("xxtrtforrxtcadbe")
    public suspend fun homeDirPath(`value`: Output<String>) {
        this.homeDirPath = value
    }

    /**
     * @param value The string that is generated after the system encodes the keytab file by using Base64.
     */
    @JvmName("yigtwtoipayccfwa")
    public suspend fun keytab(`value`: Output<String>) {
        this.keytab = value
    }

    /**
     * @param value RThe string that is generated after the system encodes the keytab file by using MD5.
     */
    @JvmName("jphasgfwawaspumu")
    public suspend fun keytabMd5(`value`: Output<String>) {
        this.keytabMd5 = value
    }

    /**
     * @param value Specifies whether to deny access from non-encrypted clients. Valid values:
     * true: The file system denies access from non-encrypted clients.
     * false: The file system allows access from non-encrypted clients. Default value: false.
     */
    @JvmName("wioyqmqxxmsxavei")
    public suspend fun rejectUnencryptedAccess(`value`: Output<Boolean>) {
        this.rejectUnencryptedAccess = value
    }

    /**
     * @param value The ID of a super admin. The ID must meet the following requirements:
     * The ID starts with S and does not contain letters except S.
     * The ID contains at least three hyphens (-) as delimiters.
     * Example: S-1-5-22 and S-1-5-22-23.
     */
    @JvmName("ckkrwtaycjllydkt")
    public suspend fun superAdminSid(`value`: Output<String>) {
        this.superAdminSid = value
    }

    /**
     * @param value Specifies whether to allow anonymous access. Valid values:
     * true: The file system allows anonymous access.
     * false: The file system denies anonymous access. Default value: false.
     */
    @JvmName("ipswbxijsuqacvpj")
    public suspend fun enableAnonymousAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAnonymousAccess = mapped
    }

    /**
     * @param value Specifies whether to enable encryption in transit. Valid values:
     * true: enables encryption in transit.
     * false: disables encryption in transit. Default value: false.
     */
    @JvmName("adibxqyefwwkkglc")
    public suspend fun encryptData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptData = mapped
    }

    /**
     * @param value The ID of the file system.
     */
    @JvmName("tlxenfmtuauvumrn")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value The home directory of each user. Each user-specific home directory must meet the following requirements:
     * Each segment starts with a forward slash (/) or a backslash (\).
     * Each segment does not contain the following special characters: <>":?*.
     * Each segment is 0 to 255 characters in length.
     * The total length is 0 to 32,767 characters.
     * For example, if you create a user named A and the home directory is /home, the file system automatically creates a directory named /home/A when User A logs on to the file system. If the /home/A directory already exists, the file system does not create the directory.
     */
    @JvmName("yjkaqiwjxeraweqw")
    public suspend fun homeDirPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.homeDirPath = mapped
    }

    /**
     * @param value The string that is generated after the system encodes the keytab file by using Base64.
     */
    @JvmName("etqgfklexexlgucc")
    public suspend fun keytab(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keytab = mapped
    }

    /**
     * @param value RThe string that is generated after the system encodes the keytab file by using MD5.
     */
    @JvmName("cvpoqyrvhitrcalj")
    public suspend fun keytabMd5(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keytabMd5 = mapped
    }

    /**
     * @param value Specifies whether to deny access from non-encrypted clients. Valid values:
     * true: The file system denies access from non-encrypted clients.
     * false: The file system allows access from non-encrypted clients. Default value: false.
     */
    @JvmName("tspkwmscarebjeoj")
    public suspend fun rejectUnencryptedAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectUnencryptedAccess = mapped
    }

    /**
     * @param value The ID of a super admin. The ID must meet the following requirements:
     * The ID starts with S and does not contain letters except S.
     * The ID contains at least three hyphens (-) as delimiters.
     * Example: S-1-5-22 and S-1-5-22-23.
     */
    @JvmName("knqustywomywtrpa")
    public suspend fun superAdminSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.superAdminSid = mapped
    }

    internal fun build(): SmbAclAttachmentArgs = SmbAclAttachmentArgs(
        enableAnonymousAccess = enableAnonymousAccess,
        encryptData = encryptData,
        fileSystemId = fileSystemId,
        homeDirPath = homeDirPath,
        keytab = keytab,
        keytabMd5 = keytabMd5,
        rejectUnencryptedAccess = rejectUnencryptedAccess,
        superAdminSid = superAdminSid,
    )
}
