@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Snapshot].
 */
@PulumiTagMarker
public class SnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotArgs = SnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotArgsBuilder.() -> Unit) {
        val builder = SnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Snapshot {
        val builtJavaResource = com.pulumi.alicloud.nas.Snapshot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Snapshot(builtJavaResource)
    }
}

/**
 * Provides a Network Attached Storage (NAS) Snapshot resource.
 * For information about Network Attached Storage (NAS) Snapshot and how to use it, see [What is Snapshot](https://www.alibabacloud.com/help/en/doc-detail/126549.html).
 * > **NOTE:** Available in v1.152.0+.
 * > **NOTE:** Only Extreme NAS file systems support the snapshot feature.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "testacc";
 * const default = alicloud.nas.getZones({
 *     fileSystemType: "extreme",
 * });
 * const defaultFileSystem = new alicloud.nas.FileSystem("default", {
 *     fileSystemType: "extreme",
 *     protocolType: "NFS",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.zoneId),
 *     storageType: "standard",
 *     capacity: 100,
 * });
 * const defaultSnapshot = new alicloud.nas.Snapshot("default", {
 *     fileSystemId: defaultFileSystem.id,
 *     description: name,
 *     retentionDays: 20,
 *     snapshotName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "testacc"
 * default = alicloud.nas.get_zones(file_system_type="extreme")
 * default_file_system = alicloud.nas.FileSystem("default",
 *     file_system_type="extreme",
 *     protocol_type="NFS",
 *     zone_id=default.zones[0].zone_id,
 *     storage_type="standard",
 *     capacity=100)
 * default_snapshot = alicloud.nas.Snapshot("default",
 *     file_system_id=default_file_system.id,
 *     description=name,
 *     retention_days=20,
 *     snapshot_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "testacc";
 *     var @default = AliCloud.Nas.GetZones.Invoke(new()
 *     {
 *         FileSystemType = "extreme",
 *     });
 *     var defaultFileSystem = new AliCloud.Nas.FileSystem("default", new()
 *     {
 *         FileSystemType = "extreme",
 *         ProtocolType = "NFS",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.ZoneId)),
 *         StorageType = "standard",
 *         Capacity = 100,
 *     });
 *     var defaultSnapshot = new AliCloud.Nas.Snapshot("default", new()
 *     {
 *         FileSystemId = defaultFileSystem.Id,
 *         Description = name,
 *         RetentionDays = 20,
 *         SnapshotName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "testacc"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := nas.GetZones(ctx, &nas.GetZonesArgs{
 * 			FileSystemType: pulumi.StringRef("extreme"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultFileSystem, err := nas.NewFileSystem(ctx, "default", &nas.FileSystemArgs{
 * 			FileSystemType: pulumi.String("extreme"),
 * 			ProtocolType:   pulumi.String("NFS"),
 * 			ZoneId:         pulumi.String(_default.Zones[0].ZoneId),
 * 			StorageType:    pulumi.String("standard"),
 * 			Capacity:       pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nas.NewSnapshot(ctx, "default", &nas.SnapshotArgs{
 * 			FileSystemId:  defaultFileSystem.ID(),
 * 			Description:   pulumi.String(name),
 * 			RetentionDays: pulumi.Int(20),
 * 			SnapshotName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.nas.NasFunctions;
 * import com.pulumi.alicloud.nas.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import com.pulumi.alicloud.nas.Snapshot;
 * import com.pulumi.alicloud.nas.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("testacc");
 *         final var default = NasFunctions.getZones(GetZonesArgs.builder()
 *             .fileSystemType("extreme")
 *             .build());
 *         var defaultFileSystem = new FileSystem("defaultFileSystem", FileSystemArgs.builder()
 *             .fileSystemType("extreme")
 *             .protocolType("NFS")
 *             .zoneId(default_.zones()[0].zoneId())
 *             .storageType("standard")
 *             .capacity(100)
 *             .build());
 *         var defaultSnapshot = new Snapshot("defaultSnapshot", SnapshotArgs.builder()
 *             .fileSystemId(defaultFileSystem.id())
 *             .description(name)
 *             .retentionDays(20)
 *             .snapshotName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: testacc
 * resources:
 *   defaultFileSystem:
 *     type: alicloud:nas:FileSystem
 *     name: default
 *     properties:
 *       fileSystemType: extreme
 *       protocolType: NFS
 *       zoneId: ${default.zones[0].zoneId}
 *       storageType: standard
 *       capacity: 100
 *   defaultSnapshot:
 *     type: alicloud:nas:Snapshot
 *     name: default
 *     properties:
 *       fileSystemId: ${defaultFileSystem.id}
 *       description: ${name}
 *       retentionDays: 20
 *       snapshotName: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:nas:getZones
 *       Arguments:
 *         fileSystemType: extreme
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Network Attached Storage (NAS) Snapshot can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nas/snapshot:Snapshot example <id>
 * ```
 */
public class Snapshot internal constructor(
    override val javaResource: com.pulumi.alicloud.nas.Snapshot,
) : KotlinCustomResource(javaResource, SnapshotMapper) {
    /**
     * The description of the snapshot. It must be `2` to `256` characters in length and cannot start with `https://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the file system.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    /**
     * The retention period of the snapshot. Unit: days. Valid values:
     * * `-1`: The default value. Auto snapshots are permanently retained. After the number of auto snapshots exceeds the upper limit, the earliest auto snapshot is automatically deleted.
     */
    public val retentionDays: Output<Int>?
        get() = javaResource.retentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SnapshotName. It must be `2` to `128` characters in length and must start with a letter, but cannot start with `https://` or `https://`.
     */
    public val snapshotName: Output<String>?
        get() = javaResource.snapshotName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the snapshot.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object SnapshotMapper : ResourceMapper<Snapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nas.Snapshot::class == javaResource::class

    override fun map(javaResource: Resource): Snapshot = Snapshot(
        javaResource as
            com.pulumi.alicloud.nas.Snapshot,
    )
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Snapshot].
 */
public suspend fun snapshot(name: String, block: suspend SnapshotResourceBuilder.() -> Unit): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshot(name: String): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
