@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.inputs

import com.pulumi.alicloud.nas.inputs.AccessPointPosixUserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property posixGroupId The ID of the Posix user group.
 * @property posixSecondaryGroupIds The ID of the second user group.
 * @property posixUserId The Posix user ID.
 */
public data class AccessPointPosixUserArgs(
    public val posixGroupId: Output<Int>? = null,
    public val posixSecondaryGroupIds: Output<List<Int>>? = null,
    public val posixUserId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.inputs.AccessPointPosixUserArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.inputs.AccessPointPosixUserArgs =
        com.pulumi.alicloud.nas.inputs.AccessPointPosixUserArgs.builder()
            .posixGroupId(posixGroupId?.applyValue({ args0 -> args0 }))
            .posixSecondaryGroupIds(
                posixSecondaryGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .posixUserId(posixUserId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPointPosixUserArgs].
 */
@PulumiTagMarker
public class AccessPointPosixUserArgsBuilder internal constructor() {
    private var posixGroupId: Output<Int>? = null

    private var posixSecondaryGroupIds: Output<List<Int>>? = null

    private var posixUserId: Output<Int>? = null

    /**
     * @param value The ID of the Posix user group.
     */
    @JvmName("bbalfrhvnbcupgsr")
    public suspend fun posixGroupId(`value`: Output<Int>) {
        this.posixGroupId = value
    }

    /**
     * @param value The ID of the second user group.
     */
    @JvmName("lmwmbgyumiparrti")
    public suspend fun posixSecondaryGroupIds(`value`: Output<List<Int>>) {
        this.posixSecondaryGroupIds = value
    }

    @JvmName("vwuifeqdtybguhsu")
    public suspend fun posixSecondaryGroupIds(vararg values: Output<Int>) {
        this.posixSecondaryGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The ID of the second user group.
     */
    @JvmName("yxwtcpydlyedawiv")
    public suspend fun posixSecondaryGroupIds(values: List<Output<Int>>) {
        this.posixSecondaryGroupIds = Output.all(values)
    }

    /**
     * @param value The Posix user ID.
     */
    @JvmName("kbtyifuqhwhjdlhx")
    public suspend fun posixUserId(`value`: Output<Int>) {
        this.posixUserId = value
    }

    /**
     * @param value The ID of the Posix user group.
     */
    @JvmName("fwganlytkfqisgyj")
    public suspend fun posixGroupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.posixGroupId = mapped
    }

    /**
     * @param value The ID of the second user group.
     */
    @JvmName("qbfdwxyoxlbdcffx")
    public suspend fun posixSecondaryGroupIds(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.posixSecondaryGroupIds = mapped
    }

    /**
     * @param values The ID of the second user group.
     */
    @JvmName("luiuukgqwwxtlhji")
    public suspend fun posixSecondaryGroupIds(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.posixSecondaryGroupIds = mapped
    }

    /**
     * @param value The Posix user ID.
     */
    @JvmName("lpfiantghmdamnrb")
    public suspend fun posixUserId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.posixUserId = mapped
    }

    internal fun build(): AccessPointPosixUserArgs = AccessPointPosixUserArgs(
        posixGroupId = posixGroupId,
        posixSecondaryGroupIds = posixSecondaryGroupIds,
        posixUserId = posixUserId,
    )
}
