@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.inputs

import com.pulumi.alicloud.nas.inputs.AccessPointRootPathPermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ownerGroupId The ID of the primary user group.
 * @property ownerUserId The owner user ID.
 * @property permission POSIX permission.
 */
public data class AccessPointRootPathPermissionArgs(
    public val ownerGroupId: Output<Int>? = null,
    public val ownerUserId: Output<Int>? = null,
    public val permission: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.inputs.AccessPointRootPathPermissionArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.inputs.AccessPointRootPathPermissionArgs =
        com.pulumi.alicloud.nas.inputs.AccessPointRootPathPermissionArgs.builder()
            .ownerGroupId(ownerGroupId?.applyValue({ args0 -> args0 }))
            .ownerUserId(ownerUserId?.applyValue({ args0 -> args0 }))
            .permission(permission?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPointRootPathPermissionArgs].
 */
@PulumiTagMarker
public class AccessPointRootPathPermissionArgsBuilder internal constructor() {
    private var ownerGroupId: Output<Int>? = null

    private var ownerUserId: Output<Int>? = null

    private var permission: Output<String>? = null

    /**
     * @param value The ID of the primary user group.
     */
    @JvmName("xofajdyxuyihhvxr")
    public suspend fun ownerGroupId(`value`: Output<Int>) {
        this.ownerGroupId = value
    }

    /**
     * @param value The owner user ID.
     */
    @JvmName("ipuvvpvpsqqxfjvc")
    public suspend fun ownerUserId(`value`: Output<Int>) {
        this.ownerUserId = value
    }

    /**
     * @param value POSIX permission.
     */
    @JvmName("lqbopxbhngymocjb")
    public suspend fun permission(`value`: Output<String>) {
        this.permission = value
    }

    /**
     * @param value The ID of the primary user group.
     */
    @JvmName("ghylxgsdhqsqmjmj")
    public suspend fun ownerGroupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerGroupId = mapped
    }

    /**
     * @param value The owner user ID.
     */
    @JvmName("lpnoquunrlwlbvll")
    public suspend fun ownerUserId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerUserId = mapped
    }

    /**
     * @param value POSIX permission.
     */
    @JvmName("cvepikxbekusldbi")
    public suspend fun permission(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permission = mapped
    }

    internal fun build(): AccessPointRootPathPermissionArgs = AccessPointRootPathPermissionArgs(
        ownerGroupId = ownerGroupId,
        ownerUserId = ownerUserId,
        permission = permission,
    )
}
