@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.inputs

import com.pulumi.alicloud.nas.inputs.GetAccessGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccessGroups.
 * @property accessGroupName The name of access group.
 * @property accessGroupType Filter results by a specific AccessGroupType.
 * @property description Filter results by a specific Description.
 * @property fileSystemType The type of file system. Valid values: `standard` and `extreme`. Default to `standard`.
 * @property nameRegex A regex string to filter AccessGroups by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property type Field `type` has been deprecated from version 1.95.0. Use `access_group_type` instead.
 * @property useutcDateTime Specifies whether the time to return is in UTC. Valid values: true and false.
 */
public data class GetAccessGroupsPlainArgs(
    public val accessGroupName: String? = null,
    public val accessGroupType: String? = null,
    public val description: String? = null,
    public val fileSystemType: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.95.0. New field 'access_group_type'
      replaces it.
  """,
    )
    public val type: String? = null,
    public val useutcDateTime: Boolean? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.inputs.GetAccessGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.inputs.GetAccessGroupsPlainArgs =
        com.pulumi.alicloud.nas.inputs.GetAccessGroupsPlainArgs.builder()
            .accessGroupName(accessGroupName?.let({ args0 -> args0 }))
            .accessGroupType(accessGroupType?.let({ args0 -> args0 }))
            .description(description?.let({ args0 -> args0 }))
            .fileSystemType(fileSystemType?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 }))
            .useutcDateTime(useutcDateTime?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetAccessGroupsPlainArgsBuilder internal constructor() {
    private var accessGroupName: String? = null

    private var accessGroupType: String? = null

    private var description: String? = null

    private var fileSystemType: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var type: String? = null

    private var useutcDateTime: Boolean? = null

    /**
     * @param value The name of access group.
     */
    @JvmName("wligvrtauxpvouml")
    public suspend fun accessGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accessGroupName = mapped
    }

    /**
     * @param value Filter results by a specific AccessGroupType.
     */
    @JvmName("fbutirxmrhctvmrb")
    public suspend fun accessGroupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accessGroupType = mapped
    }

    /**
     * @param value Filter results by a specific Description.
     */
    @JvmName("opmoodtchuqydsus")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value The type of file system. Valid values: `standard` and `extreme`. Default to `standard`.
     */
    @JvmName("rsdaswsbsmakhkde")
    public suspend fun fileSystemType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fileSystemType = mapped
    }

    /**
     * @param value A regex string to filter AccessGroups by name.
     */
    @JvmName("fosdquygafbouseq")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jtnwrwsdveieeluv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Field `type` has been deprecated from version 1.95.0. Use `access_group_type` instead.
     */
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.95.0. New field 'access_group_type'
      replaces it.
  """,
    )
    @JvmName("qdianeswvbjqcdop")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value Specifies whether the time to return is in UTC. Valid values: true and false.
     */
    @JvmName("yaaojwdqawjdsmhu")
    public suspend fun useutcDateTime(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.useutcDateTime = mapped
    }

    internal fun build(): GetAccessGroupsPlainArgs = GetAccessGroupsPlainArgs(
        accessGroupName = accessGroupName,
        accessGroupType = accessGroupType,
        description = description,
        fileSystemType = fileSystemType,
        nameRegex = nameRegex,
        outputFile = outputFile,
        type = type,
        useutcDateTime = useutcDateTime,
    )
}
