@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.inputs

import com.pulumi.alicloud.nas.inputs.GetAccessRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccessRules.
 * @property accessGroupName Filter results by a specific AccessGroupName.
 * @property ids A list of rule IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property rwAccess Filter results by a specific RWAccess.
 * @property sourceCidrIp Filter results by a specific SourceCidrIp.
 * @property userAccess Filter results by a specific UserAccess.
 */
public data class GetAccessRulesPlainArgs(
    public val accessGroupName: String,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val rwAccess: String? = null,
    public val sourceCidrIp: String? = null,
    public val userAccess: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.inputs.GetAccessRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.inputs.GetAccessRulesPlainArgs =
        com.pulumi.alicloud.nas.inputs.GetAccessRulesPlainArgs.builder()
            .accessGroupName(accessGroupName.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .rwAccess(rwAccess?.let({ args0 -> args0 }))
            .sourceCidrIp(sourceCidrIp?.let({ args0 -> args0 }))
            .userAccess(userAccess?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessRulesPlainArgs].
 */
@PulumiTagMarker
public class GetAccessRulesPlainArgsBuilder internal constructor() {
    private var accessGroupName: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var rwAccess: String? = null

    private var sourceCidrIp: String? = null

    private var userAccess: String? = null

    /**
     * @param value Filter results by a specific AccessGroupName.
     */
    @JvmName("lnfgemjgabhfjhyc")
    public suspend fun accessGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accessGroupName = mapped
    }

    /**
     * @param value A list of rule IDs.
     */
    @JvmName("cpxucanvsedacfhu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of rule IDs.
     */
    @JvmName("xkhfbnsqjlffjndw")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dhaajdtsmsslvuow")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Filter results by a specific RWAccess.
     */
    @JvmName("rrouqaucgqjieujd")
    public suspend fun rwAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.rwAccess = mapped
    }

    /**
     * @param value Filter results by a specific SourceCidrIp.
     */
    @JvmName("qgxocnmnapewjmol")
    public suspend fun sourceCidrIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceCidrIp = mapped
    }

    /**
     * @param value Filter results by a specific UserAccess.
     */
    @JvmName("yljjykbojqsnkrbv")
    public suspend fun userAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userAccess = mapped
    }

    internal fun build(): GetAccessRulesPlainArgs = GetAccessRulesPlainArgs(
        accessGroupName = accessGroupName ?: throw PulumiNullFieldException("accessGroupName"),
        ids = ids,
        outputFile = outputFile,
        rwAccess = rwAccess,
        sourceCidrIp = sourceCidrIp,
        userAccess = userAccess,
    )
}
