@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.inputs

import com.pulumi.alicloud.nas.inputs.GetAutoSnapshotPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAutoSnapshotPolicies.
 * @property ids A list of Auto Snapshot Policies IDs.
 * @property nameRegex A regex string to filter results by Auto Snapshot Policy name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the automatic snapshot policy. Valid values: `Creating`, `Available`.
 */
public data class GetAutoSnapshotPoliciesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.inputs.GetAutoSnapshotPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.inputs.GetAutoSnapshotPoliciesPlainArgs =
        com.pulumi.alicloud.nas.inputs.GetAutoSnapshotPoliciesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAutoSnapshotPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetAutoSnapshotPoliciesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Auto Snapshot Policies IDs.
     */
    @JvmName("hakkjxcabcqikpcw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Auto Snapshot Policies IDs.
     */
    @JvmName("ojpycebjblllgkro")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Auto Snapshot Policy name.
     */
    @JvmName("yxmismgafcccgpdl")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("pjdbjgyslydghpur")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the automatic snapshot policy. Valid values: `Creating`, `Available`.
     */
    @JvmName("ujqmharjxkkpobdn")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetAutoSnapshotPoliciesPlainArgs = GetAutoSnapshotPoliciesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
