@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.inputs

import com.pulumi.alicloud.nas.inputs.GetFileSystemsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFileSystems.
 * @property descriptionRegex A regex string to filter the results by the ：FileSystem description.
 * @property ids A list of FileSystemId.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property protocolType The protocol type of the file system.
 * Valid values:
 * `NFS`,
 * `SMB` (Available when the `file_system_type` is `standard`).
 * @property storageType The storage type of the file system.
 * * Valid values:
 * * `Performance` (Available when the `file_system_type` is `standard`)
 * * `Capacity` (Available when the `file_system_type` is `standard`)
 */
public data class GetFileSystemsPlainArgs(
    public val descriptionRegex: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val protocolType: String? = null,
    public val storageType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.inputs.GetFileSystemsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.inputs.GetFileSystemsPlainArgs =
        com.pulumi.alicloud.nas.inputs.GetFileSystemsPlainArgs.builder()
            .descriptionRegex(descriptionRegex?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .protocolType(protocolType?.let({ args0 -> args0 }))
            .storageType(storageType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFileSystemsPlainArgs].
 */
@PulumiTagMarker
public class GetFileSystemsPlainArgsBuilder internal constructor() {
    private var descriptionRegex: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var protocolType: String? = null

    private var storageType: String? = null

    /**
     * @param value A regex string to filter the results by the ：FileSystem description.
     */
    @JvmName("jykbtmtyrlavuahh")
    public suspend fun descriptionRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.descriptionRegex = mapped
    }

    /**
     * @param value A list of FileSystemId.
     */
    @JvmName("pkubvsqqghbownsy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of FileSystemId.
     */
    @JvmName("tndrlfrrswpftcdy")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wqgahkhtuumdymut")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The protocol type of the file system.
     * Valid values:
     * `NFS`,
     * `SMB` (Available when the `file_system_type` is `standard`).
     */
    @JvmName("axlmnwnynvjqnysc")
    public suspend fun protocolType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.protocolType = mapped
    }

    /**
     * @param value The storage type of the file system.
     * * Valid values:
     * * `Performance` (Available when the `file_system_type` is `standard`)
     * * `Capacity` (Available when the `file_system_type` is `standard`)
     */
    @JvmName("wvlfmsyqrbexsvis")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.storageType = mapped
    }

    internal fun build(): GetFileSystemsPlainArgs = GetFileSystemsPlainArgs(
        descriptionRegex = descriptionRegex,
        ids = ids,
        outputFile = outputFile,
        protocolType = protocolType,
        storageType = storageType,
    )
}
