@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.inputs

import com.pulumi.alicloud.nas.inputs.GetFilesetsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFilesets.
 * @property fileSystemId The ID of the file system.
 * @property ids A list of Fileset IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the fileset. Valid values: `CREATED`, `CREATING`, `RELEASED`, `RELEASING`.
 */
public data class GetFilesetsPlainArgs(
    public val fileSystemId: String,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.inputs.GetFilesetsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.inputs.GetFilesetsPlainArgs =
        com.pulumi.alicloud.nas.inputs.GetFilesetsPlainArgs.builder()
            .fileSystemId(fileSystemId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFilesetsPlainArgs].
 */
@PulumiTagMarker
public class GetFilesetsPlainArgsBuilder internal constructor() {
    private var fileSystemId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the file system.
     */
    @JvmName("xrhgyyrsxqxfvbtv")
    public suspend fun fileSystemId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fileSystemId = mapped
    }

    /**
     * @param value A list of Fileset IDs.
     */
    @JvmName("kjuvootdujudjiwv")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Fileset IDs.
     */
    @JvmName("yyvinfrnjbliqmbo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ywsofddoitcjenve")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the fileset. Valid values: `CREATED`, `CREATING`, `RELEASED`, `RELEASING`.
     */
    @JvmName("gebfwxcknywjrvcb")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetFilesetsPlainArgs = GetFilesetsPlainArgs(
        fileSystemId = fileSystemId ?: throw PulumiNullFieldException("fileSystemId"),
        ids = ids,
        outputFile = outputFile,
        status = status,
    )
}
