@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.inputs

import com.pulumi.alicloud.nas.inputs.GetLifecyclePoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLifecyclePolicies.
 * @property fileSystemId The ID of the file system.
 * @property ids A list of Lifecycle Policy IDs.
 * @property nameRegex A regex string to filter results by Lifecycle Policy name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetLifecyclePoliciesPlainArgs(
    public val fileSystemId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.inputs.GetLifecyclePoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.inputs.GetLifecyclePoliciesPlainArgs =
        com.pulumi.alicloud.nas.inputs.GetLifecyclePoliciesPlainArgs.builder()
            .fileSystemId(fileSystemId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLifecyclePoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetLifecyclePoliciesPlainArgsBuilder internal constructor() {
    private var fileSystemId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The ID of the file system.
     */
    @JvmName("yxwqtephixgoxeeq")
    public suspend fun fileSystemId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fileSystemId = mapped
    }

    /**
     * @param value A list of Lifecycle Policy IDs.
     */
    @JvmName("hnxchtynuniwttbf")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Lifecycle Policy IDs.
     */
    @JvmName("tughprnfsakweida")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Lifecycle Policy name.
     */
    @JvmName("sofywefefpoocuun")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("iusacoqfcrpfbuyf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetLifecyclePoliciesPlainArgs = GetLifecyclePoliciesPlainArgs(
        fileSystemId = fileSystemId ?: throw PulumiNullFieldException("fileSystemId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
