@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.inputs

import com.pulumi.alicloud.nas.inputs.GetMountTargetsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMountTargets.
 * @property accessGroupName Filter results by a specific AccessGroupName.
 * @property fileSystemId The ID of the FileSystem that owns the MountTarget.
 * @property ids A list of MountTargetDomain.
 * @property mountTargetDomain Field `mount_target_domain` has been deprecated from provider version 1.53.0. New field `ids` replaces it.
 * @property networkType Filter results by a specific NetworkType.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status Filter results by the status of mount target. Valid values: `Active`, `Inactive` and `Pending`.
 * @property type Field `type` has been deprecated from provider version 1.95.0. New field `network_type` replaces it.
 * @property vpcId Filter results by a specific VpcId.
 * @property vswitchId Filter results by a specific VSwitchId.
 */
public data class GetMountTargetsPlainArgs(
    public val accessGroupName: String? = null,
    public val fileSystemId: String,
    public val ids: List<String>? = null,
    @Deprecated(
        message = """
  Field 'mount_target_domain' has been deprecated from provider version 1.53.0. New field 'ids'
      replaces it.
  """,
    )
    public val mountTargetDomain: String? = null,
    public val networkType: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.95.0. New field 'network_type' replaces
      it.
  """,
    )
    public val type: String? = null,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.inputs.GetMountTargetsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.inputs.GetMountTargetsPlainArgs =
        com.pulumi.alicloud.nas.inputs.GetMountTargetsPlainArgs.builder()
            .accessGroupName(accessGroupName?.let({ args0 -> args0 }))
            .fileSystemId(fileSystemId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .mountTargetDomain(mountTargetDomain?.let({ args0 -> args0 }))
            .networkType(networkType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 }))
            .vpcId(vpcId?.let({ args0 -> args0 }))
            .vswitchId(vswitchId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMountTargetsPlainArgs].
 */
@PulumiTagMarker
public class GetMountTargetsPlainArgsBuilder internal constructor() {
    private var accessGroupName: String? = null

    private var fileSystemId: String? = null

    private var ids: List<String>? = null

    private var mountTargetDomain: String? = null

    private var networkType: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var type: String? = null

    private var vpcId: String? = null

    private var vswitchId: String? = null

    /**
     * @param value Filter results by a specific AccessGroupName.
     */
    @JvmName("rylbwffnpkphlbai")
    public suspend fun accessGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accessGroupName = mapped
    }

    /**
     * @param value The ID of the FileSystem that owns the MountTarget.
     */
    @JvmName("oowprkufwrpcftje")
    public suspend fun fileSystemId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fileSystemId = mapped
    }

    /**
     * @param value A list of MountTargetDomain.
     */
    @JvmName("xbsfecxooqrtckvi")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of MountTargetDomain.
     */
    @JvmName("pivtwfihckiurova")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Field `mount_target_domain` has been deprecated from provider version 1.53.0. New field `ids` replaces it.
     */
    @Deprecated(
        message = """
  Field 'mount_target_domain' has been deprecated from provider version 1.53.0. New field 'ids'
      replaces it.
  """,
    )
    @JvmName("jrjytxduthrntyny")
    public suspend fun mountTargetDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mountTargetDomain = mapped
    }

    /**
     * @param value Filter results by a specific NetworkType.
     */
    @JvmName("trggydrhjkcfrfkm")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wtndlskyxtjmiook")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Filter results by the status of mount target. Valid values: `Active`, `Inactive` and `Pending`.
     */
    @JvmName("pehfkbibvjfbaunf")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value Field `type` has been deprecated from provider version 1.95.0. New field `network_type` replaces it.
     */
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.95.0. New field 'network_type' replaces
      it.
  """,
    )
    @JvmName("lyvnieujgayrtupf")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value Filter results by a specific VpcId.
     */
    @JvmName("cgoqdopdqdydmbmi")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    /**
     * @param value Filter results by a specific VSwitchId.
     */
    @JvmName("gryoyacwqitbhcis")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vswitchId = mapped
    }

    internal fun build(): GetMountTargetsPlainArgs = GetMountTargetsPlainArgs(
        accessGroupName = accessGroupName,
        fileSystemId = fileSystemId ?: throw PulumiNullFieldException("fileSystemId"),
        ids = ids,
        mountTargetDomain = mountTargetDomain,
        networkType = networkType,
        outputFile = outputFile,
        status = status,
        type = type,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
