@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.inputs

import com.pulumi.alicloud.nas.inputs.GetProtocolsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProtocols.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property type The file system type. Valid Values: `Performance` and `Capacity`.
 * @property zoneId String to filter results by zone id.
 */
public data class GetProtocolsPlainArgs(
    public val outputFile: String? = null,
    public val type: String,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.inputs.GetProtocolsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.inputs.GetProtocolsPlainArgs =
        com.pulumi.alicloud.nas.inputs.GetProtocolsPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProtocolsPlainArgs].
 */
@PulumiTagMarker
public class GetProtocolsPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    private var type: String? = null

    private var zoneId: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qshxctjpbdukgmpj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The file system type. Valid Values: `Performance` and `Capacity`.
     */
    @JvmName("jgwhjsnngbgqoree")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value String to filter results by zone id.
     */
    @JvmName("tkljkyfgjtexppme")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetProtocolsPlainArgs = GetProtocolsPlainArgs(
        outputFile = outputFile,
        type = type ?: throw PulumiNullFieldException("type"),
        zoneId = zoneId,
    )
}
