@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.inputs

import com.pulumi.alicloud.nas.inputs.GetSnapshotsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSnapshots.
 * @property fileSystemId The ID of the file system.
 * @property ids A list of Snapshot IDs.
 * @property nameRegex A regex string to filter results by Snapshot name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property snapshotName The name of the snapshot.
 * @property status Status. Valid values: `accomplished`, `failed`, `progressing`.
 */
public data class GetSnapshotsPlainArgs(
    public val fileSystemId: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val snapshotName: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.inputs.GetSnapshotsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.inputs.GetSnapshotsPlainArgs =
        com.pulumi.alicloud.nas.inputs.GetSnapshotsPlainArgs.builder()
            .fileSystemId(fileSystemId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .snapshotName(snapshotName?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSnapshotsPlainArgs].
 */
@PulumiTagMarker
public class GetSnapshotsPlainArgsBuilder internal constructor() {
    private var fileSystemId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var snapshotName: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the file system.
     */
    @JvmName("jhktvvtybgovosxl")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fileSystemId = mapped
    }

    /**
     * @param value A list of Snapshot IDs.
     */
    @JvmName("iekuibthqmjqnovp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Snapshot IDs.
     */
    @JvmName("tgqjsxitpcvfiqem")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Snapshot name.
     */
    @JvmName("osvkhwjqcbuhdjvl")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rmvjrsoojwqxdrri")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of the snapshot.
     */
    @JvmName("lquxqfniioxpvjbj")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotName = mapped
    }

    /**
     * @param value Status. Valid values: `accomplished`, `failed`, `progressing`.
     */
    @JvmName("lnvsfqnnjicrxtnh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetSnapshotsPlainArgs = GetSnapshotsPlainArgs(
        fileSystemId = fileSystemId,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        snapshotName = snapshotName,
        status = status,
    )
}
