@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.inputs

import com.pulumi.alicloud.nas.inputs.GetZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getZones.
 * @property fileSystemType The type of the file system.  Valid values: `standard`, `extreme`, `cpfs`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetZonesPlainArgs(
    public val fileSystemType: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nas.inputs.GetZonesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.nas.inputs.GetZonesPlainArgs =
        com.pulumi.alicloud.nas.inputs.GetZonesPlainArgs.builder()
            .fileSystemType(fileSystemType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetZonesPlainArgs].
 */
@PulumiTagMarker
public class GetZonesPlainArgsBuilder internal constructor() {
    private var fileSystemType: String? = null

    private var outputFile: String? = null

    /**
     * @param value The type of the file system.  Valid values: `standard`, `extreme`, `cpfs`.
     */
    @JvmName("rarwjpbwpkrdqcgy")
    public suspend fun fileSystemType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fileSystemType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wauthbgdndmhwduf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetZonesPlainArgs = GetZonesPlainArgs(
        fileSystemType = fileSystemType,
        outputFile = outputFile,
    )
}
