@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property posixGroupId The ID of the Posix user group.
 * @property posixSecondaryGroupIds The ID of the second user group.
 * @property posixUserId The Posix user ID.
 */
public data class AccessPointPosixUser(
    public val posixGroupId: Int? = null,
    public val posixSecondaryGroupIds: List<Int>? = null,
    public val posixUserId: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.AccessPointPosixUser): AccessPointPosixUser = AccessPointPosixUser(
            posixGroupId = javaType.posixGroupId().map({ args0 -> args0 }).orElse(null),
            posixSecondaryGroupIds = javaType.posixSecondaryGroupIds().map({ args0 -> args0 }),
            posixUserId = javaType.posixUserId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
