@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ownerGroupId The ID of the primary user group.
 * @property ownerUserId The owner user ID.
 * @property permission POSIX permission.
 */
public data class AccessPointRootPathPermission(
    public val ownerGroupId: Int? = null,
    public val ownerUserId: Int? = null,
    public val permission: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.AccessPointRootPathPermission): AccessPointRootPathPermission = AccessPointRootPathPermission(
            ownerGroupId = javaType.ownerGroupId().map({ args0 -> args0 }).orElse(null),
            ownerUserId = javaType.ownerUserId().map({ args0 -> args0 }).orElse(null),
            permission = javaType.permission().map({ args0 -> args0 }).orElse(null),
        )
    }
}
