@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessGroupName The name of access group.
 * @property accessGroupType Filter results by a specific AccessGroupType.
 * @property description Filter results by a specific Description.
 * @property id This ID of this AccessGroup. It is formatted to ``<access_group_id>:<file_system_type>``. Before version 1.95.0, the value is `access_group_name`.
 * @property mountTargetCount MountTargetCount block of the AccessGroup
 * @property ruleCount RuleCount of the AccessGroup.
 * @property type Field `type` has been deprecated from version 1.95.0. Use `access_group_type` instead.
 */
public data class GetAccessGroupsGroup(
    public val accessGroupName: String,
    public val accessGroupType: String,
    public val description: String,
    public val id: String,
    public val mountTargetCount: Int,
    public val ruleCount: Int,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetAccessGroupsGroup): GetAccessGroupsGroup = GetAccessGroupsGroup(
            accessGroupName = javaType.accessGroupName(),
            accessGroupType = javaType.accessGroupType(),
            description = javaType.description(),
            id = javaType.id(),
            mountTargetCount = javaType.mountTargetCount(),
            ruleCount = javaType.ruleCount(),
            type = javaType.type(),
        )
    }
}
