@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAccessGroups.
 * @property accessGroupName (Available in 1.95.0+) The name of the AccessGroup.
 * @property accessGroupType (Available in 1.95.0+) The type of the AccessGroup.
 * @property description Description of the AccessGroup.
 * @property fileSystemType
 * @property groups A list of AccessGroups. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of AccessGroup IDs, the value is set to `names`. After version 1.95.0 the item value as `<access_group_id>:<file_system_type>`.
 * @property nameRegex
 * @property names A list of AccessGroup names.
 * @property outputFile
 * @property type (Deprecated in v1.95.0+) AccessGroupType of the AccessGroup. The Field replace by `access_group_type` after version 1.95.0.
 * @property useutcDateTime
 */
public data class GetAccessGroupsResult(
    public val accessGroupName: String? = null,
    public val accessGroupType: String? = null,
    public val description: String? = null,
    public val fileSystemType: String? = null,
    public val groups: List<GetAccessGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.95.0. New field 'access_group_type'
      replaces it.
  """,
    )
    public val type: String? = null,
    public val useutcDateTime: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetAccessGroupsResult): GetAccessGroupsResult = GetAccessGroupsResult(
            accessGroupName = javaType.accessGroupName().map({ args0 -> args0 }).orElse(null),
            accessGroupType = javaType.accessGroupType().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            fileSystemType = javaType.fileSystemType().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.nas.kotlin.outputs.GetAccessGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            useutcDateTime = javaType.useutcDateTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
