@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAccessRules.
 * @property accessGroupName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of rule IDs, Each element set to `access_rule_id` (Each element formats as `<access_group_name>:<access_rule_id>` before 1.53.0).
 * @property outputFile
 * @property rules A list of AccessRules. Each element contains the following attributes:
 * @property rwAccess RWAccess of the AccessRule.
 * @property sourceCidrIp SourceCidrIp of the AccessRule.
 * @property userAccess UserAccess of the AccessRule
 */
public data class GetAccessRulesResult(
    public val accessGroupName: String,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val rules: List<GetAccessRulesRule>,
    public val rwAccess: String? = null,
    public val sourceCidrIp: String? = null,
    public val userAccess: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetAccessRulesResult): GetAccessRulesResult = GetAccessRulesResult(
            accessGroupName = javaType.accessGroupName(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.nas.kotlin.outputs.GetAccessRulesRule.Companion.toKotlin(args0)
                })
            }),
            rwAccess = javaType.rwAccess().map({ args0 -> args0 }).orElse(null),
            sourceCidrIp = javaType.sourceCidrIp().map({ args0 -> args0 }).orElse(null),
            userAccess = javaType.userAccess().map({ args0 -> args0 }).orElse(null),
        )
    }
}
