@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessRuleId AccessRuleId of the AccessRule.
 * @property priority Priority of the AccessRule.
 * @property rwAccess Filter results by a specific RWAccess.
 * @property sourceCidrIp Filter results by a specific SourceCidrIp.
 * @property userAccess Filter results by a specific UserAccess.
 */
public data class GetAccessRulesRule(
    public val accessRuleId: String,
    public val priority: Int,
    public val rwAccess: String,
    public val sourceCidrIp: String,
    public val userAccess: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetAccessRulesRule): GetAccessRulesRule = GetAccessRulesRule(
            accessRuleId = javaType.accessRuleId(),
            priority = javaType.priority(),
            rwAccess = javaType.rwAccess(),
            sourceCidrIp = javaType.sourceCidrIp(),
            userAccess = javaType.userAccess(),
        )
    }
}
