@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property autoSnapshotPolicyId The ID of the automatic snapshot policy.
 * @property autoSnapshotPolicyName The name of the automatic snapshot policy.
 * @property createTime The time when the automatic snapshot policy was created.
 * @property fileSystemNums The number of file systems to which the automatic snapshot policy applies.
 * @property id ID of the Auto Snapshot Policy.
 * @property repeatWeekdays The day on which an auto snapshot was created.
 * @property retentionDays The number of days for which you want to retain auto snapshots.
 * @property status The status of the automatic snapshot policy. Valid values: `Creating`, `Available`.
 * @property timePoints The point in time at which an auto snapshot was created. Unit: hours.
 */
public data class GetAutoSnapshotPoliciesPolicy(
    public val autoSnapshotPolicyId: String,
    public val autoSnapshotPolicyName: String,
    public val createTime: String,
    public val fileSystemNums: Int,
    public val id: String,
    public val repeatWeekdays: List<String>,
    public val retentionDays: Int,
    public val status: String,
    public val timePoints: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetAutoSnapshotPoliciesPolicy): GetAutoSnapshotPoliciesPolicy = GetAutoSnapshotPoliciesPolicy(
            autoSnapshotPolicyId = javaType.autoSnapshotPolicyId(),
            autoSnapshotPolicyName = javaType.autoSnapshotPolicyName(),
            createTime = javaType.createTime(),
            fileSystemNums = javaType.fileSystemNums(),
            id = javaType.id(),
            repeatWeekdays = javaType.repeatWeekdays().map({ args0 -> args0 }),
            retentionDays = javaType.retentionDays(),
            status = javaType.status(),
            timePoints = javaType.timePoints().map({ args0 -> args0 }),
        )
    }
}
