@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The time when Fileset was created. Executing the ISO8601 standard means that the return format is: 'yyyy-MM-ddTHH:mm:ssZ'.
 * @property dataFlowId The ID of the Data Flow.
 * @property description The Description of data flow.
 * @property errorMessage Error message.
 * @property fileSystemId The ID of the file system.
 * @property fileSystemPath The path of Fileset in the CPFS file system.
 * @property fsetDescription Description of automatic update.
 * @property fsetId The ID of the Fileset.
 * @property id The resource ID of the data flow. The value formats as `<file_system_id>:<data_flow_id>`.
 * @property sourceSecurityType The security protection type of the source storage.
 * @property sourceStorage The access path of the source store. Format: `<storage type>://<path>`.
 * @property status The status of the Data flow.
 * @property throughput The maximum transmission bandwidth of data flow, unit: `MB/s`.
 */
public data class GetDataFlowsFlow(
    public val createTime: String,
    public val dataFlowId: String,
    public val description: String,
    public val errorMessage: String,
    public val fileSystemId: String,
    public val fileSystemPath: String,
    public val fsetDescription: String,
    public val fsetId: String,
    public val id: String,
    public val sourceSecurityType: String,
    public val sourceStorage: String,
    public val status: String,
    public val throughput: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetDataFlowsFlow): GetDataFlowsFlow = GetDataFlowsFlow(
            createTime = javaType.createTime(),
            dataFlowId = javaType.dataFlowId(),
            description = javaType.description(),
            errorMessage = javaType.errorMessage(),
            fileSystemId = javaType.fileSystemId(),
            fileSystemPath = javaType.fileSystemPath(),
            fsetDescription = javaType.fsetDescription(),
            fsetId = javaType.fsetId(),
            id = javaType.id(),
            sourceSecurityType = javaType.sourceSecurityType(),
            sourceStorage = javaType.sourceStorage(),
            status = javaType.status(),
            throughput = javaType.throughput(),
        )
    }
}
