@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getFileSystems.
 * @property descriptionRegex
 * @property descriptions A list of FileSystem descriptions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of FileSystem Id.
 * @property outputFile
 * @property protocolType ProtocolType block of the FileSystem
 * @property storageType StorageType block of the FileSystem.
 * @property systems A list of VPCs. Each element contains the following attributes:
 */
public data class GetFileSystemsResult(
    public val descriptionRegex: String? = null,
    public val descriptions: List<String>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val protocolType: String? = null,
    public val storageType: String? = null,
    public val systems: List<GetFileSystemsSystem>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetFileSystemsResult): GetFileSystemsResult = GetFileSystemsResult(
            descriptionRegex = javaType.descriptionRegex().map({ args0 -> args0 }).orElse(null),
            descriptions = javaType.descriptions().map({ args0 -> args0 }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            protocolType = javaType.protocolType().map({ args0 -> args0 }).orElse(null),
            storageType = javaType.storageType().map({ args0 -> args0 }).orElse(null),
            systems = javaType.systems().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.nas.kotlin.outputs.GetFileSystemsSystem.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
