@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property capacity (Optional, Available in v1.140.0+) The capacity of the file system.
 * @property createTime Time of creation.
 * @property description Description of the FileSystem.
 * @property encryptType (Optional, Available in v1.121.2+) Whether the file system is encrypted.
 * * Valid values:
 * @property fileSystemType The type of the file system.
 * Valid values:
 * `standard` (Default),
 * `extreme`.
 * @property id ID of the FileSystem.
 * @property kmsKeyId (Optional, Available in v1.140.0+) The id of the KMS key.
 * @property meteredSize MeteredSize of the FileSystem.
 * @property protocolType The protocol type of the file system.
 * Valid values:
 * `NFS`,
 * `SMB` (Available when the `file_system_type` is `standard`).
 * @property regionId ID of the region where the FileSystem is located.
 * @property storageType The storage type of the file system.
 * * Valid values:
 * * `Performance` (Available when the `file_system_type` is `standard`)
 * * `Capacity` (Available when the `file_system_type` is `standard`)
 * @property zoneId (Optional, Available in v1.140.0+) The id of the zone. Each region consists of multiple isolated locations known as zones. Each zone has an independent power supply and network.
 */
public data class GetFileSystemsSystem(
    public val capacity: Int,
    public val createTime: String,
    public val description: String,
    public val encryptType: Int,
    public val fileSystemType: String,
    public val id: String,
    public val kmsKeyId: String,
    public val meteredSize: Int,
    public val protocolType: String,
    public val regionId: String,
    public val storageType: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetFileSystemsSystem): GetFileSystemsSystem = GetFileSystemsSystem(
            capacity = javaType.capacity(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            encryptType = javaType.encryptType(),
            fileSystemType = javaType.fileSystemType(),
            id = javaType.id(),
            kmsKeyId = javaType.kmsKeyId(),
            meteredSize = javaType.meteredSize(),
            protocolType = javaType.protocolType(),
            regionId = javaType.regionId(),
            storageType = javaType.storageType(),
            zoneId = javaType.zoneId(),
        )
    }
}
