@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The time when Fileset was created.
 * @property description Description of Fileset.
 * @property fileSystemId The ID of the file system.
 * @property fileSystemPath The path of Fileset.
 * @property filesetId The first ID of the resource.
 * @property id The ID of the Fileset.
 * @property status The status of the fileset.
 * @property updateTime The latest update time of Fileset.
 */
public data class GetFilesetsFileset(
    public val createTime: String,
    public val description: String,
    public val fileSystemId: String,
    public val fileSystemPath: String,
    public val filesetId: String,
    public val id: String,
    public val status: String,
    public val updateTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetFilesetsFileset): GetFilesetsFileset = GetFilesetsFileset(
            createTime = javaType.createTime(),
            description = javaType.description(),
            fileSystemId = javaType.fileSystemId(),
            fileSystemPath = javaType.fileSystemPath(),
            filesetId = javaType.filesetId(),
            id = javaType.id(),
            status = javaType.status(),
            updateTime = javaType.updateTime(),
        )
    }
}
