@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime The time when the lifecycle management policy was created.
 * @property fileSystemId The ID of the file system.
 * @property id The ID of the Lifecycle Policy. Its value is same as Queue Name.
 * @property lifecyclePolicyName The name of the lifecycle management policy.
 * @property lifecycleRuleName The rules in the lifecycle management policy.
 * @property paths The list of absolute paths for multiple directories. In this case, you can associate a lifecycle management policy with each directory.
 * @property storageType The storage type of the data that is dumped to the IA storage medium.
 */
public data class GetLifecyclePoliciesPolicy(
    public val createTime: String,
    public val fileSystemId: String,
    public val id: String,
    public val lifecyclePolicyName: String,
    public val lifecycleRuleName: String,
    public val paths: List<String>,
    public val storageType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetLifecyclePoliciesPolicy): GetLifecyclePoliciesPolicy = GetLifecyclePoliciesPolicy(
            createTime = javaType.createTime(),
            fileSystemId = javaType.fileSystemId(),
            id = javaType.id(),
            lifecyclePolicyName = javaType.lifecyclePolicyName(),
            lifecycleRuleName = javaType.lifecycleRuleName(),
            paths = javaType.paths().map({ args0 -> args0 }),
            storageType = javaType.storageType(),
        )
    }
}
