@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getLifecyclePolicies.
 * @property fileSystemId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property policies
 */
public data class GetLifecyclePoliciesResult(
    public val fileSystemId: String,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val policies: List<GetLifecyclePoliciesPolicy>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetLifecyclePoliciesResult): GetLifecyclePoliciesResult = GetLifecyclePoliciesResult(
            fileSystemId = javaType.fileSystemId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.nas.kotlin.outputs.GetLifecyclePoliciesPolicy.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
