@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMountTargets.
 * @property accessGroupName AccessGroup of The MountTarget.
 * @property fileSystemId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of MountTargetDomain.
 * @property mountTargetDomain MountTargetDomain of the MountTarget.
 * @property networkType (Available 1.95.0+) NetworkType of The MountTarget.
 * @property outputFile
 * @property status (Available 1.95.0+) The status of the mount target.
 * @property targets A list of MountTargetDomains. Each element contains the following attributes:
 * @property type Field `type` has been deprecated from provider version 1.95.0. New field `network_type` replaces it.
 * @property vpcId VpcId of The MountTarget.
 * @property vswitchId VSwitchId of The MountTarget.
 */
public data class GetMountTargetsResult(
    public val accessGroupName: String? = null,
    public val fileSystemId: String,
    public val id: String,
    public val ids: List<String>,
    @Deprecated(
        message = """
  Field 'mount_target_domain' has been deprecated from provider version 1.53.0. New field 'ids'
      replaces it.
  """,
    )
    public val mountTargetDomain: String? = null,
    public val networkType: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val targets: List<GetMountTargetsTarget>,
    @Deprecated(
        message = """
  Field 'type' has been deprecated from provider version 1.95.0. New field 'network_type' replaces
      it.
  """,
    )
    public val type: String? = null,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetMountTargetsResult): GetMountTargetsResult = GetMountTargetsResult(
            accessGroupName = javaType.accessGroupName().map({ args0 -> args0 }).orElse(null),
            fileSystemId = javaType.fileSystemId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            mountTargetDomain = javaType.mountTargetDomain().map({ args0 -> args0 }).orElse(null),
            networkType = javaType.networkType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            targets = javaType.targets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.nas.kotlin.outputs.GetMountTargetsTarget.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
