@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessGroupName Filter results by a specific AccessGroupName.
 * @property id ID of the MountTargetDomain.
 * @property mountTargetDomain Field `mount_target_domain` has been deprecated from provider version 1.53.0. New field `ids` replaces it.
 * @property networkType Filter results by a specific NetworkType.
 * @property status Filter results by the status of mount target. Valid values: `Active`, `Inactive` and `Pending`.
 * @property type Field `type` has been deprecated from provider version 1.95.0. New field `network_type` replaces it.
 * @property vpcId Filter results by a specific VpcId.
 * @property vswitchId Filter results by a specific VSwitchId.
 */
public data class GetMountTargetsTarget(
    public val accessGroupName: String,
    public val id: String,
    public val mountTargetDomain: String,
    public val networkType: String,
    public val status: String,
    public val type: String,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetMountTargetsTarget): GetMountTargetsTarget = GetMountTargetsTarget(
            accessGroupName = javaType.accessGroupName(),
            id = javaType.id(),
            mountTargetDomain = javaType.mountTargetDomain(),
            networkType = javaType.networkType(),
            status = javaType.status(),
            type = javaType.type(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
