@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProtocols.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property protocols A list of supported protocol type..
 * @property type
 * @property zoneId
 */
public data class GetProtocolsResult(
    public val id: String,
    public val outputFile: String? = null,
    public val protocols: List<String>,
    public val type: String,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetProtocolsResult): GetProtocolsResult = GetProtocolsResult(
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            protocols = javaType.protocols().map({ args0 -> args0 }),
            type = javaType.type(),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
