@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSnapshots.
 * @property fileSystemId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property snapshotName
 * @property snapshots
 * @property status
 */
public data class GetSnapshotsResult(
    public val fileSystemId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val snapshotName: String? = null,
    public val snapshots: List<GetSnapshotsSnapshot>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetSnapshotsResult): GetSnapshotsResult = GetSnapshotsResult(
            fileSystemId = javaType.fileSystemId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            snapshotName = javaType.snapshotName().map({ args0 -> args0 }).orElse(null),
            snapshots = javaType.snapshots().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.nas.kotlin.outputs.GetSnapshotsSnapshot.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
