@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The creation time of the resource.
 * @property description The description of the snapshot.
 * @property encryptType The type of the encryption.
 * @property id The ID of the Snapshot.
 * @property progress The progress of the snapshot creation. The value of this parameter is expressed as a percentage.
 * @property remainTime The remaining time that is required to create the snapshot. Unit: seconds.
 * @property retentionDays The retention period of the automatic snapshot. Unit: days.
 * @property snapshotId The ID of the resource.
 * @property snapshotName The name of the snapshot.
 * @property sourceFileSystemId The ID of the source file system.
 * @property sourceFileSystemSize The capacity of the source file system. Unit: GiB.
 * @property sourceFileSystemVersion The version of the source file system.
 * @property status The status of the snapshot.
 */
public data class GetSnapshotsSnapshot(
    public val createTime: String,
    public val description: String,
    public val encryptType: Int,
    public val id: String,
    public val progress: String,
    public val remainTime: Int,
    public val retentionDays: Int,
    public val snapshotId: String,
    public val snapshotName: String,
    public val sourceFileSystemId: String,
    public val sourceFileSystemSize: String,
    public val sourceFileSystemVersion: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetSnapshotsSnapshot): GetSnapshotsSnapshot = GetSnapshotsSnapshot(
            createTime = javaType.createTime(),
            description = javaType.description(),
            encryptType = javaType.encryptType(),
            id = javaType.id(),
            progress = javaType.progress(),
            remainTime = javaType.remainTime(),
            retentionDays = javaType.retentionDays(),
            snapshotId = javaType.snapshotId(),
            snapshotName = javaType.snapshotName(),
            sourceFileSystemId = javaType.sourceFileSystemId(),
            sourceFileSystemSize = javaType.sourceFileSystemSize(),
            sourceFileSystemVersion = javaType.sourceFileSystemVersion(),
            status = javaType.status(),
        )
    }
}
