@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property instanceTypes A list of instance type information collection
 * @property zoneId String to filter results by zone id.
 */
public data class GetZonesZone(
    public val instanceTypes: List<GetZonesZoneInstanceType>,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetZonesZone): GetZonesZone =
            GetZonesZone(
                instanceTypes = javaType.instanceTypes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.nas.kotlin.outputs.GetZonesZoneInstanceType.Companion.toKotlin(args0)
                    })
                }),
                zoneId = javaType.zoneId(),
            )
    }
}
