@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nas.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property protocolType File transfer protocol type. Valid values:
 * @property storageType The storage type of the nas zones. Valid values:
 */
public data class GetZonesZoneInstanceType(
    public val protocolType: String,
    public val storageType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.nas.outputs.GetZonesZoneInstanceType): GetZonesZoneInstanceType = GetZonesZoneInstanceType(
            protocolType = javaType.protocolType(),
            storageType = javaType.storageType(),
        )
    }
}
