@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ListenerAdditionalCertificateAttachment].
 */
@PulumiTagMarker
public class ListenerAdditionalCertificateAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ListenerAdditionalCertificateAttachmentArgs =
        ListenerAdditionalCertificateAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ListenerAdditionalCertificateAttachmentArgsBuilder.() -> Unit) {
        val builder = ListenerAdditionalCertificateAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ListenerAdditionalCertificateAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.nlb.ListenerAdditionalCertificateAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ListenerAdditionalCertificateAttachment(builtJavaResource)
    }
}

/**
 * Provides a NLB Listener Additional Certificate Attachment resource.
 * For information about NLB Listener Additional Certificate Attachment and how to use it, see [What is Listener Additional Certificate Attachment](https://www.alibabacloud.com/help/en/server-load-balancer/latest/nlb-instances-change).
 * > **NOTE:** Available since v1.209.0.
 * ## Import
 * NLB Listener Additional Certificate Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nlb/listenerAdditionalCertificateAttachment:ListenerAdditionalCertificateAttachment example <listener_id>:<certificate_id>
 * ```
 */
public class ListenerAdditionalCertificateAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.nlb.ListenerAdditionalCertificateAttachment,
) : KotlinCustomResource(javaResource, ListenerAdditionalCertificateAttachmentMapper) {
    /**
     * Certificate ID. Currently, only server certificates are supported.
     */
    public val certificateId: Output<String>
        get() = javaResource.certificateId().applyValue({ args0 -> args0 })

    /**
     * Whether to PreCheck only this request, value: - **true**: sends a check request and does not create a resource. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '. - **false** (default): Sends a normal request, returns the HTTP 2xx status code after the check, and directly performs the operation.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the tcpssl listener.
     */
    public val listenerId: Output<String>
        get() = javaResource.listenerId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ListenerAdditionalCertificateAttachmentMapper :
    ResourceMapper<ListenerAdditionalCertificateAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nlb.ListenerAdditionalCertificateAttachment::class == javaResource::class

    override fun map(javaResource: Resource): ListenerAdditionalCertificateAttachment =
        ListenerAdditionalCertificateAttachment(
            javaResource as
                com.pulumi.alicloud.nlb.ListenerAdditionalCertificateAttachment,
        )
}

/**
 * @see [ListenerAdditionalCertificateAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ListenerAdditionalCertificateAttachment].
 */
public suspend fun listenerAdditionalCertificateAttachment(
    name: String,
    block: suspend ListenerAdditionalCertificateAttachmentResourceBuilder.() -> Unit,
): ListenerAdditionalCertificateAttachment {
    val builder = ListenerAdditionalCertificateAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ListenerAdditionalCertificateAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun listenerAdditionalCertificateAttachment(name: String): ListenerAdditionalCertificateAttachment {
    val builder = ListenerAdditionalCertificateAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
