@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin

import com.pulumi.alicloud.nlb.ListenerAdditionalCertificateAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a NLB Listener Additional Certificate Attachment resource.
 * For information about NLB Listener Additional Certificate Attachment and how to use it, see [What is Listener Additional Certificate Attachment](https://www.alibabacloud.com/help/en/server-load-balancer/latest/nlb-instances-change).
 * > **NOTE:** Available since v1.209.0.
 * ## Import
 * NLB Listener Additional Certificate Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nlb/listenerAdditionalCertificateAttachment:ListenerAdditionalCertificateAttachment example <listener_id>:<certificate_id>
 * ```
 * @property certificateId Certificate ID. Currently, only server certificates are supported.
 * @property dryRun Whether to PreCheck only this request, value: - **true**: sends a check request and does not create a resource. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '. - **false** (default): Sends a normal request, returns the HTTP 2xx status code after the check, and directly performs the operation.
 * @property listenerId The ID of the tcpssl listener.
 */
public data class ListenerAdditionalCertificateAttachmentArgs(
    public val certificateId: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val listenerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.ListenerAdditionalCertificateAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.ListenerAdditionalCertificateAttachmentArgs =
        com.pulumi.alicloud.nlb.ListenerAdditionalCertificateAttachmentArgs.builder()
            .certificateId(certificateId?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .listenerId(listenerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerAdditionalCertificateAttachmentArgs].
 */
@PulumiTagMarker
public class ListenerAdditionalCertificateAttachmentArgsBuilder internal constructor() {
    private var certificateId: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var listenerId: Output<String>? = null

    /**
     * @param value Certificate ID. Currently, only server certificates are supported.
     */
    @JvmName("fevnmwbmrfxltarg")
    public suspend fun certificateId(`value`: Output<String>) {
        this.certificateId = value
    }

    /**
     * @param value Whether to PreCheck only this request, value: - **true**: sends a check request and does not create a resource. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '. - **false** (default): Sends a normal request, returns the HTTP 2xx status code after the check, and directly performs the operation.
     */
    @JvmName("xpoxgoxyqqqpkntb")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The ID of the tcpssl listener.
     */
    @JvmName("gyjetqskgkuvwnfq")
    public suspend fun listenerId(`value`: Output<String>) {
        this.listenerId = value
    }

    /**
     * @param value Certificate ID. Currently, only server certificates are supported.
     */
    @JvmName("tymrfqgtuiuraxiw")
    public suspend fun certificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateId = mapped
    }

    /**
     * @param value Whether to PreCheck only this request, value: - **true**: sends a check request and does not create a resource. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '. - **false** (default): Sends a normal request, returns the HTTP 2xx status code after the check, and directly performs the operation.
     */
    @JvmName("okskohpeouxklltp")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The ID of the tcpssl listener.
     */
    @JvmName("rrkpijtdhfhqqyic")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerId = mapped
    }

    internal fun build(): ListenerAdditionalCertificateAttachmentArgs =
        ListenerAdditionalCertificateAttachmentArgs(
            certificateId = certificateId,
            dryRun = dryRun,
            listenerId = listenerId,
        )
}
