@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin

import com.pulumi.alicloud.nlb.ListenerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a NLB Listener resource.
 * For information about NLB Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/server-load-balancer/latest/api-nlb-2022-04-30-createlistener).
 * > **NOTE:** Available since v1.191.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultGetZones = alicloud.nlb.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 * });
 * const default1 = new alicloud.vpc.Switch("default1", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.1.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[1]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultLoadBalancer = new alicloud.nlb.LoadBalancer("default", {
 *     loadBalancerName: name,
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     loadBalancerType: "Network",
 *     addressType: "Internet",
 *     addressIpVersion: "Ipv4",
 *     vpcId: defaultNetwork.id,
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 *     zoneMappings: [
 *         {
 *             vswitchId: defaultSwitch.id,
 *             zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 *         },
 *         {
 *             vswitchId: default1.id,
 *             zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[1]?.id),
 *         },
 *     ],
 * });
 * const defaultServerGroup = new alicloud.nlb.ServerGroup("default", {
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     serverGroupName: name,
 *     serverGroupType: "Instance",
 *     vpcId: defaultNetwork.id,
 *     scheduler: "Wrr",
 *     protocol: "TCP",
 *     connectionDrainEnabled: true,
 *     connectionDrainTimeout: 60,
 *     addressIpVersion: "Ipv4",
 *     healthCheck: {
 *         healthCheckEnabled: true,
 *         healthCheckType: "TCP",
 *         healthCheckConnectPort: 0,
 *         healthyThreshold: 2,
 *         unhealthyThreshold: 2,
 *         healthCheckConnectTimeout: 5,
 *         healthCheckInterval: 10,
 *         httpCheckMethod: "GET",
 *         healthCheckHttpCodes: [
 *             "http_2xx",
 *             "http_3xx",
 *             "http_4xx",
 *         ],
 *     },
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const defaultListener = new alicloud.nlb.Listener("default", {
 *     listenerProtocol: "TCP",
 *     listenerPort: 80,
 *     listenerDescription: name,
 *     loadBalancerId: defaultLoadBalancer.id,
 *     serverGroupId: defaultServerGroup.id,
 *     idleTimeout: 900,
 *     proxyProtocolEnabled: true,
 *     cps: 10000,
 *     mss: 0,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_get_zones = alicloud.nlb.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default_get_zones.zones[0].id)
 * default1 = alicloud.vpc.Switch("default1",
 *     vswitch_name=name,
 *     cidr_block="10.4.1.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default_get_zones.zones[1].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_load_balancer = alicloud.nlb.LoadBalancer("default",
 *     load_balancer_name=name,
 *     resource_group_id=default.ids[0],
 *     load_balancer_type="Network",
 *     address_type="Internet",
 *     address_ip_version="Ipv4",
 *     vpc_id=default_network.id,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     },
 *     zone_mappings=[
 *         {
 *             "vswitch_id": default_switch.id,
 *             "zone_id": default_get_zones.zones[0].id,
 *         },
 *         {
 *             "vswitch_id": default1.id,
 *             "zone_id": default_get_zones.zones[1].id,
 *         },
 *     ])
 * default_server_group = alicloud.nlb.ServerGroup("default",
 *     resource_group_id=default.ids[0],
 *     server_group_name=name,
 *     server_group_type="Instance",
 *     vpc_id=default_network.id,
 *     scheduler="Wrr",
 *     protocol="TCP",
 *     connection_drain_enabled=True,
 *     connection_drain_timeout=60,
 *     address_ip_version="Ipv4",
 *     health_check={
 *         "health_check_enabled": True,
 *         "health_check_type": "TCP",
 *         "health_check_connect_port": 0,
 *         "healthy_threshold": 2,
 *         "unhealthy_threshold": 2,
 *         "health_check_connect_timeout": 5,
 *         "health_check_interval": 10,
 *         "http_check_method": "GET",
 *         "health_check_http_codes": [
 *             "http_2xx",
 *             "http_3xx",
 *             "http_4xx",
 *         ],
 *     },
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * default_listener = alicloud.nlb.Listener("default",
 *     listener_protocol="TCP",
 *     listener_port=80,
 *     listener_description=name,
 *     load_balancer_id=default_load_balancer.id,
 *     server_group_id=default_server_group.id,
 *     idle_timeout=900,
 *     proxy_protocol_enabled=True,
 *     cps=10000,
 *     mss=0)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultGetZones = AliCloud.Nlb.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var default1 = new AliCloud.Vpc.Switch("default1", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.1.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[1]?.Id),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultLoadBalancer = new AliCloud.Nlb.LoadBalancer("default", new()
 *     {
 *         LoadBalancerName = name,
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         LoadBalancerType = "Network",
 *         AddressType = "Internet",
 *         AddressIpVersion = "Ipv4",
 *         VpcId = defaultNetwork.Id,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *         ZoneMappings = new[]
 *         {
 *             new AliCloud.Nlb.Inputs.LoadBalancerZoneMappingArgs
 *             {
 *                 VswitchId = defaultSwitch.Id,
 *                 ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *             },
 *             new AliCloud.Nlb.Inputs.LoadBalancerZoneMappingArgs
 *             {
 *                 VswitchId = default1.Id,
 *                 ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[1]?.Id),
 *             },
 *         },
 *     });
 *     var defaultServerGroup = new AliCloud.Nlb.ServerGroup("default", new()
 *     {
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         ServerGroupName = name,
 *         ServerGroupType = "Instance",
 *         VpcId = defaultNetwork.Id,
 *         Scheduler = "Wrr",
 *         Protocol = "TCP",
 *         ConnectionDrainEnabled = true,
 *         ConnectionDrainTimeout = 60,
 *         AddressIpVersion = "Ipv4",
 *         HealthCheck = new AliCloud.Nlb.Inputs.ServerGroupHealthCheckArgs
 *         {
 *             HealthCheckEnabled = true,
 *             HealthCheckType = "TCP",
 *             HealthCheckConnectPort = 0,
 *             HealthyThreshold = 2,
 *             UnhealthyThreshold = 2,
 *             HealthCheckConnectTimeout = 5,
 *             HealthCheckInterval = 10,
 *             HttpCheckMethod = "GET",
 *             HealthCheckHttpCodes = new[]
 *             {
 *                 "http_2xx",
 *                 "http_3xx",
 *                 "http_4xx",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var defaultListener = new AliCloud.Nlb.Listener("default", new()
 *     {
 *         ListenerProtocol = "TCP",
 *         ListenerPort = 80,
 *         ListenerDescription = name,
 *         LoadBalancerId = defaultLoadBalancer.Id,
 *         ServerGroupId = defaultServerGroup.Id,
 *         IdleTimeout = 900,
 *         ProxyProtocolEnabled = true,
 *         Cps = 10000,
 *         Mss = 0,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := nlb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(defaultGetZones.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default1, err := vpc.NewSwitch(ctx, "default1", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.1.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(defaultGetZones.Zones[1].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultLoadBalancer, err := nlb.NewLoadBalancer(ctx, "default", &nlb.LoadBalancerArgs{
 * 			LoadBalancerName: pulumi.String(name),
 * 			ResourceGroupId:  pulumi.String(_default.Ids[0]),
 * 			LoadBalancerType: pulumi.String("Network"),
 * 			AddressType:      pulumi.String("Internet"),
 * 			AddressIpVersion: pulumi.String("Ipv4"),
 * 			VpcId:            defaultNetwork.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 			ZoneMappings: nlb.LoadBalancerZoneMappingArray{
 * 				&nlb.LoadBalancerZoneMappingArgs{
 * 					VswitchId: defaultSwitch.ID(),
 * 					ZoneId:    pulumi.String(defaultGetZones.Zones[0].Id),
 * 				},
 * 				&nlb.LoadBalancerZoneMappingArgs{
 * 					VswitchId: default1.ID(),
 * 					ZoneId:    pulumi.String(defaultGetZones.Zones[1].Id),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultServerGroup, err := nlb.NewServerGroup(ctx, "default", &nlb.ServerGroupArgs{
 * 			ResourceGroupId:        pulumi.String(_default.Ids[0]),
 * 			ServerGroupName:        pulumi.String(name),
 * 			ServerGroupType:        pulumi.String("Instance"),
 * 			VpcId:                  defaultNetwork.ID(),
 * 			Scheduler:              pulumi.String("Wrr"),
 * 			Protocol:               pulumi.String("TCP"),
 * 			ConnectionDrainEnabled: pulumi.Bool(true),
 * 			ConnectionDrainTimeout: pulumi.Int(60),
 * 			AddressIpVersion:       pulumi.String("Ipv4"),
 * 			HealthCheck: &nlb.ServerGroupHealthCheckArgs{
 * 				HealthCheckEnabled:        pulumi.Bool(true),
 * 				HealthCheckType:           pulumi.String("TCP"),
 * 				HealthCheckConnectPort:    pulumi.Int(0),
 * 				HealthyThreshold:          pulumi.Int(2),
 * 				UnhealthyThreshold:        pulumi.Int(2),
 * 				HealthCheckConnectTimeout: pulumi.Int(5),
 * 				HealthCheckInterval:       pulumi.Int(10),
 * 				HttpCheckMethod:           pulumi.String("GET"),
 * 				HealthCheckHttpCodes: pulumi.StringArray{
 * 					pulumi.String("http_2xx"),
 * 					pulumi.String("http_3xx"),
 * 					pulumi.String("http_4xx"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nlb.NewListener(ctx, "default", &nlb.ListenerArgs{
 * 			ListenerProtocol:     pulumi.String("TCP"),
 * 			ListenerPort:         pulumi.Int(80),
 * 			ListenerDescription:  pulumi.String(name),
 * 			LoadBalancerId:       defaultLoadBalancer.ID(),
 * 			ServerGroupId:        defaultServerGroup.ID(),
 * 			IdleTimeout:          pulumi.Int(900),
 * 			ProxyProtocolEnabled: pulumi.Bool(true),
 * 			Cps:                  pulumi.Int(10000),
 * 			Mss:                  pulumi.Int(0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.nlb.NlbFunctions;
 * import com.pulumi.alicloud.nlb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.nlb.LoadBalancer;
 * import com.pulumi.alicloud.nlb.LoadBalancerArgs;
 * import com.pulumi.alicloud.nlb.inputs.LoadBalancerZoneMappingArgs;
 * import com.pulumi.alicloud.nlb.ServerGroup;
 * import com.pulumi.alicloud.nlb.ServerGroupArgs;
 * import com.pulumi.alicloud.nlb.inputs.ServerGroupHealthCheckArgs;
 * import com.pulumi.alicloud.nlb.Listener;
 * import com.pulumi.alicloud.nlb.ListenerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         final var defaultGetZones = NlbFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var default1 = new Switch("default1", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.1.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[1].id()))
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultLoadBalancer = new LoadBalancer("defaultLoadBalancer", LoadBalancerArgs.builder()
 *             .loadBalancerName(name)
 *             .resourceGroupId(default_.ids()[0])
 *             .loadBalancerType("Network")
 *             .addressType("Internet")
 *             .addressIpVersion("Ipv4")
 *             .vpcId(defaultNetwork.id())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .zoneMappings(
 *                 LoadBalancerZoneMappingArgs.builder()
 *                     .vswitchId(defaultSwitch.id())
 *                     .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *                     .build(),
 *                 LoadBalancerZoneMappingArgs.builder()
 *                     .vswitchId(default1.id())
 *                     .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[1].id()))
 *                     .build())
 *             .build());
 *         var defaultServerGroup = new ServerGroup("defaultServerGroup", ServerGroupArgs.builder()
 *             .resourceGroupId(default_.ids()[0])
 *             .serverGroupName(name)
 *             .serverGroupType("Instance")
 *             .vpcId(defaultNetwork.id())
 *             .scheduler("Wrr")
 *             .protocol("TCP")
 *             .connectionDrainEnabled(true)
 *             .connectionDrainTimeout(60)
 *             .addressIpVersion("Ipv4")
 *             .healthCheck(ServerGroupHealthCheckArgs.builder()
 *                 .healthCheckEnabled(true)
 *                 .healthCheckType("TCP")
 *                 .healthCheckConnectPort(0)
 *                 .healthyThreshold(2)
 *                 .unhealthyThreshold(2)
 *                 .healthCheckConnectTimeout(5)
 *                 .healthCheckInterval(10)
 *                 .httpCheckMethod("GET")
 *                 .healthCheckHttpCodes(
 *                     "http_2xx",
 *                     "http_3xx",
 *                     "http_4xx")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var defaultListener = new Listener("defaultListener", ListenerArgs.builder()
 *             .listenerProtocol("TCP")
 *             .listenerPort("80")
 *             .listenerDescription(name)
 *             .loadBalancerId(defaultLoadBalancer.id())
 *             .serverGroupId(defaultServerGroup.id())
 *             .idleTimeout("900")
 *             .proxyProtocolEnabled("true")
 *             .cps("10000")
 *             .mss("0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${defaultGetZones.zones[0].id}
 *   default1:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.1.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${defaultGetZones.zones[1].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 *   defaultLoadBalancer:
 *     type: alicloud:nlb:LoadBalancer
 *     name: default
 *     properties:
 *       loadBalancerName: ${name}
 *       resourceGroupId: ${default.ids[0]}
 *       loadBalancerType: Network
 *       addressType: Internet
 *       addressIpVersion: Ipv4
 *       vpcId: ${defaultNetwork.id}
 *       tags:
 *         Created: TF
 *         For: example
 *       zoneMappings:
 *         - vswitchId: ${defaultSwitch.id}
 *           zoneId: ${defaultGetZones.zones[0].id}
 *         - vswitchId: ${default1.id}
 *           zoneId: ${defaultGetZones.zones[1].id}
 *   defaultServerGroup:
 *     type: alicloud:nlb:ServerGroup
 *     name: default
 *     properties:
 *       resourceGroupId: ${default.ids[0]}
 *       serverGroupName: ${name}
 *       serverGroupType: Instance
 *       vpcId: ${defaultNetwork.id}
 *       scheduler: Wrr
 *       protocol: TCP
 *       connectionDrainEnabled: true
 *       connectionDrainTimeout: 60
 *       addressIpVersion: Ipv4
 *       healthCheck:
 *         healthCheckEnabled: true
 *         healthCheckType: TCP
 *         healthCheckConnectPort: 0
 *         healthyThreshold: 2
 *         unhealthyThreshold: 2
 *         healthCheckConnectTimeout: 5
 *         healthCheckInterval: 10
 *         httpCheckMethod: GET
 *         healthCheckHttpCodes:
 *           - http_2xx
 *           - http_3xx
 *           - http_4xx
 *       tags:
 *         Created: TF
 *         For: example
 *   defaultListener:
 *     type: alicloud:nlb:Listener
 *     name: default
 *     properties:
 *       listenerProtocol: TCP
 *       listenerPort: '80'
 *       listenerDescription: ${name}
 *       loadBalancerId: ${defaultLoadBalancer.id}
 *       serverGroupId: ${defaultServerGroup.id}
 *       idleTimeout: '900'
 *       proxyProtocolEnabled: 'true'
 *       cps: '10000'
 *       mss: '0'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:nlb:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NLB Listener can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nlb/listener:Listener example <id>
 * ```
 * @property alpnEnabled Whether ALPN is turned on. Value:
 * - **true**: on.
 * - **false**: closed.
 * @property alpnPolicy ALPN policy. Value:
 * - **HTTP1Only**
 * - **HTTP2Only**
 * - **HTTP2Preferred**
 * - **HTTP2Optional**.
 * @property caCertificateIds CA certificate list information. Currently, only one CA certificate can be added.
 * > **NOTE:**  This parameter only takes effect for TCPSSL listeners.
 * @property caEnabled Whether to start two-way authentication. Value:
 * - **true**: start.
 * - **false**: closed.
 * @property certificateIds Server certificate list information. Currently, only one server certificate can be added.
 * > **NOTE:**  This parameter only takes effect for TCPSSL listeners.
 * @property cps The new connection speed limit for a network-based load balancing instance per second. Valid values: **0** ~ **1000000**. **0** indicates unlimited speed.
 * @property endPort Full port listening end port. Valid values: **0** ~ **65535 * *. The value of the end port is less than the start port.
 * @property idleTimeout Connection idle timeout time. Unit: seconds. Valid values: **1** ~ **900**.
 * @property listenerDescription Custom listener name.The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
 * @property listenerPort Listening port. Valid values: **0** ~ **65535 * *. **0**: indicates that full port listening is used. When set to **0**, you must configure **StartPort** and **EndPort**.
 * @property listenerProtocol The listening protocol. Valid values: **TCP**, **UDP**, or **TCPSSL**.
 * @property loadBalancerId The ID of the network-based server load balancer instance.
 * @property mss The maximum segment size of the TCP message. Unit: Bytes. Valid values: **0** ~ **1500**. **0** indicates that the MSS value of the TCP message is not modified.
 * > **NOTE:**  only TCP and TCPSSL listeners support this field value.
 * @property proxyProtocolEnabled Whether to enable the Proxy Protocol to carry the source address of the client to the backend server. Value:
 * - **true**: on.
 * - **false**: closed.
 * @property secSensorEnabled Whether to turn on the second-level monitoring function. Value:
 * - **true**: on.
 * - **false**: closed.
 * @property securityPolicyId Security policy ID. Support system security policies and custom security policies. Valid values: **tls_cipher_policy_1_0**, **tls_cipher_policy_1_1**, **tls_cipher_policy_1_2**, **tls_cipher_policy_1_2_strict**, or **tls_cipher_policy_1_2_strict_with_1_3**.
 * > **NOTE:**  This parameter only takes effect for TCPSSL listeners.
 * @property serverGroupId The ID of the server group.
 * @property startPort Full Port listens to the starting port. Valid values: **0** ~ **65535**.
 * @property status The status of the resource.
 * @property tags The tag of the resource.
 */
public data class ListenerArgs(
    public val alpnEnabled: Output<Boolean>? = null,
    public val alpnPolicy: Output<String>? = null,
    public val caCertificateIds: Output<List<String>>? = null,
    public val caEnabled: Output<Boolean>? = null,
    public val certificateIds: Output<List<String>>? = null,
    public val cps: Output<Int>? = null,
    public val endPort: Output<Int>? = null,
    public val idleTimeout: Output<Int>? = null,
    public val listenerDescription: Output<String>? = null,
    public val listenerPort: Output<Int>? = null,
    public val listenerProtocol: Output<String>? = null,
    public val loadBalancerId: Output<String>? = null,
    public val mss: Output<Int>? = null,
    public val proxyProtocolEnabled: Output<Boolean>? = null,
    public val secSensorEnabled: Output<Boolean>? = null,
    public val securityPolicyId: Output<String>? = null,
    public val serverGroupId: Output<String>? = null,
    public val startPort: Output<Int>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.ListenerArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.ListenerArgs =
        com.pulumi.alicloud.nlb.ListenerArgs.builder()
            .alpnEnabled(alpnEnabled?.applyValue({ args0 -> args0 }))
            .alpnPolicy(alpnPolicy?.applyValue({ args0 -> args0 }))
            .caCertificateIds(caCertificateIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .caEnabled(caEnabled?.applyValue({ args0 -> args0 }))
            .certificateIds(certificateIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cps(cps?.applyValue({ args0 -> args0 }))
            .endPort(endPort?.applyValue({ args0 -> args0 }))
            .idleTimeout(idleTimeout?.applyValue({ args0 -> args0 }))
            .listenerDescription(listenerDescription?.applyValue({ args0 -> args0 }))
            .listenerPort(listenerPort?.applyValue({ args0 -> args0 }))
            .listenerProtocol(listenerProtocol?.applyValue({ args0 -> args0 }))
            .loadBalancerId(loadBalancerId?.applyValue({ args0 -> args0 }))
            .mss(mss?.applyValue({ args0 -> args0 }))
            .proxyProtocolEnabled(proxyProtocolEnabled?.applyValue({ args0 -> args0 }))
            .secSensorEnabled(secSensorEnabled?.applyValue({ args0 -> args0 }))
            .securityPolicyId(securityPolicyId?.applyValue({ args0 -> args0 }))
            .serverGroupId(serverGroupId?.applyValue({ args0 -> args0 }))
            .startPort(startPort?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ListenerArgs].
 */
@PulumiTagMarker
public class ListenerArgsBuilder internal constructor() {
    private var alpnEnabled: Output<Boolean>? = null

    private var alpnPolicy: Output<String>? = null

    private var caCertificateIds: Output<List<String>>? = null

    private var caEnabled: Output<Boolean>? = null

    private var certificateIds: Output<List<String>>? = null

    private var cps: Output<Int>? = null

    private var endPort: Output<Int>? = null

    private var idleTimeout: Output<Int>? = null

    private var listenerDescription: Output<String>? = null

    private var listenerPort: Output<Int>? = null

    private var listenerProtocol: Output<String>? = null

    private var loadBalancerId: Output<String>? = null

    private var mss: Output<Int>? = null

    private var proxyProtocolEnabled: Output<Boolean>? = null

    private var secSensorEnabled: Output<Boolean>? = null

    private var securityPolicyId: Output<String>? = null

    private var serverGroupId: Output<String>? = null

    private var startPort: Output<Int>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Whether ALPN is turned on. Value:
     * - **true**: on.
     * - **false**: closed.
     */
    @JvmName("avunwhilpsdtxepx")
    public suspend fun alpnEnabled(`value`: Output<Boolean>) {
        this.alpnEnabled = value
    }

    /**
     * @param value ALPN policy. Value:
     * - **HTTP1Only**
     * - **HTTP2Only**
     * - **HTTP2Preferred**
     * - **HTTP2Optional**.
     */
    @JvmName("lfrbmqsixqaefana")
    public suspend fun alpnPolicy(`value`: Output<String>) {
        this.alpnPolicy = value
    }

    /**
     * @param value CA certificate list information. Currently, only one CA certificate can be added.
     * > **NOTE:**  This parameter only takes effect for TCPSSL listeners.
     */
    @JvmName("nicewqedkhiibadt")
    public suspend fun caCertificateIds(`value`: Output<List<String>>) {
        this.caCertificateIds = value
    }

    @JvmName("cavkkgiiowqudeek")
    public suspend fun caCertificateIds(vararg values: Output<String>) {
        this.caCertificateIds = Output.all(values.asList())
    }

    /**
     * @param values CA certificate list information. Currently, only one CA certificate can be added.
     * > **NOTE:**  This parameter only takes effect for TCPSSL listeners.
     */
    @JvmName("vosbqcgjkavhnobd")
    public suspend fun caCertificateIds(values: List<Output<String>>) {
        this.caCertificateIds = Output.all(values)
    }

    /**
     * @param value Whether to start two-way authentication. Value:
     * - **true**: start.
     * - **false**: closed.
     */
    @JvmName("pxxbgddokjgfkcou")
    public suspend fun caEnabled(`value`: Output<Boolean>) {
        this.caEnabled = value
    }

    /**
     * @param value Server certificate list information. Currently, only one server certificate can be added.
     * > **NOTE:**  This parameter only takes effect for TCPSSL listeners.
     */
    @JvmName("uqqndqyvhbfyrrdg")
    public suspend fun certificateIds(`value`: Output<List<String>>) {
        this.certificateIds = value
    }

    @JvmName("urcpkkrdjbvynlxy")
    public suspend fun certificateIds(vararg values: Output<String>) {
        this.certificateIds = Output.all(values.asList())
    }

    /**
     * @param values Server certificate list information. Currently, only one server certificate can be added.
     * > **NOTE:**  This parameter only takes effect for TCPSSL listeners.
     */
    @JvmName("lcgdmifrwhqkpakx")
    public suspend fun certificateIds(values: List<Output<String>>) {
        this.certificateIds = Output.all(values)
    }

    /**
     * @param value The new connection speed limit for a network-based load balancing instance per second. Valid values: **0** ~ **1000000**. **0** indicates unlimited speed.
     */
    @JvmName("skqjdheircmqicmm")
    public suspend fun cps(`value`: Output<Int>) {
        this.cps = value
    }

    /**
     * @param value Full port listening end port. Valid values: **0** ~ **65535 * *. The value of the end port is less than the start port.
     */
    @JvmName("uuguaxrvjwpkpwhs")
    public suspend fun endPort(`value`: Output<Int>) {
        this.endPort = value
    }

    /**
     * @param value Connection idle timeout time. Unit: seconds. Valid values: **1** ~ **900**.
     */
    @JvmName("hjmyintsgkahsjda")
    public suspend fun idleTimeout(`value`: Output<Int>) {
        this.idleTimeout = value
    }

    /**
     * @param value Custom listener name.The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
     */
    @JvmName("vfrxqhetcbhkiwpx")
    public suspend fun listenerDescription(`value`: Output<String>) {
        this.listenerDescription = value
    }

    /**
     * @param value Listening port. Valid values: **0** ~ **65535 * *. **0**: indicates that full port listening is used. When set to **0**, you must configure **StartPort** and **EndPort**.
     */
    @JvmName("wigwpmdpuwcrswis")
    public suspend fun listenerPort(`value`: Output<Int>) {
        this.listenerPort = value
    }

    /**
     * @param value The listening protocol. Valid values: **TCP**, **UDP**, or **TCPSSL**.
     */
    @JvmName("tttquwbyrupwjqhp")
    public suspend fun listenerProtocol(`value`: Output<String>) {
        this.listenerProtocol = value
    }

    /**
     * @param value The ID of the network-based server load balancer instance.
     */
    @JvmName("lhtxftmrdjxieclh")
    public suspend fun loadBalancerId(`value`: Output<String>) {
        this.loadBalancerId = value
    }

    /**
     * @param value The maximum segment size of the TCP message. Unit: Bytes. Valid values: **0** ~ **1500**. **0** indicates that the MSS value of the TCP message is not modified.
     * > **NOTE:**  only TCP and TCPSSL listeners support this field value.
     */
    @JvmName("wlkbyyxwhvhoeyyp")
    public suspend fun mss(`value`: Output<Int>) {
        this.mss = value
    }

    /**
     * @param value Whether to enable the Proxy Protocol to carry the source address of the client to the backend server. Value:
     * - **true**: on.
     * - **false**: closed.
     */
    @JvmName("jldatwrkvgycxmcq")
    public suspend fun proxyProtocolEnabled(`value`: Output<Boolean>) {
        this.proxyProtocolEnabled = value
    }

    /**
     * @param value Whether to turn on the second-level monitoring function. Value:
     * - **true**: on.
     * - **false**: closed.
     */
    @JvmName("cacesghpkjrvjoax")
    public suspend fun secSensorEnabled(`value`: Output<Boolean>) {
        this.secSensorEnabled = value
    }

    /**
     * @param value Security policy ID. Support system security policies and custom security policies. Valid values: **tls_cipher_policy_1_0**, **tls_cipher_policy_1_1**, **tls_cipher_policy_1_2**, **tls_cipher_policy_1_2_strict**, or **tls_cipher_policy_1_2_strict_with_1_3**.
     * > **NOTE:**  This parameter only takes effect for TCPSSL listeners.
     */
    @JvmName("pwswidmwttceasrj")
    public suspend fun securityPolicyId(`value`: Output<String>) {
        this.securityPolicyId = value
    }

    /**
     * @param value The ID of the server group.
     */
    @JvmName("xgsxcxtcrkkrohnj")
    public suspend fun serverGroupId(`value`: Output<String>) {
        this.serverGroupId = value
    }

    /**
     * @param value Full Port listens to the starting port. Valid values: **0** ~ **65535**.
     */
    @JvmName("eagnmctahtitgyum")
    public suspend fun startPort(`value`: Output<Int>) {
        this.startPort = value
    }

    /**
     * @param value The status of the resource.
     */
    @JvmName("tamrtpmaftmbbqut")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("olvuuhhrganmanru")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether ALPN is turned on. Value:
     * - **true**: on.
     * - **false**: closed.
     */
    @JvmName("thxkcvhsjkxkqiks")
    public suspend fun alpnEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alpnEnabled = mapped
    }

    /**
     * @param value ALPN policy. Value:
     * - **HTTP1Only**
     * - **HTTP2Only**
     * - **HTTP2Preferred**
     * - **HTTP2Optional**.
     */
    @JvmName("erphklbgvtjiuwtb")
    public suspend fun alpnPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alpnPolicy = mapped
    }

    /**
     * @param value CA certificate list information. Currently, only one CA certificate can be added.
     * > **NOTE:**  This parameter only takes effect for TCPSSL listeners.
     */
    @JvmName("kcxbrpothwbxmltl")
    public suspend fun caCertificateIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertificateIds = mapped
    }

    /**
     * @param values CA certificate list information. Currently, only one CA certificate can be added.
     * > **NOTE:**  This parameter only takes effect for TCPSSL listeners.
     */
    @JvmName("fnvkyygakasomkhs")
    public suspend fun caCertificateIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.caCertificateIds = mapped
    }

    /**
     * @param value Whether to start two-way authentication. Value:
     * - **true**: start.
     * - **false**: closed.
     */
    @JvmName("tmwftchdhwmarmaa")
    public suspend fun caEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caEnabled = mapped
    }

    /**
     * @param value Server certificate list information. Currently, only one server certificate can be added.
     * > **NOTE:**  This parameter only takes effect for TCPSSL listeners.
     */
    @JvmName("nptlajvlmwasaelj")
    public suspend fun certificateIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateIds = mapped
    }

    /**
     * @param values Server certificate list information. Currently, only one server certificate can be added.
     * > **NOTE:**  This parameter only takes effect for TCPSSL listeners.
     */
    @JvmName("gcaqcqkbvsyjtvny")
    public suspend fun certificateIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateIds = mapped
    }

    /**
     * @param value The new connection speed limit for a network-based load balancing instance per second. Valid values: **0** ~ **1000000**. **0** indicates unlimited speed.
     */
    @JvmName("wqqsrmrkoubuahmy")
    public suspend fun cps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cps = mapped
    }

    /**
     * @param value Full port listening end port. Valid values: **0** ~ **65535 * *. The value of the end port is less than the start port.
     */
    @JvmName("blygqerpjdavllyq")
    public suspend fun endPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endPort = mapped
    }

    /**
     * @param value Connection idle timeout time. Unit: seconds. Valid values: **1** ~ **900**.
     */
    @JvmName("ipugfuehufbljgnq")
    public suspend fun idleTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeout = mapped
    }

    /**
     * @param value Custom listener name.The length is limited to 2 to 256 characters, supports Chinese and English letters, and can include numbers, commas (,), half-width periods (.), half-width semicolons (;), forward slashes (/), at(@), underscores (_), and dashes (-).
     */
    @JvmName("gqfqacdiwkjojxld")
    public suspend fun listenerDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerDescription = mapped
    }

    /**
     * @param value Listening port. Valid values: **0** ~ **65535 * *. **0**: indicates that full port listening is used. When set to **0**, you must configure **StartPort** and **EndPort**.
     */
    @JvmName("ejybagvekhvxhmqe")
    public suspend fun listenerPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerPort = mapped
    }

    /**
     * @param value The listening protocol. Valid values: **TCP**, **UDP**, or **TCPSSL**.
     */
    @JvmName("llgjobttjhhbwvkv")
    public suspend fun listenerProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerProtocol = mapped
    }

    /**
     * @param value The ID of the network-based server load balancer instance.
     */
    @JvmName("hhsgvyhqxgarxuhw")
    public suspend fun loadBalancerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerId = mapped
    }

    /**
     * @param value The maximum segment size of the TCP message. Unit: Bytes. Valid values: **0** ~ **1500**. **0** indicates that the MSS value of the TCP message is not modified.
     * > **NOTE:**  only TCP and TCPSSL listeners support this field value.
     */
    @JvmName("yovtmcsxdhytswpe")
    public suspend fun mss(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mss = mapped
    }

    /**
     * @param value Whether to enable the Proxy Protocol to carry the source address of the client to the backend server. Value:
     * - **true**: on.
     * - **false**: closed.
     */
    @JvmName("hjshoqwjxyepvpcp")
    public suspend fun proxyProtocolEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyProtocolEnabled = mapped
    }

    /**
     * @param value Whether to turn on the second-level monitoring function. Value:
     * - **true**: on.
     * - **false**: closed.
     */
    @JvmName("kinuofdqrtyqeonp")
    public suspend fun secSensorEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secSensorEnabled = mapped
    }

    /**
     * @param value Security policy ID. Support system security policies and custom security policies. Valid values: **tls_cipher_policy_1_0**, **tls_cipher_policy_1_1**, **tls_cipher_policy_1_2**, **tls_cipher_policy_1_2_strict**, or **tls_cipher_policy_1_2_strict_with_1_3**.
     * > **NOTE:**  This parameter only takes effect for TCPSSL listeners.
     */
    @JvmName("nncrqahpryjbynsw")
    public suspend fun securityPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityPolicyId = mapped
    }

    /**
     * @param value The ID of the server group.
     */
    @JvmName("wruhusucatcarfij")
    public suspend fun serverGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverGroupId = mapped
    }

    /**
     * @param value Full Port listens to the starting port. Valid values: **0** ~ **65535**.
     */
    @JvmName("mvajobefuwiowqpo")
    public suspend fun startPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startPort = mapped
    }

    /**
     * @param value The status of the resource.
     */
    @JvmName("hknvgcdvplgmdihh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("rjuyurglxxinqtjv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("wohrbrlucsjpxdkr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ListenerArgs = ListenerArgs(
        alpnEnabled = alpnEnabled,
        alpnPolicy = alpnPolicy,
        caCertificateIds = caCertificateIds,
        caEnabled = caEnabled,
        certificateIds = certificateIds,
        cps = cps,
        endPort = endPort,
        idleTimeout = idleTimeout,
        listenerDescription = listenerDescription,
        listenerPort = listenerPort,
        listenerProtocol = listenerProtocol,
        loadBalancerId = loadBalancerId,
        mss = mss,
        proxyProtocolEnabled = proxyProtocolEnabled,
        secSensorEnabled = secSensorEnabled,
        securityPolicyId = securityPolicyId,
        serverGroupId = serverGroupId,
        startPort = startPort,
        status = status,
        tags = tags,
    )
}
