@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin

import com.pulumi.alicloud.nlb.kotlin.outputs.LoadBalancerDeletionProtectionConfig
import com.pulumi.alicloud.nlb.kotlin.outputs.LoadBalancerModificationProtectionConfig
import com.pulumi.alicloud.nlb.kotlin.outputs.LoadBalancerZoneMapping
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.nlb.kotlin.outputs.LoadBalancerDeletionProtectionConfig.Companion.toKotlin as loadBalancerDeletionProtectionConfigToKotlin
import com.pulumi.alicloud.nlb.kotlin.outputs.LoadBalancerModificationProtectionConfig.Companion.toKotlin as loadBalancerModificationProtectionConfigToKotlin
import com.pulumi.alicloud.nlb.kotlin.outputs.LoadBalancerZoneMapping.Companion.toKotlin as loadBalancerZoneMappingToKotlin

/**
 * Builder for [LoadBalancer].
 */
@PulumiTagMarker
public class LoadBalancerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadBalancerArgs = LoadBalancerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadBalancerArgsBuilder.() -> Unit) {
        val builder = LoadBalancerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoadBalancer {
        val builtJavaResource = com.pulumi.alicloud.nlb.LoadBalancer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LoadBalancer(builtJavaResource)
    }
}

/**
 * Provides a NLB Load Balancer resource.
 * For information about NLB Load Balancer and how to use it, see [What is Load Balancer](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer).
 * > **NOTE:** Available since v1.191.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultGetZones = alicloud.nlb.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 * });
 * const default1 = new alicloud.vpc.Switch("default1", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.1.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[1]?.id),
 * });
 * const defaultLoadBalancer = new alicloud.nlb.LoadBalancer("default", {
 *     loadBalancerName: name,
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     loadBalancerType: "Network",
 *     addressType: "Internet",
 *     addressIpVersion: "Ipv4",
 *     vpcId: defaultNetwork.id,
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 *     zoneMappings: [
 *         {
 *             vswitchId: defaultSwitch.id,
 *             zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 *         },
 *         {
 *             vswitchId: default1.id,
 *             zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[1]?.id),
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_get_zones = alicloud.nlb.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default_get_zones.zones[0].id)
 * default1 = alicloud.vpc.Switch("default1",
 *     vswitch_name=name,
 *     cidr_block="10.4.1.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default_get_zones.zones[1].id)
 * default_load_balancer = alicloud.nlb.LoadBalancer("default",
 *     load_balancer_name=name,
 *     resource_group_id=default.ids[0],
 *     load_balancer_type="Network",
 *     address_type="Internet",
 *     address_ip_version="Ipv4",
 *     vpc_id=default_network.id,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     },
 *     zone_mappings=[
 *         {
 *             "vswitch_id": default_switch.id,
 *             "zone_id": default_get_zones.zones[0].id,
 *         },
 *         {
 *             "vswitch_id": default1.id,
 *             "zone_id": default_get_zones.zones[1].id,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultGetZones = AliCloud.Nlb.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var default1 = new AliCloud.Vpc.Switch("default1", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.1.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[1]?.Id),
 *     });
 *     var defaultLoadBalancer = new AliCloud.Nlb.LoadBalancer("default", new()
 *     {
 *         LoadBalancerName = name,
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         LoadBalancerType = "Network",
 *         AddressType = "Internet",
 *         AddressIpVersion = "Ipv4",
 *         VpcId = defaultNetwork.Id,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *         ZoneMappings = new[]
 *         {
 *             new AliCloud.Nlb.Inputs.LoadBalancerZoneMappingArgs
 *             {
 *                 VswitchId = defaultSwitch.Id,
 *                 ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *             },
 *             new AliCloud.Nlb.Inputs.LoadBalancerZoneMappingArgs
 *             {
 *                 VswitchId = default1.Id,
 *                 ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[1]?.Id),
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := nlb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(defaultGetZones.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default1, err := vpc.NewSwitch(ctx, "default1", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.1.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(defaultGetZones.Zones[1].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nlb.NewLoadBalancer(ctx, "default", &nlb.LoadBalancerArgs{
 * 			LoadBalancerName: pulumi.String(name),
 * 			ResourceGroupId:  pulumi.String(_default.Ids[0]),
 * 			LoadBalancerType: pulumi.String("Network"),
 * 			AddressType:      pulumi.String("Internet"),
 * 			AddressIpVersion: pulumi.String("Ipv4"),
 * 			VpcId:            defaultNetwork.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 			ZoneMappings: nlb.LoadBalancerZoneMappingArray{
 * 				&nlb.LoadBalancerZoneMappingArgs{
 * 					VswitchId: defaultSwitch.ID(),
 * 					ZoneId:    pulumi.String(defaultGetZones.Zones[0].Id),
 * 				},
 * 				&nlb.LoadBalancerZoneMappingArgs{
 * 					VswitchId: default1.ID(),
 * 					ZoneId:    pulumi.String(defaultGetZones.Zones[1].Id),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.nlb.NlbFunctions;
 * import com.pulumi.alicloud.nlb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.nlb.LoadBalancer;
 * import com.pulumi.alicloud.nlb.LoadBalancerArgs;
 * import com.pulumi.alicloud.nlb.inputs.LoadBalancerZoneMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         final var defaultGetZones = NlbFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var default1 = new Switch("default1", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.1.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[1].id()))
 *             .build());
 *         var defaultLoadBalancer = new LoadBalancer("defaultLoadBalancer", LoadBalancerArgs.builder()
 *             .loadBalancerName(name)
 *             .resourceGroupId(default_.ids()[0])
 *             .loadBalancerType("Network")
 *             .addressType("Internet")
 *             .addressIpVersion("Ipv4")
 *             .vpcId(defaultNetwork.id())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .zoneMappings(
 *                 LoadBalancerZoneMappingArgs.builder()
 *                     .vswitchId(defaultSwitch.id())
 *                     .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *                     .build(),
 *                 LoadBalancerZoneMappingArgs.builder()
 *                     .vswitchId(default1.id())
 *                     .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[1].id()))
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${defaultGetZones.zones[0].id}
 *   default1:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.1.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${defaultGetZones.zones[1].id}
 *   defaultLoadBalancer:
 *     type: alicloud:nlb:LoadBalancer
 *     name: default
 *     properties:
 *       loadBalancerName: ${name}
 *       resourceGroupId: ${default.ids[0]}
 *       loadBalancerType: Network
 *       addressType: Internet
 *       addressIpVersion: Ipv4
 *       vpcId: ${defaultNetwork.id}
 *       tags:
 *         Created: TF
 *         For: example
 *       zoneMappings:
 *         - vswitchId: ${defaultSwitch.id}
 *           zoneId: ${defaultGetZones.zones[0].id}
 *         - vswitchId: ${default1.id}
 *           zoneId: ${defaultGetZones.zones[1].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:nlb:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NLB Load Balancer can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nlb/loadBalancer:LoadBalancer example <id>
 * ```
 */
public class LoadBalancer internal constructor(
    override val javaResource: com.pulumi.alicloud.nlb.LoadBalancer,
) : KotlinCustomResource(javaResource, LoadBalancerMapper) {
    /**
     * Protocol version. Value:
     * - **Ipv4**:IPv4 type.
     * - **DualStack**: Double Stack type.
     */
    public val addressIpVersion: Output<String>
        get() = javaResource.addressIpVersion().applyValue({ args0 -> args0 })

    /**
     * The network address type of IPv4 for network load balancing. Value:
     * - **Internet**: public network. Load balancer has a public network IP address, and the DNS domain name is resolved to a public network IP address, so it can be accessed in a public network environment.
     * - **Intranet**: private network. The server load balancer only has a private IP address, and the DNS domain name is resolved to the private IP address, so it can only be accessed by the intranet environment of the VPC where the server load balancer is located.
     */
    public val addressType: Output<String>
        get() = javaResource.addressType().applyValue({ args0 -> args0 })

    /**
     * The ID of the shared bandwidth package associated with the public network instance.
     */
    public val bandwidthPackageId: Output<String>
        get() = javaResource.bandwidthPackageId().applyValue({ args0 -> args0 })

    /**
     * Resource creation time, using Greenwich Mean Time, formating' yyyy-MM-ddTHH:mm:ssZ '.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Whether cross-zone is enabled for a network-based load balancing instance. Value:
     * - **true**: on.
     * - **false**: closed.
     */
    public val crossZoneEnabled: Output<Boolean>
        get() = javaResource.crossZoneEnabled().applyValue({ args0 -> args0 })

    /**
     * Delete protection. See `deletion_protection_config` below.
     */
    public val deletionProtectionConfig: Output<LoadBalancerDeletionProtectionConfig>
        get() = javaResource.deletionProtectionConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                loadBalancerDeletionProtectionConfigToKotlin(args0)
            })
        })

    /**
     * Specifies whether to enable deletion protection. Default value: `false`. Valid values:
     */
    public val deletionProtectionEnabled: Output<Boolean>
        get() = javaResource.deletionProtectionEnabled().applyValue({ args0 -> args0 })

    /**
     * The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
     */
    public val deletionProtectionReason: Output<String>
        get() = javaResource.deletionProtectionReason().applyValue({ args0 -> args0 })

    /**
     * The domain name of the NLB instance.
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * The IPv6 address type of network load balancing. Value:
     * - **Internet**: Server Load Balancer has a public IP address, and the DNS domain name is resolved to a public IP address, so it can be accessed in a public network environment.
     * - **Intranet**: SLB only has the private IP address, and the DNS domain name is resolved to the private IP address, so it can only be accessed by the Intranet environment of the VPC where SLB is located.
     */
    public val ipv6AddressType: Output<String>
        get() = javaResource.ipv6AddressType().applyValue({ args0 -> args0 })

    /**
     * The business status of the NLB instance.
     */
    public val loadBalancerBusinessStatus: Output<String>
        get() = javaResource.loadBalancerBusinessStatus().applyValue({ args0 -> args0 })

    /**
     * The name of the network-based load balancing instance.  2 to 128 English or Chinese characters in length, which must start with a letter or Chinese, and can contain numbers, half-width periods (.), underscores (_), and dashes (-).
     */
    public val loadBalancerName: Output<String>?
        get() = javaResource.loadBalancerName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Load balancing type. Only value: **network**, which indicates network-based load balancing.
     */
    public val loadBalancerType: Output<String>
        get() = javaResource.loadBalancerType().applyValue({ args0 -> args0 })

    /**
     * Modify protection. See `modification_protection_config` below.
     */
    public val modificationProtectionConfig: Output<LoadBalancerModificationProtectionConfig>
        get() = javaResource.modificationProtectionConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                loadBalancerModificationProtectionConfigToKotlin(args0)
            })
        })

    /**
     * The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
     */
    public val modificationProtectionReason: Output<String>
        get() = javaResource.modificationProtectionReason().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
     * - `NonProtection`: Does not enable the configuration read-only mode. You cannot set the `modification_protection_reason`. If the `modification_protection_reason` is set, the value is cleared.
     * - `ConsoleProtection`: Enables the configuration read-only mode. You can set the `modification_protection_reason`.
     */
    public val modificationProtectionStatus: Output<String>
        get() = javaResource.modificationProtectionStatus().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The security group to which the network-based SLB instance belongs.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * List of labels.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the network-based SLB instance.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The list of zones and vSwitch mappings. You must add at least two zones and a maximum of 10 zones. See `zone_mappings` below.
     */
    public val zoneMappings: Output<List<LoadBalancerZoneMapping>>
        get() = javaResource.zoneMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    loadBalancerZoneMappingToKotlin(args0)
                })
            })
        })
}

public object LoadBalancerMapper : ResourceMapper<LoadBalancer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nlb.LoadBalancer::class == javaResource::class

    override fun map(javaResource: Resource): LoadBalancer = LoadBalancer(
        javaResource as
            com.pulumi.alicloud.nlb.LoadBalancer,
    )
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadBalancer].
 */
public suspend fun loadBalancer(
    name: String,
    block: suspend LoadBalancerResourceBuilder.() -> Unit,
): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadBalancer(name: String): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    return builder.build()
}
