@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin

import com.pulumi.alicloud.nlb.LoadBalancerArgs.builder
import com.pulumi.alicloud.nlb.kotlin.inputs.LoadBalancerDeletionProtectionConfigArgs
import com.pulumi.alicloud.nlb.kotlin.inputs.LoadBalancerDeletionProtectionConfigArgsBuilder
import com.pulumi.alicloud.nlb.kotlin.inputs.LoadBalancerModificationProtectionConfigArgs
import com.pulumi.alicloud.nlb.kotlin.inputs.LoadBalancerModificationProtectionConfigArgsBuilder
import com.pulumi.alicloud.nlb.kotlin.inputs.LoadBalancerZoneMappingArgs
import com.pulumi.alicloud.nlb.kotlin.inputs.LoadBalancerZoneMappingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a NLB Load Balancer resource.
 * For information about NLB Load Balancer and how to use it, see [What is Load Balancer](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer).
 * > **NOTE:** Available since v1.191.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultGetZones = alicloud.nlb.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 * });
 * const default1 = new alicloud.vpc.Switch("default1", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.1.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[1]?.id),
 * });
 * const defaultLoadBalancer = new alicloud.nlb.LoadBalancer("default", {
 *     loadBalancerName: name,
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     loadBalancerType: "Network",
 *     addressType: "Internet",
 *     addressIpVersion: "Ipv4",
 *     vpcId: defaultNetwork.id,
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 *     zoneMappings: [
 *         {
 *             vswitchId: defaultSwitch.id,
 *             zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 *         },
 *         {
 *             vswitchId: default1.id,
 *             zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[1]?.id),
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_get_zones = alicloud.nlb.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default_get_zones.zones[0].id)
 * default1 = alicloud.vpc.Switch("default1",
 *     vswitch_name=name,
 *     cidr_block="10.4.1.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default_get_zones.zones[1].id)
 * default_load_balancer = alicloud.nlb.LoadBalancer("default",
 *     load_balancer_name=name,
 *     resource_group_id=default.ids[0],
 *     load_balancer_type="Network",
 *     address_type="Internet",
 *     address_ip_version="Ipv4",
 *     vpc_id=default_network.id,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     },
 *     zone_mappings=[
 *         {
 *             "vswitch_id": default_switch.id,
 *             "zone_id": default_get_zones.zones[0].id,
 *         },
 *         {
 *             "vswitch_id": default1.id,
 *             "zone_id": default_get_zones.zones[1].id,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultGetZones = AliCloud.Nlb.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var default1 = new AliCloud.Vpc.Switch("default1", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.1.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[1]?.Id),
 *     });
 *     var defaultLoadBalancer = new AliCloud.Nlb.LoadBalancer("default", new()
 *     {
 *         LoadBalancerName = name,
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         LoadBalancerType = "Network",
 *         AddressType = "Internet",
 *         AddressIpVersion = "Ipv4",
 *         VpcId = defaultNetwork.Id,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *         ZoneMappings = new[]
 *         {
 *             new AliCloud.Nlb.Inputs.LoadBalancerZoneMappingArgs
 *             {
 *                 VswitchId = defaultSwitch.Id,
 *                 ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *             },
 *             new AliCloud.Nlb.Inputs.LoadBalancerZoneMappingArgs
 *             {
 *                 VswitchId = default1.Id,
 *                 ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[1]?.Id),
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := nlb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(defaultGetZones.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default1, err := vpc.NewSwitch(ctx, "default1", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.1.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(defaultGetZones.Zones[1].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nlb.NewLoadBalancer(ctx, "default", &nlb.LoadBalancerArgs{
 * 			LoadBalancerName: pulumi.String(name),
 * 			ResourceGroupId:  pulumi.String(_default.Ids[0]),
 * 			LoadBalancerType: pulumi.String("Network"),
 * 			AddressType:      pulumi.String("Internet"),
 * 			AddressIpVersion: pulumi.String("Ipv4"),
 * 			VpcId:            defaultNetwork.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 			ZoneMappings: nlb.LoadBalancerZoneMappingArray{
 * 				&nlb.LoadBalancerZoneMappingArgs{
 * 					VswitchId: defaultSwitch.ID(),
 * 					ZoneId:    pulumi.String(defaultGetZones.Zones[0].Id),
 * 				},
 * 				&nlb.LoadBalancerZoneMappingArgs{
 * 					VswitchId: default1.ID(),
 * 					ZoneId:    pulumi.String(defaultGetZones.Zones[1].Id),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.nlb.NlbFunctions;
 * import com.pulumi.alicloud.nlb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.nlb.LoadBalancer;
 * import com.pulumi.alicloud.nlb.LoadBalancerArgs;
 * import com.pulumi.alicloud.nlb.inputs.LoadBalancerZoneMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         final var defaultGetZones = NlbFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var default1 = new Switch("default1", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.1.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[1].id()))
 *             .build());
 *         var defaultLoadBalancer = new LoadBalancer("defaultLoadBalancer", LoadBalancerArgs.builder()
 *             .loadBalancerName(name)
 *             .resourceGroupId(default_.ids()[0])
 *             .loadBalancerType("Network")
 *             .addressType("Internet")
 *             .addressIpVersion("Ipv4")
 *             .vpcId(defaultNetwork.id())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .zoneMappings(
 *                 LoadBalancerZoneMappingArgs.builder()
 *                     .vswitchId(defaultSwitch.id())
 *                     .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *                     .build(),
 *                 LoadBalancerZoneMappingArgs.builder()
 *                     .vswitchId(default1.id())
 *                     .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[1].id()))
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${defaultGetZones.zones[0].id}
 *   default1:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.1.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${defaultGetZones.zones[1].id}
 *   defaultLoadBalancer:
 *     type: alicloud:nlb:LoadBalancer
 *     name: default
 *     properties:
 *       loadBalancerName: ${name}
 *       resourceGroupId: ${default.ids[0]}
 *       loadBalancerType: Network
 *       addressType: Internet
 *       addressIpVersion: Ipv4
 *       vpcId: ${defaultNetwork.id}
 *       tags:
 *         Created: TF
 *         For: example
 *       zoneMappings:
 *         - vswitchId: ${defaultSwitch.id}
 *           zoneId: ${defaultGetZones.zones[0].id}
 *         - vswitchId: ${default1.id}
 *           zoneId: ${defaultGetZones.zones[1].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:nlb:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NLB Load Balancer can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nlb/loadBalancer:LoadBalancer example <id>
 * ```
 * @property addressIpVersion Protocol version. Value:
 * - **Ipv4**:IPv4 type.
 * - **DualStack**: Double Stack type.
 * @property addressType The network address type of IPv4 for network load balancing. Value:
 * - **Internet**: public network. Load balancer has a public network IP address, and the DNS domain name is resolved to a public network IP address, so it can be accessed in a public network environment.
 * - **Intranet**: private network. The server load balancer only has a private IP address, and the DNS domain name is resolved to the private IP address, so it can only be accessed by the intranet environment of the VPC where the server load balancer is located.
 * @property bandwidthPackageId The ID of the shared bandwidth package associated with the public network instance.
 * @property crossZoneEnabled Whether cross-zone is enabled for a network-based load balancing instance. Value:
 * - **true**: on.
 * - **false**: closed.
 * @property deletionProtectionConfig Delete protection. See `deletion_protection_config` below.
 * @property deletionProtectionEnabled Specifies whether to enable deletion protection. Default value: `false`. Valid values:
 * @property deletionProtectionReason The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
 * @property ipv6AddressType The IPv6 address type of network load balancing. Value:
 * - **Internet**: Server Load Balancer has a public IP address, and the DNS domain name is resolved to a public IP address, so it can be accessed in a public network environment.
 * - **Intranet**: SLB only has the private IP address, and the DNS domain name is resolved to the private IP address, so it can only be accessed by the Intranet environment of the VPC where SLB is located.
 * @property loadBalancerName The name of the network-based load balancing instance.  2 to 128 English or Chinese characters in length, which must start with a letter or Chinese, and can contain numbers, half-width periods (.), underscores (_), and dashes (-).
 * @property loadBalancerType Load balancing type. Only value: **network**, which indicates network-based load balancing.
 * @property modificationProtectionConfig Modify protection. See `modification_protection_config` below.
 * @property modificationProtectionReason The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
 * @property modificationProtectionStatus Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
 * - `NonProtection`: Does not enable the configuration read-only mode. You cannot set the `modification_protection_reason`. If the `modification_protection_reason` is set, the value is cleared.
 * - `ConsoleProtection`: Enables the configuration read-only mode. You can set the `modification_protection_reason`.
 * @property resourceGroupId The ID of the resource group.
 * @property securityGroupIds The security group to which the network-based SLB instance belongs.
 * @property tags List of labels.
 * @property vpcId The ID of the network-based SLB instance.
 * @property zoneMappings The list of zones and vSwitch mappings. You must add at least two zones and a maximum of 10 zones. See `zone_mappings` below.
 */
public data class LoadBalancerArgs(
    public val addressIpVersion: Output<String>? = null,
    public val addressType: Output<String>? = null,
    public val bandwidthPackageId: Output<String>? = null,
    public val crossZoneEnabled: Output<Boolean>? = null,
    public val deletionProtectionConfig: Output<LoadBalancerDeletionProtectionConfigArgs>? = null,
    public val deletionProtectionEnabled: Output<Boolean>? = null,
    public val deletionProtectionReason: Output<String>? = null,
    public val ipv6AddressType: Output<String>? = null,
    public val loadBalancerName: Output<String>? = null,
    public val loadBalancerType: Output<String>? = null,
    public val modificationProtectionConfig: Output<LoadBalancerModificationProtectionConfigArgs>? =
        null,
    public val modificationProtectionReason: Output<String>? = null,
    public val modificationProtectionStatus: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val zoneMappings: Output<List<LoadBalancerZoneMappingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.LoadBalancerArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.LoadBalancerArgs =
        com.pulumi.alicloud.nlb.LoadBalancerArgs.builder()
            .addressIpVersion(addressIpVersion?.applyValue({ args0 -> args0 }))
            .addressType(addressType?.applyValue({ args0 -> args0 }))
            .bandwidthPackageId(bandwidthPackageId?.applyValue({ args0 -> args0 }))
            .crossZoneEnabled(crossZoneEnabled?.applyValue({ args0 -> args0 }))
            .deletionProtectionConfig(
                deletionProtectionConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deletionProtectionEnabled(deletionProtectionEnabled?.applyValue({ args0 -> args0 }))
            .deletionProtectionReason(deletionProtectionReason?.applyValue({ args0 -> args0 }))
            .ipv6AddressType(ipv6AddressType?.applyValue({ args0 -> args0 }))
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .loadBalancerType(loadBalancerType?.applyValue({ args0 -> args0 }))
            .modificationProtectionConfig(
                modificationProtectionConfig?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .modificationProtectionReason(modificationProtectionReason?.applyValue({ args0 -> args0 }))
            .modificationProtectionStatus(modificationProtectionStatus?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .zoneMappings(
                zoneMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [LoadBalancerArgs].
 */
@PulumiTagMarker
public class LoadBalancerArgsBuilder internal constructor() {
    private var addressIpVersion: Output<String>? = null

    private var addressType: Output<String>? = null

    private var bandwidthPackageId: Output<String>? = null

    private var crossZoneEnabled: Output<Boolean>? = null

    private var deletionProtectionConfig: Output<LoadBalancerDeletionProtectionConfigArgs>? = null

    private var deletionProtectionEnabled: Output<Boolean>? = null

    private var deletionProtectionReason: Output<String>? = null

    private var ipv6AddressType: Output<String>? = null

    private var loadBalancerName: Output<String>? = null

    private var loadBalancerType: Output<String>? = null

    private var modificationProtectionConfig: Output<LoadBalancerModificationProtectionConfigArgs>? =
        null

    private var modificationProtectionReason: Output<String>? = null

    private var modificationProtectionStatus: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var zoneMappings: Output<List<LoadBalancerZoneMappingArgs>>? = null

    /**
     * @param value Protocol version. Value:
     * - **Ipv4**:IPv4 type.
     * - **DualStack**: Double Stack type.
     */
    @JvmName("wwdqqyptlvernvby")
    public suspend fun addressIpVersion(`value`: Output<String>) {
        this.addressIpVersion = value
    }

    /**
     * @param value The network address type of IPv4 for network load balancing. Value:
     * - **Internet**: public network. Load balancer has a public network IP address, and the DNS domain name is resolved to a public network IP address, so it can be accessed in a public network environment.
     * - **Intranet**: private network. The server load balancer only has a private IP address, and the DNS domain name is resolved to the private IP address, so it can only be accessed by the intranet environment of the VPC where the server load balancer is located.
     */
    @JvmName("tqaeceffgayyhsst")
    public suspend fun addressType(`value`: Output<String>) {
        this.addressType = value
    }

    /**
     * @param value The ID of the shared bandwidth package associated with the public network instance.
     */
    @JvmName("yievxoasnfwvwtgf")
    public suspend fun bandwidthPackageId(`value`: Output<String>) {
        this.bandwidthPackageId = value
    }

    /**
     * @param value Whether cross-zone is enabled for a network-based load balancing instance. Value:
     * - **true**: on.
     * - **false**: closed.
     */
    @JvmName("laxwagvbtvhprfhe")
    public suspend fun crossZoneEnabled(`value`: Output<Boolean>) {
        this.crossZoneEnabled = value
    }

    /**
     * @param value Delete protection. See `deletion_protection_config` below.
     */
    @JvmName("nglvbxufexebpses")
    public suspend fun deletionProtectionConfig(`value`: Output<LoadBalancerDeletionProtectionConfigArgs>) {
        this.deletionProtectionConfig = value
    }

    /**
     * @param value Specifies whether to enable deletion protection. Default value: `false`. Valid values:
     */
    @JvmName("xlwkhbgyinqhvygt")
    public suspend fun deletionProtectionEnabled(`value`: Output<Boolean>) {
        this.deletionProtectionEnabled = value
    }

    /**
     * @param value The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
     */
    @JvmName("bggwfhpfrjiuilpg")
    public suspend fun deletionProtectionReason(`value`: Output<String>) {
        this.deletionProtectionReason = value
    }

    /**
     * @param value The IPv6 address type of network load balancing. Value:
     * - **Internet**: Server Load Balancer has a public IP address, and the DNS domain name is resolved to a public IP address, so it can be accessed in a public network environment.
     * - **Intranet**: SLB only has the private IP address, and the DNS domain name is resolved to the private IP address, so it can only be accessed by the Intranet environment of the VPC where SLB is located.
     */
    @JvmName("wkpjledbmibvpkqc")
    public suspend fun ipv6AddressType(`value`: Output<String>) {
        this.ipv6AddressType = value
    }

    /**
     * @param value The name of the network-based load balancing instance.  2 to 128 English or Chinese characters in length, which must start with a letter or Chinese, and can contain numbers, half-width periods (.), underscores (_), and dashes (-).
     */
    @JvmName("shkmgaenhmwnjmbq")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value Load balancing type. Only value: **network**, which indicates network-based load balancing.
     */
    @JvmName("graxjlxwesaqacgy")
    public suspend fun loadBalancerType(`value`: Output<String>) {
        this.loadBalancerType = value
    }

    /**
     * @param value Modify protection. See `modification_protection_config` below.
     */
    @JvmName("rwmtikryifmycurl")
    public suspend fun modificationProtectionConfig(`value`: Output<LoadBalancerModificationProtectionConfigArgs>) {
        this.modificationProtectionConfig = value
    }

    /**
     * @param value The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
     */
    @JvmName("krojxspaancgpicx")
    public suspend fun modificationProtectionReason(`value`: Output<String>) {
        this.modificationProtectionReason = value
    }

    /**
     * @param value Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
     * - `NonProtection`: Does not enable the configuration read-only mode. You cannot set the `modification_protection_reason`. If the `modification_protection_reason` is set, the value is cleared.
     * - `ConsoleProtection`: Enables the configuration read-only mode. You can set the `modification_protection_reason`.
     */
    @JvmName("jycltbcjabjbsard")
    public suspend fun modificationProtectionStatus(`value`: Output<String>) {
        this.modificationProtectionStatus = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("hhupjhcsaneaiwae")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The security group to which the network-based SLB instance belongs.
     */
    @JvmName("vwdhaooajypdgjca")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("wsvfprpanywvulyh")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The security group to which the network-based SLB instance belongs.
     */
    @JvmName("smhmksecouxgjnju")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value List of labels.
     */
    @JvmName("uxfnmplcqfekejjk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the network-based SLB instance.
     */
    @JvmName("rgsakvuxciwpkuow")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The list of zones and vSwitch mappings. You must add at least two zones and a maximum of 10 zones. See `zone_mappings` below.
     */
    @JvmName("kxpehvegygdadtxm")
    public suspend fun zoneMappings(`value`: Output<List<LoadBalancerZoneMappingArgs>>) {
        this.zoneMappings = value
    }

    @JvmName("sppsgqjryypiydnh")
    public suspend fun zoneMappings(vararg values: Output<LoadBalancerZoneMappingArgs>) {
        this.zoneMappings = Output.all(values.asList())
    }

    /**
     * @param values The list of zones and vSwitch mappings. You must add at least two zones and a maximum of 10 zones. See `zone_mappings` below.
     */
    @JvmName("tynxjiocpubtwqcd")
    public suspend fun zoneMappings(values: List<Output<LoadBalancerZoneMappingArgs>>) {
        this.zoneMappings = Output.all(values)
    }

    /**
     * @param value Protocol version. Value:
     * - **Ipv4**:IPv4 type.
     * - **DualStack**: Double Stack type.
     */
    @JvmName("ccsfkgqouyrvkpgy")
    public suspend fun addressIpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressIpVersion = mapped
    }

    /**
     * @param value The network address type of IPv4 for network load balancing. Value:
     * - **Internet**: public network. Load balancer has a public network IP address, and the DNS domain name is resolved to a public network IP address, so it can be accessed in a public network environment.
     * - **Intranet**: private network. The server load balancer only has a private IP address, and the DNS domain name is resolved to the private IP address, so it can only be accessed by the intranet environment of the VPC where the server load balancer is located.
     */
    @JvmName("gioqbanftwqubfyu")
    public suspend fun addressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressType = mapped
    }

    /**
     * @param value The ID of the shared bandwidth package associated with the public network instance.
     */
    @JvmName("bqtdhajrfodiivbj")
    public suspend fun bandwidthPackageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthPackageId = mapped
    }

    /**
     * @param value Whether cross-zone is enabled for a network-based load balancing instance. Value:
     * - **true**: on.
     * - **false**: closed.
     */
    @JvmName("peinctjymsnkcsyu")
    public suspend fun crossZoneEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossZoneEnabled = mapped
    }

    /**
     * @param value Delete protection. See `deletion_protection_config` below.
     */
    @JvmName("aqqabmemjdqcbclj")
    public suspend fun deletionProtectionConfig(`value`: LoadBalancerDeletionProtectionConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtectionConfig = mapped
    }

    /**
     * @param argument Delete protection. See `deletion_protection_config` below.
     */
    @JvmName("twqmsbdcfkpgwcrq")
    public suspend fun deletionProtectionConfig(argument: suspend LoadBalancerDeletionProtectionConfigArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerDeletionProtectionConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deletionProtectionConfig = mapped
    }

    /**
     * @param value Specifies whether to enable deletion protection. Default value: `false`. Valid values:
     */
    @JvmName("txrppqdfntxgsroa")
    public suspend fun deletionProtectionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtectionEnabled = mapped
    }

    /**
     * @param value The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
     */
    @JvmName("ukotgupfsvltpucn")
    public suspend fun deletionProtectionReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtectionReason = mapped
    }

    /**
     * @param value The IPv6 address type of network load balancing. Value:
     * - **Internet**: Server Load Balancer has a public IP address, and the DNS domain name is resolved to a public IP address, so it can be accessed in a public network environment.
     * - **Intranet**: SLB only has the private IP address, and the DNS domain name is resolved to the private IP address, so it can only be accessed by the Intranet environment of the VPC where SLB is located.
     */
    @JvmName("gafiydqhuggbqfna")
    public suspend fun ipv6AddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressType = mapped
    }

    /**
     * @param value The name of the network-based load balancing instance.  2 to 128 English or Chinese characters in length, which must start with a letter or Chinese, and can contain numbers, half-width periods (.), underscores (_), and dashes (-).
     */
    @JvmName("yihlcfdqcvkbyvcb")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value Load balancing type. Only value: **network**, which indicates network-based load balancing.
     */
    @JvmName("xechufjexypwgvqj")
    public suspend fun loadBalancerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerType = mapped
    }

    /**
     * @param value Modify protection. See `modification_protection_config` below.
     */
    @JvmName("dvidcxdtreonfwqi")
    public suspend fun modificationProtectionConfig(`value`: LoadBalancerModificationProtectionConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modificationProtectionConfig = mapped
    }

    /**
     * @param argument Modify protection. See `modification_protection_config` below.
     */
    @JvmName("iegsqnrscxmctgrv")
    public suspend fun modificationProtectionConfig(argument: suspend LoadBalancerModificationProtectionConfigArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerModificationProtectionConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.modificationProtectionConfig = mapped
    }

    /**
     * @param value The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
     */
    @JvmName("jyphuemyqxlmftsh")
    public suspend fun modificationProtectionReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modificationProtectionReason = mapped
    }

    /**
     * @param value Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
     * - `NonProtection`: Does not enable the configuration read-only mode. You cannot set the `modification_protection_reason`. If the `modification_protection_reason` is set, the value is cleared.
     * - `ConsoleProtection`: Enables the configuration read-only mode. You can set the `modification_protection_reason`.
     */
    @JvmName("qdtkoasbquskixue")
    public suspend fun modificationProtectionStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modificationProtectionStatus = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("sjbxlrevveiukxae")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The security group to which the network-based SLB instance belongs.
     */
    @JvmName("pgxqgrtpgxlqepli")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The security group to which the network-based SLB instance belongs.
     */
    @JvmName("ppflkdrnwdhowvat")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value List of labels.
     */
    @JvmName("twougxfbkevlmcmw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values List of labels.
     */
    @JvmName("ksqeannsfyhlictc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the network-based SLB instance.
     */
    @JvmName("uixxbuobfrmqntdh")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The list of zones and vSwitch mappings. You must add at least two zones and a maximum of 10 zones. See `zone_mappings` below.
     */
    @JvmName("rdfvlciubggjwyxa")
    public suspend fun zoneMappings(`value`: List<LoadBalancerZoneMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneMappings = mapped
    }

    /**
     * @param argument The list of zones and vSwitch mappings. You must add at least two zones and a maximum of 10 zones. See `zone_mappings` below.
     */
    @JvmName("jilrqqhxpyajmgsk")
    public suspend fun zoneMappings(argument: List<suspend LoadBalancerZoneMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerZoneMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.zoneMappings = mapped
    }

    /**
     * @param argument The list of zones and vSwitch mappings. You must add at least two zones and a maximum of 10 zones. See `zone_mappings` below.
     */
    @JvmName("ahfmepstalkgwtwq")
    public suspend fun zoneMappings(vararg argument: suspend LoadBalancerZoneMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LoadBalancerZoneMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.zoneMappings = mapped
    }

    /**
     * @param argument The list of zones and vSwitch mappings. You must add at least two zones and a maximum of 10 zones. See `zone_mappings` below.
     */
    @JvmName("leyqopymjcqhlhop")
    public suspend fun zoneMappings(argument: suspend LoadBalancerZoneMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancerZoneMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.zoneMappings = mapped
    }

    /**
     * @param values The list of zones and vSwitch mappings. You must add at least two zones and a maximum of 10 zones. See `zone_mappings` below.
     */
    @JvmName("mhxbhoiaksuallbc")
    public suspend fun zoneMappings(vararg values: LoadBalancerZoneMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneMappings = mapped
    }

    internal fun build(): LoadBalancerArgs = LoadBalancerArgs(
        addressIpVersion = addressIpVersion,
        addressType = addressType,
        bandwidthPackageId = bandwidthPackageId,
        crossZoneEnabled = crossZoneEnabled,
        deletionProtectionConfig = deletionProtectionConfig,
        deletionProtectionEnabled = deletionProtectionEnabled,
        deletionProtectionReason = deletionProtectionReason,
        ipv6AddressType = ipv6AddressType,
        loadBalancerName = loadBalancerName,
        loadBalancerType = loadBalancerType,
        modificationProtectionConfig = modificationProtectionConfig,
        modificationProtectionReason = modificationProtectionReason,
        modificationProtectionStatus = modificationProtectionStatus,
        resourceGroupId = resourceGroupId,
        securityGroupIds = securityGroupIds,
        tags = tags,
        vpcId = vpcId,
        zoneMappings = zoneMappings,
    )
}
