@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin

import com.pulumi.alicloud.nlb.LoadBalancerSecurityGroupAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Nlb Load Balancer Security Group Attachment resource.
 * For information about Nlb Load Balancer Security Group Attachment and how to use it, see [What is Load Balancer Security Group Attachment](https://www.alibabacloud.com/help/en/server-load-balancer/latest/loadbalancerjoinsecuritygroup).
 * > **NOTE:** Available since v1.198.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultGetZones = alicloud.nlb.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 * });
 * const default1 = new alicloud.vpc.Switch("default1", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.1.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[1]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultLoadBalancer = new alicloud.nlb.LoadBalancer("default", {
 *     loadBalancerName: name,
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     loadBalancerType: "Network",
 *     addressType: "Internet",
 *     addressIpVersion: "Ipv4",
 *     vpcId: defaultNetwork.id,
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 *     zoneMappings: [
 *         {
 *             vswitchId: defaultSwitch.id,
 *             zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 *         },
 *         {
 *             vswitchId: default1.id,
 *             zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[1]?.id),
 *         },
 *     ],
 * });
 * const defaultLoadBalancerSecurityGroupAttachment = new alicloud.nlb.LoadBalancerSecurityGroupAttachment("default", {
 *     securityGroupId: defaultSecurityGroup.id,
 *     loadBalancerId: defaultLoadBalancer.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_get_zones = alicloud.nlb.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default_get_zones.zones[0].id)
 * default1 = alicloud.vpc.Switch("default1",
 *     vswitch_name=name,
 *     cidr_block="10.4.1.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default_get_zones.zones[1].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_load_balancer = alicloud.nlb.LoadBalancer("default",
 *     load_balancer_name=name,
 *     resource_group_id=default.ids[0],
 *     load_balancer_type="Network",
 *     address_type="Internet",
 *     address_ip_version="Ipv4",
 *     vpc_id=default_network.id,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     },
 *     zone_mappings=[
 *         {
 *             "vswitch_id": default_switch.id,
 *             "zone_id": default_get_zones.zones[0].id,
 *         },
 *         {
 *             "vswitch_id": default1.id,
 *             "zone_id": default_get_zones.zones[1].id,
 *         },
 *     ])
 * default_load_balancer_security_group_attachment = alicloud.nlb.LoadBalancerSecurityGroupAttachment("default",
 *     security_group_id=default_security_group.id,
 *     load_balancer_id=default_load_balancer.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultGetZones = AliCloud.Nlb.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var default1 = new AliCloud.Vpc.Switch("default1", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.1.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[1]?.Id),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultLoadBalancer = new AliCloud.Nlb.LoadBalancer("default", new()
 *     {
 *         LoadBalancerName = name,
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         LoadBalancerType = "Network",
 *         AddressType = "Internet",
 *         AddressIpVersion = "Ipv4",
 *         VpcId = defaultNetwork.Id,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *         ZoneMappings = new[]
 *         {
 *             new AliCloud.Nlb.Inputs.LoadBalancerZoneMappingArgs
 *             {
 *                 VswitchId = defaultSwitch.Id,
 *                 ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *             },
 *             new AliCloud.Nlb.Inputs.LoadBalancerZoneMappingArgs
 *             {
 *                 VswitchId = default1.Id,
 *                 ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[1]?.Id),
 *             },
 *         },
 *     });
 *     var defaultLoadBalancerSecurityGroupAttachment = new AliCloud.Nlb.LoadBalancerSecurityGroupAttachment("default", new()
 *     {
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         LoadBalancerId = defaultLoadBalancer.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := nlb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(defaultGetZones.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default1, err := vpc.NewSwitch(ctx, "default1", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.1.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(defaultGetZones.Zones[1].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultLoadBalancer, err := nlb.NewLoadBalancer(ctx, "default", &nlb.LoadBalancerArgs{
 * 			LoadBalancerName: pulumi.String(name),
 * 			ResourceGroupId:  pulumi.String(_default.Ids[0]),
 * 			LoadBalancerType: pulumi.String("Network"),
 * 			AddressType:      pulumi.String("Internet"),
 * 			AddressIpVersion: pulumi.String("Ipv4"),
 * 			VpcId:            defaultNetwork.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 			ZoneMappings: nlb.LoadBalancerZoneMappingArray{
 * 				&nlb.LoadBalancerZoneMappingArgs{
 * 					VswitchId: defaultSwitch.ID(),
 * 					ZoneId:    pulumi.String(defaultGetZones.Zones[0].Id),
 * 				},
 * 				&nlb.LoadBalancerZoneMappingArgs{
 * 					VswitchId: default1.ID(),
 * 					ZoneId:    pulumi.String(defaultGetZones.Zones[1].Id),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nlb.NewLoadBalancerSecurityGroupAttachment(ctx, "default", &nlb.LoadBalancerSecurityGroupAttachmentArgs{
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			LoadBalancerId:  defaultLoadBalancer.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.nlb.NlbFunctions;
 * import com.pulumi.alicloud.nlb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.nlb.LoadBalancer;
 * import com.pulumi.alicloud.nlb.LoadBalancerArgs;
 * import com.pulumi.alicloud.nlb.inputs.LoadBalancerZoneMappingArgs;
 * import com.pulumi.alicloud.nlb.LoadBalancerSecurityGroupAttachment;
 * import com.pulumi.alicloud.nlb.LoadBalancerSecurityGroupAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         final var defaultGetZones = NlbFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var default1 = new Switch("default1", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.1.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[1].id()))
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultLoadBalancer = new LoadBalancer("defaultLoadBalancer", LoadBalancerArgs.builder()
 *             .loadBalancerName(name)
 *             .resourceGroupId(default_.ids()[0])
 *             .loadBalancerType("Network")
 *             .addressType("Internet")
 *             .addressIpVersion("Ipv4")
 *             .vpcId(defaultNetwork.id())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .zoneMappings(
 *                 LoadBalancerZoneMappingArgs.builder()
 *                     .vswitchId(defaultSwitch.id())
 *                     .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *                     .build(),
 *                 LoadBalancerZoneMappingArgs.builder()
 *                     .vswitchId(default1.id())
 *                     .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[1].id()))
 *                     .build())
 *             .build());
 *         var defaultLoadBalancerSecurityGroupAttachment = new LoadBalancerSecurityGroupAttachment("defaultLoadBalancerSecurityGroupAttachment", LoadBalancerSecurityGroupAttachmentArgs.builder()
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .loadBalancerId(defaultLoadBalancer.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${defaultGetZones.zones[0].id}
 *   default1:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.1.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${defaultGetZones.zones[1].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 *   defaultLoadBalancer:
 *     type: alicloud:nlb:LoadBalancer
 *     name: default
 *     properties:
 *       loadBalancerName: ${name}
 *       resourceGroupId: ${default.ids[0]}
 *       loadBalancerType: Network
 *       addressType: Internet
 *       addressIpVersion: Ipv4
 *       vpcId: ${defaultNetwork.id}
 *       tags:
 *         Created: TF
 *         For: example
 *       zoneMappings:
 *         - vswitchId: ${defaultSwitch.id}
 *           zoneId: ${defaultGetZones.zones[0].id}
 *         - vswitchId: ${default1.id}
 *           zoneId: ${defaultGetZones.zones[1].id}
 *   defaultLoadBalancerSecurityGroupAttachment:
 *     type: alicloud:nlb:LoadBalancerSecurityGroupAttachment
 *     name: default
 *     properties:
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       loadBalancerId: ${defaultLoadBalancer.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:nlb:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NLB Load Balancer Security Group Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nlb/loadBalancerSecurityGroupAttachment:LoadBalancerSecurityGroupAttachment example <load_balancer_id>:<security_group_id>
 * ```
 * @property dryRun Whether to PreCheck this request only. Value:
 * - **true**: sends a check request and does not bind a security group to the instance. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
 * - **false** (default): Sends a normal request, returns the HTTP 2xx status code after the check, and directly performs the operation.
 * @property loadBalancerId The ID of the network-based server load balancer instance to be bound to the security group.
 * @property securityGroupId The ID of the security group.
 */
public data class LoadBalancerSecurityGroupAttachmentArgs(
    public val dryRun: Output<Boolean>? = null,
    public val loadBalancerId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.nlb.LoadBalancerSecurityGroupAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.nlb.LoadBalancerSecurityGroupAttachmentArgs =
        com.pulumi.alicloud.nlb.LoadBalancerSecurityGroupAttachmentArgs.builder()
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .loadBalancerId(loadBalancerId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerSecurityGroupAttachmentArgs].
 */
@PulumiTagMarker
public class LoadBalancerSecurityGroupAttachmentArgsBuilder internal constructor() {
    private var dryRun: Output<Boolean>? = null

    private var loadBalancerId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    /**
     * @param value Whether to PreCheck this request only. Value:
     * - **true**: sends a check request and does not bind a security group to the instance. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
     * - **false** (default): Sends a normal request, returns the HTTP 2xx status code after the check, and directly performs the operation.
     */
    @JvmName("dadxralbkivrgwyl")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The ID of the network-based server load balancer instance to be bound to the security group.
     */
    @JvmName("wqyhdkxnrmxlibma")
    public suspend fun loadBalancerId(`value`: Output<String>) {
        this.loadBalancerId = value
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("qwflxlyeyclbqjvf")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value Whether to PreCheck this request only. Value:
     * - **true**: sends a check request and does not bind a security group to the instance. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
     * - **false** (default): Sends a normal request, returns the HTTP 2xx status code after the check, and directly performs the operation.
     */
    @JvmName("jkrjniuglqehvlry")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The ID of the network-based server load balancer instance to be bound to the security group.
     */
    @JvmName("mjtosynqaefdudrs")
    public suspend fun loadBalancerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerId = mapped
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("yprkdqqwgqjcskai")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    internal fun build(): LoadBalancerSecurityGroupAttachmentArgs =
        LoadBalancerSecurityGroupAttachmentArgs(
            dryRun = dryRun,
            loadBalancerId = loadBalancerId,
            securityGroupId = securityGroupId,
        )
}
