@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin

import com.pulumi.alicloud.nlb.NlbFunctions.getListenersPlain
import com.pulumi.alicloud.nlb.NlbFunctions.getLoadBalancersPlain
import com.pulumi.alicloud.nlb.NlbFunctions.getSecurityPoliciesPlain
import com.pulumi.alicloud.nlb.NlbFunctions.getServerGroupServerAttachmentsPlain
import com.pulumi.alicloud.nlb.NlbFunctions.getServerGroupsPlain
import com.pulumi.alicloud.nlb.NlbFunctions.getZonesPlain
import com.pulumi.alicloud.nlb.kotlin.inputs.GetListenersPlainArgs
import com.pulumi.alicloud.nlb.kotlin.inputs.GetListenersPlainArgsBuilder
import com.pulumi.alicloud.nlb.kotlin.inputs.GetLoadBalancersPlainArgs
import com.pulumi.alicloud.nlb.kotlin.inputs.GetLoadBalancersPlainArgsBuilder
import com.pulumi.alicloud.nlb.kotlin.inputs.GetSecurityPoliciesPlainArgs
import com.pulumi.alicloud.nlb.kotlin.inputs.GetSecurityPoliciesPlainArgsBuilder
import com.pulumi.alicloud.nlb.kotlin.inputs.GetServerGroupServerAttachmentsPlainArgs
import com.pulumi.alicloud.nlb.kotlin.inputs.GetServerGroupServerAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.nlb.kotlin.inputs.GetServerGroupsPlainArgs
import com.pulumi.alicloud.nlb.kotlin.inputs.GetServerGroupsPlainArgsBuilder
import com.pulumi.alicloud.nlb.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.nlb.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.nlb.kotlin.outputs.GetListenersResult
import com.pulumi.alicloud.nlb.kotlin.outputs.GetLoadBalancersResult
import com.pulumi.alicloud.nlb.kotlin.outputs.GetSecurityPoliciesResult
import com.pulumi.alicloud.nlb.kotlin.outputs.GetServerGroupServerAttachmentsResult
import com.pulumi.alicloud.nlb.kotlin.outputs.GetServerGroupsResult
import com.pulumi.alicloud.nlb.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.nlb.kotlin.outputs.GetListenersResult.Companion.toKotlin as getListenersResultToKotlin
import com.pulumi.alicloud.nlb.kotlin.outputs.GetLoadBalancersResult.Companion.toKotlin as getLoadBalancersResultToKotlin
import com.pulumi.alicloud.nlb.kotlin.outputs.GetSecurityPoliciesResult.Companion.toKotlin as getSecurityPoliciesResultToKotlin
import com.pulumi.alicloud.nlb.kotlin.outputs.GetServerGroupServerAttachmentsResult.Companion.toKotlin as getServerGroupServerAttachmentsResultToKotlin
import com.pulumi.alicloud.nlb.kotlin.outputs.GetServerGroupsResult.Companion.toKotlin as getServerGroupsResultToKotlin
import com.pulumi.alicloud.nlb.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object NlbFunctions {
    /**
     * This data source provides the Nlb Listeners of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.191.0+.
     * @param argument A collection of arguments for invoking getListeners.
     * @return A collection of values returned by getListeners.
     */
    public suspend fun getListeners(argument: GetListenersPlainArgs): GetListenersResult =
        getListenersResultToKotlin(getListenersPlain(argument.toJava()).await())

    /**
     * @see [getListeners].
     * @param ids A list of Listener IDs.
     * @param listenerProtocol The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
     * @param loadBalancerIds The ID of the NLB instance. You can specify at most 20 IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getListeners.
     */
    public suspend fun getListeners(
        ids: List<String>? = null,
        listenerProtocol: String? = null,
        loadBalancerIds: List<String>? = null,
        outputFile: String? = null,
    ): GetListenersResult {
        val argument = GetListenersPlainArgs(
            ids = ids,
            listenerProtocol = listenerProtocol,
            loadBalancerIds = loadBalancerIds,
            outputFile = outputFile,
        )
        return getListenersResultToKotlin(getListenersPlain(argument.toJava()).await())
    }

    /**
     * @see [getListeners].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nlb&#46;kotlin&#46;inputs&#46;GetListenersPlainArgs].
     * @return A collection of values returned by getListeners.
     */
    public suspend fun getListeners(argument: suspend GetListenersPlainArgsBuilder.() -> Unit): GetListenersResult {
        val builder = GetListenersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getListenersResultToKotlin(getListenersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Nlb Load Balancers of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.191.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.nlb.getLoadBalancers({
     *     ids: ["example_id"],
     * });
     * export const nlbLoadBalancerId1 = ids.then(ids => ids.balancers?.[0]?.id);
     * const nameRegex = alicloud.nlb.getLoadBalancers({
     *     nameRegex: "^my-LoadBalancer",
     * });
     * export const nlbLoadBalancerId2 = nameRegex.then(nameRegex => nameRegex.balancers?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.nlb.get_load_balancers(ids=["example_id"])
     * pulumi.export("nlbLoadBalancerId1", ids.balancers[0].id)
     * name_regex = alicloud.nlb.get_load_balancers(name_regex="^my-LoadBalancer")
     * pulumi.export("nlbLoadBalancerId2", name_regex.balancers[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Nlb.GetLoadBalancers.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Nlb.GetLoadBalancers.Invoke(new()
     *     {
     *         NameRegex = "^my-LoadBalancer",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["nlbLoadBalancerId1"] = ids&#46;Apply(getLoadBalancersResult => getLoadBalancersResult&#46;Balancers[0]?.Id),
     *         ["nlbLoadBalancerId2"] = nameRegex&#46;Apply(getLoadBalancersResult => getLoadBalancersResult&#46;Balancers[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := nlb.GetLoadBalancers(ctx, &nlb.GetLoadBalancersArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nlbLoadBalancerId1", ids.Balancers[0].Id)
     * 		nameRegex, err := nlb.GetLoadBalancers(ctx, &nlb.GetLoadBalancersArgs{
     * 			NameRegex: pulumi.StringRef("^my-LoadBalancer"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nlbLoadBalancerId2", nameRegex.Balancers[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nlb.NlbFunctions;
     * import com.pulumi.alicloud.nlb.inputs.GetLoadBalancersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = NlbFunctions.getLoadBalancers(GetLoadBalancersArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("nlbLoadBalancerId1", ids.applyValue(getLoadBalancersResult -> getLoadBalancersResult.balancers()[0].id()));
     *         final var nameRegex = NlbFunctions.getLoadBalancers(GetLoadBalancersArgs.builder()
     *             .nameRegex("^my-LoadBalancer")
     *             .build());
     *         ctx.export("nlbLoadBalancerId2", nameRegex.applyValue(getLoadBalancersResult -> getLoadBalancersResult.balancers()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:nlb:getLoadBalancers
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:nlb:getLoadBalancers
     *       Arguments:
     *         nameRegex: ^my-LoadBalancer
     * outputs:
     *   nlbLoadBalancerId1: ${ids.balancers[0].id}
     *   nlbLoadBalancerId2: ${nameRegex.balancers[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLoadBalancers.
     * @return A collection of values returned by getLoadBalancers.
     */
    public suspend fun getLoadBalancers(argument: GetLoadBalancersPlainArgs): GetLoadBalancersResult =
        getLoadBalancersResultToKotlin(getLoadBalancersPlain(argument.toJava()).await())

    /**
     * @see [getLoadBalancers].
     * @param addressIpVersion The IP version. Valid values: `ipv4`, `DualStack`.
     * @param addressType The type of IPv4 address used by the NLB instance. Valid values: `Internet`, `Intranet`.
     * @param dnsName The domain name of the NLB instance.
     * @param ids A list of Load Balancer IDs.
     * @param ipv6AddressType The type of IPv6 address used by the NLB instance. Valid values: `Internet`, `Intranet`.
     * @param loadBalancerBusinessStatus The business status of the NLB instance. Valid values: `Abnormal`, `Normal`.
     * @param loadBalancerNames The name of the NLB instance. You can specify at most 10 names.
     * @param nameRegex A regex string to filter results by Load Balancer name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group.
     * @param status The status of the NLB instance. Valid values: `Inactive`, `Active`, `Provisioning`, `Configuring`, `Deleting`, `Deleted`.
     * @param tags
     * @param vpcIds The ID of the virtual private cloud (VPC) where the NLB instance is deployed. You can specify at most 10 IDs.
     * @param zoneId The name of the zone.
     * @return A collection of values returned by getLoadBalancers.
     */
    public suspend fun getLoadBalancers(
        addressIpVersion: String? = null,
        addressType: String? = null,
        dnsName: String? = null,
        ids: List<String>? = null,
        ipv6AddressType: String? = null,
        loadBalancerBusinessStatus: String? = null,
        loadBalancerNames: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcIds: List<String>? = null,
        zoneId: String? = null,
    ): GetLoadBalancersResult {
        val argument = GetLoadBalancersPlainArgs(
            addressIpVersion = addressIpVersion,
            addressType = addressType,
            dnsName = dnsName,
            ids = ids,
            ipv6AddressType = ipv6AddressType,
            loadBalancerBusinessStatus = loadBalancerBusinessStatus,
            loadBalancerNames = loadBalancerNames,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            status = status,
            tags = tags,
            vpcIds = vpcIds,
            zoneId = zoneId,
        )
        return getLoadBalancersResultToKotlin(getLoadBalancersPlain(argument.toJava()).await())
    }

    /**
     * @see [getLoadBalancers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nlb&#46;kotlin&#46;inputs&#46;GetLoadBalancersPlainArgs].
     * @return A collection of values returned by getLoadBalancers.
     */
    public suspend fun getLoadBalancers(argument: suspend GetLoadBalancersPlainArgsBuilder.() -> Unit): GetLoadBalancersResult {
        val builder = GetLoadBalancersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLoadBalancersResultToKotlin(getLoadBalancersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Nlb Security Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.187.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.nlb.getSecurityPolicies({});
     * export const nlbSecurityPolicyId1 = ids.then(ids => ids.policies?.[0]?.id);
     * const nameRegex = alicloud.nlb.getSecurityPolicies({
     *     nameRegex: "^my-SecurityPolicy",
     * });
     * export const nlbSecurityPolicyId2 = nameRegex.then(nameRegex => nameRegex.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.nlb.get_security_policies()
     * pulumi.export("nlbSecurityPolicyId1", ids.policies[0].id)
     * name_regex = alicloud.nlb.get_security_policies(name_regex="^my-SecurityPolicy")
     * pulumi.export("nlbSecurityPolicyId2", name_regex.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Nlb.GetSecurityPolicies.Invoke();
     *     var nameRegex = AliCloud.Nlb.GetSecurityPolicies.Invoke(new()
     *     {
     *         NameRegex = "^my-SecurityPolicy",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["nlbSecurityPolicyId1"] = ids&#46;Apply(getSecurityPoliciesResult => getSecurityPoliciesResult&#46;Policies[0]?.Id),
     *         ["nlbSecurityPolicyId2"] = nameRegex&#46;Apply(getSecurityPoliciesResult => getSecurityPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := nlb.GetSecurityPolicies(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nlbSecurityPolicyId1", ids.Policies[0].Id)
     * 		nameRegex, err := nlb.GetSecurityPolicies(ctx, &nlb.GetSecurityPoliciesArgs{
     * 			NameRegex: pulumi.StringRef("^my-SecurityPolicy"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nlbSecurityPolicyId2", nameRegex.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nlb.NlbFunctions;
     * import com.pulumi.alicloud.nlb.inputs.GetSecurityPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = NlbFunctions.getSecurityPolicies();
     *         ctx.export("nlbSecurityPolicyId1", ids.applyValue(getSecurityPoliciesResult -> getSecurityPoliciesResult.policies()[0].id()));
     *         final var nameRegex = NlbFunctions.getSecurityPolicies(GetSecurityPoliciesArgs.builder()
     *             .nameRegex("^my-SecurityPolicy")
     *             .build());
     *         ctx.export("nlbSecurityPolicyId2", nameRegex.applyValue(getSecurityPoliciesResult -> getSecurityPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:nlb:getSecurityPolicies
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:nlb:getSecurityPolicies
     *       Arguments:
     *         nameRegex: ^my-SecurityPolicy
     * outputs:
     *   nlbSecurityPolicyId1: ${ids.policies[0].id}
     *   nlbSecurityPolicyId2: ${nameRegex.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecurityPolicies.
     * @return A collection of values returned by getSecurityPolicies.
     */
    public suspend fun getSecurityPolicies(argument: GetSecurityPoliciesPlainArgs): GetSecurityPoliciesResult =
        getSecurityPoliciesResultToKotlin(getSecurityPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getSecurityPolicies].
     * @param ids A list of Security Policy IDs.
     * @param nameRegex A regex string to filter results by Security Policy name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group.
     * @param securityPolicyNames The names of the TLS security policies.
     * @param status The status of the resource. Valid values: `Available`, `Configuring`.
     * @param tags
     * @return A collection of values returned by getSecurityPolicies.
     */
    public suspend fun getSecurityPolicies(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        securityPolicyNames: List<String>? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetSecurityPoliciesResult {
        val argument = GetSecurityPoliciesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            securityPolicyNames = securityPolicyNames,
            status = status,
            tags = tags,
        )
        return getSecurityPoliciesResultToKotlin(getSecurityPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nlb&#46;kotlin&#46;inputs&#46;GetSecurityPoliciesPlainArgs].
     * @return A collection of values returned by getSecurityPolicies.
     */
    public suspend fun getSecurityPolicies(argument: suspend GetSecurityPoliciesPlainArgsBuilder.() -> Unit): GetSecurityPoliciesResult {
        val builder = GetSecurityPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityPoliciesResultToKotlin(getSecurityPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Nlb Server Group Server Attachments of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.192.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.nlb.getServerGroupServerAttachments({
     *     ids: ["example_value"],
     * });
     * export const nlbServerGroupServerAttachmentId1 = ids.then(ids => ids.attachments?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.nlb.get_server_group_server_attachments(ids=["example_value"])
     * pulumi.export("nlbServerGroupServerAttachmentId1", ids.attachments[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Nlb.GetServerGroupServerAttachments.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["nlbServerGroupServerAttachmentId1"] = ids&#46;Apply(getServerGroupServerAttachmentsResult => getServerGroupServerAttachmentsResult&#46;Attachments[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := nlb.GetServerGroupServerAttachments(ctx, &nlb.GetServerGroupServerAttachmentsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nlbServerGroupServerAttachmentId1", ids.Attachments[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nlb.NlbFunctions;
     * import com.pulumi.alicloud.nlb.inputs.GetServerGroupServerAttachmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = NlbFunctions.getServerGroupServerAttachments(GetServerGroupServerAttachmentsArgs.builder()
     *             .ids("example_value")
     *             .build());
     *         ctx.export("nlbServerGroupServerAttachmentId1", ids.applyValue(getServerGroupServerAttachmentsResult -> getServerGroupServerAttachmentsResult.attachments()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:nlb:getServerGroupServerAttachments
     *       Arguments:
     *         ids:
     *           - example_value
     * outputs:
     *   nlbServerGroupServerAttachmentId1: ${ids.attachments[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerGroupServerAttachments.
     * @return A collection of values returned by getServerGroupServerAttachments.
     */
    public suspend fun getServerGroupServerAttachments(argument: GetServerGroupServerAttachmentsPlainArgs): GetServerGroupServerAttachmentsResult =
        getServerGroupServerAttachmentsResultToKotlin(getServerGroupServerAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getServerGroupServerAttachments].
     * @param ids A list of Server Group Server Attachment IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param serverGroupId The ID of the server group.
     * @param serverIds The IDs of the servers. You can specify at most 40 server IDs in each call.
     * @param serverIps The IP addresses of the servers. You can specify at most 40 server IP addresses in each call.
     * @return A collection of values returned by getServerGroupServerAttachments.
     */
    public suspend fun getServerGroupServerAttachments(
        ids: List<String>? = null,
        outputFile: String? = null,
        serverGroupId: String? = null,
        serverIds: List<String>? = null,
        serverIps: List<String>? = null,
    ): GetServerGroupServerAttachmentsResult {
        val argument = GetServerGroupServerAttachmentsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            serverGroupId = serverGroupId,
            serverIds = serverIds,
            serverIps = serverIps,
        )
        return getServerGroupServerAttachmentsResultToKotlin(getServerGroupServerAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerGroupServerAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nlb&#46;kotlin&#46;inputs&#46;GetServerGroupServerAttachmentsPlainArgs].
     * @return A collection of values returned by getServerGroupServerAttachments.
     */
    public suspend fun getServerGroupServerAttachments(argument: suspend GetServerGroupServerAttachmentsPlainArgsBuilder.() -> Unit): GetServerGroupServerAttachmentsResult {
        val builder = GetServerGroupServerAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerGroupServerAttachmentsResultToKotlin(getServerGroupServerAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Nlb Server Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.186.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.nlb.getServerGroups({});
     * export const nlbServerGroupId1 = ids.then(ids => ids.groups?.[0]?.id);
     * const nameRegex = alicloud.nlb.getServerGroups({
     *     nameRegex: "^my-ServerGroup",
     * });
     * export const nlbServerGroupId2 = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.nlb.get_server_groups()
     * pulumi.export("nlbServerGroupId1", ids.groups[0].id)
     * name_regex = alicloud.nlb.get_server_groups(name_regex="^my-ServerGroup")
     * pulumi.export("nlbServerGroupId2", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Nlb.GetServerGroups.Invoke();
     *     var nameRegex = AliCloud.Nlb.GetServerGroups.Invoke(new()
     *     {
     *         NameRegex = "^my-ServerGroup",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["nlbServerGroupId1"] = ids&#46;Apply(getServerGroupsResult => getServerGroupsResult&#46;Groups[0]?.Id),
     *         ["nlbServerGroupId2"] = nameRegex&#46;Apply(getServerGroupsResult => getServerGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := nlb.GetServerGroups(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nlbServerGroupId1", ids.Groups[0].Id)
     * 		nameRegex, err := nlb.GetServerGroups(ctx, &nlb.GetServerGroupsArgs{
     * 			NameRegex: pulumi.StringRef("^my-ServerGroup"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("nlbServerGroupId2", nameRegex.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nlb.NlbFunctions;
     * import com.pulumi.alicloud.nlb.inputs.GetServerGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = NlbFunctions.getServerGroups();
     *         ctx.export("nlbServerGroupId1", ids.applyValue(getServerGroupsResult -> getServerGroupsResult.groups()[0].id()));
     *         final var nameRegex = NlbFunctions.getServerGroups(GetServerGroupsArgs.builder()
     *             .nameRegex("^my-ServerGroup")
     *             .build());
     *         ctx.export("nlbServerGroupId2", nameRegex.applyValue(getServerGroupsResult -> getServerGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:nlb:getServerGroups
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:nlb:getServerGroups
     *       Arguments:
     *         nameRegex: ^my-ServerGroup
     * outputs:
     *   nlbServerGroupId1: ${ids.groups[0].id}
     *   nlbServerGroupId2: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerGroups.
     * @return A collection of values returned by getServerGroups.
     */
    public suspend fun getServerGroups(argument: GetServerGroupsPlainArgs): GetServerGroupsResult =
        getServerGroupsResultToKotlin(getServerGroupsPlain(argument.toJava()).await())

    /**
     * @see [getServerGroups].
     * @param ids A list of Server Group IDs.
     * @param nameRegex A regex string to filter results by Server Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group to which the security group belongs.
     * @param serverGroupNames The names of the server groups to be queried.
     * @param serverGroupType The type of the server group. Valid values: `Instance`, `Ip`.
     * @param status The status of the resource. Valid values: `Available`, `Configuring`, `Creating`.
     * @param tags
     * @return A collection of values returned by getServerGroups.
     */
    public suspend fun getServerGroups(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        serverGroupNames: List<String>? = null,
        serverGroupType: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetServerGroupsResult {
        val argument = GetServerGroupsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            serverGroupNames = serverGroupNames,
            serverGroupType = serverGroupType,
            status = status,
            tags = tags,
        )
        return getServerGroupsResultToKotlin(getServerGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nlb&#46;kotlin&#46;inputs&#46;GetServerGroupsPlainArgs].
     * @return A collection of values returned by getServerGroups.
     */
    public suspend fun getServerGroups(argument: suspend GetServerGroupsPlainArgsBuilder.() -> Unit): GetServerGroupsResult {
        val builder = GetServerGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerGroupsResultToKotlin(getServerGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the available zones with the Network Load Balancer (NLB) Instance of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.191.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.nlb.getZones({});
     * export const firstNlbZonesId = example.then(example => example.zones?.[0]?.zoneId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.nlb.get_zones()
     * pulumi.export("firstNlbZonesId", example.zones[0].zone_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Nlb.GetZones.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstNlbZonesId"] = example&#46;Apply(getZonesResult => getZonesResult&#46;Zones[0]?.ZoneId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := nlb.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstNlbZonesId", example.Zones[0].ZoneId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.nlb.NlbFunctions;
     * import com.pulumi.alicloud.nlb.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NlbFunctions.getZones();
     *         ctx.export("firstNlbZonesId", example.applyValue(getZonesResult -> getZonesResult.zones()[0].zoneId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:nlb:getZones
     *       Arguments: {}
     * outputs:
     *   firstNlbZonesId: ${example.zones[0].zoneId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;nlb&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
