@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.nlb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [SecurityPolicy].
 */
@PulumiTagMarker
public class SecurityPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityPolicyArgs = SecurityPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityPolicyArgsBuilder.() -> Unit) {
        val builder = SecurityPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityPolicy {
        val builtJavaResource = com.pulumi.alicloud.nlb.SecurityPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityPolicy(builtJavaResource)
    }
}

/**
 * Provides a NLB Security Policy resource.
 * For information about NLB Security Policy and how to use it, see [What is Security Policy](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createsecuritypolicy-nlb).
 * > **NOTE:** Available since v1.187.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultSecurityPolicy = new alicloud.nlb.SecurityPolicy("default", {
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     securityPolicyName: name,
 *     ciphers: [
 *         "ECDHE-RSA-AES128-SHA",
 *         "ECDHE-ECDSA-AES128-SHA",
 *     ],
 *     tlsVersions: [
 *         "TLSv1.0",
 *         "TLSv1.1",
 *         "TLSv1.2",
 *     ],
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_security_policy = alicloud.nlb.SecurityPolicy("default",
 *     resource_group_id=default.ids[0],
 *     security_policy_name=name,
 *     ciphers=[
 *         "ECDHE-RSA-AES128-SHA",
 *         "ECDHE-ECDSA-AES128-SHA",
 *     ],
 *     tls_versions=[
 *         "TLSv1.0",
 *         "TLSv1.1",
 *         "TLSv1.2",
 *     ],
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultSecurityPolicy = new AliCloud.Nlb.SecurityPolicy("default", new()
 *     {
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         SecurityPolicyName = name,
 *         Ciphers = new[]
 *         {
 *             "ECDHE-RSA-AES128-SHA",
 *             "ECDHE-ECDSA-AES128-SHA",
 *         },
 *         TlsVersions = new[]
 *         {
 *             "TLSv1.0",
 *             "TLSv1.1",
 *             "TLSv1.2",
 *         },
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nlb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = nlb.NewSecurityPolicy(ctx, "default", &nlb.SecurityPolicyArgs{
 * 			ResourceGroupId:    pulumi.String(_default.Ids[0]),
 * 			SecurityPolicyName: pulumi.String(name),
 * 			Ciphers: pulumi.StringArray{
 * 				pulumi.String("ECDHE-RSA-AES128-SHA"),
 * 				pulumi.String("ECDHE-ECDSA-AES128-SHA"),
 * 			},
 * 			TlsVersions: pulumi.StringArray{
 * 				pulumi.String("TLSv1.0"),
 * 				pulumi.String("TLSv1.1"),
 * 				pulumi.String("TLSv1.2"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.nlb.SecurityPolicy;
 * import com.pulumi.alicloud.nlb.SecurityPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultSecurityPolicy = new SecurityPolicy("defaultSecurityPolicy", SecurityPolicyArgs.builder()
 *             .resourceGroupId(default_.ids()[0])
 *             .securityPolicyName(name)
 *             .ciphers(
 *                 "ECDHE-RSA-AES128-SHA",
 *                 "ECDHE-ECDSA-AES128-SHA")
 *             .tlsVersions(
 *                 "TLSv1.0",
 *                 "TLSv1.1",
 *                 "TLSv1.2")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultSecurityPolicy:
 *     type: alicloud:nlb:SecurityPolicy
 *     name: default
 *     properties:
 *       resourceGroupId: ${default.ids[0]}
 *       securityPolicyName: ${name}
 *       ciphers:
 *         - ECDHE-RSA-AES128-SHA
 *         - ECDHE-ECDSA-AES128-SHA
 *       tlsVersions:
 *         - TLSv1.0
 *         - TLSv1.1
 *         - TLSv1.2
 *       tags:
 *         Created: TF
 *         For: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * NLB Security Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:nlb/securityPolicy:SecurityPolicy example <id>
 * ```
 */
public class SecurityPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.nlb.SecurityPolicy,
) : KotlinCustomResource(javaResource, SecurityPolicyMapper) {
    /**
     * The supported cipher suites, which are determined by the TLS protocol version. You can specify at most 32 cipher suites.
     * - TLS 1.0 and TLS 1.1 support the following cipher suites: `ECDHE-ECDSA-AES128-SHA`, `ECDHE-ECDSA-AES256-SHA`, `ECDHE-RSA-AES128-SHA`, `ECDHE-RSA-AES256-SHA`, `AES128-SHA`, `AES256-SHA`, `DES-CBC3-SHA`
     * - TLS 1.2 supports the following cipher suites: `ECDHE-ECDSA-AES128-SHA`, `ECDHE-ECDSA-AES256-SHA`, `ECDHE-RSA-AES128-SHA`, `ECDHE-RSA-AES256-SHA`, `AES128-SHA`, `AES256-SHA, DES-CBC3-SHA`, `ECDHE-ECDSA-AES128-GCM-SHA256`, `ECDHE-ECDSA-AES256-GCM-SHA384`, `ECDHE-ECDSA-AES128-SHA256`, `ECDHE-ECDSA-AES256-SHA384`, `ECDHE-RSA-AES128-GCM-SHA256`, `ECDHE-RSA-AES256-GCM-SHA384`, `ECDHE-RSA-AES128-SHA256`, `ECDHE-RSA-AES256-SHA384`, `AES128-GCM-SHA256`, `AES256-GCM-SHA384`, `AES128-SHA256`, `AES256-SHA256`
     * - TLS 1.3 supports the following cipher suites: `TLS_AES_128_GCM_SHA256`, `TLS_AES_256_GCM_SHA384`, `TLS_CHACHA20_POLY1305_SHA256`, `TLS_AES_128_CCM_SHA256`, `TLS_AES_128_CCM_8_SHA256`.
     */
    public val ciphers: Output<List<String>>
        get() = javaResource.ciphers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The name of the security policy. The name must be 1 to 200 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-).
     */
    public val securityPolicyName: Output<String>
        get() = javaResource.securityPolicyName().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The supported versions of the Transport Layer Security (TLS) protocol. Valid values: `TLSv1.0`, `TLSv1.1`, `TLSv1.2`, and `TLSv1.3`. You can specify at most four TLS versions.
     */
    public val tlsVersions: Output<List<String>>
        get() = javaResource.tlsVersions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object SecurityPolicyMapper : ResourceMapper<SecurityPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.nlb.SecurityPolicy::class == javaResource::class

    override fun map(javaResource: Resource): SecurityPolicy = SecurityPolicy(
        javaResource as
            com.pulumi.alicloud.nlb.SecurityPolicy,
    )
}

/**
 * @see [SecurityPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityPolicy].
 */
public suspend fun securityPolicy(
    name: String,
    block: suspend SecurityPolicyResourceBuilder.() -> Unit,
): SecurityPolicy {
    val builder = SecurityPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityPolicy(name: String): SecurityPolicy {
    val builder = SecurityPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
